/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.tree;

import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IComponentBorder;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.html.tree.AbstractTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.util.string.Strings;

public abstract class BaseTree
extends AbstractTree {
    private static final ResourceReference CSS = new CompressedResourceReference(BaseTree.class, "res/base-tree.css");
    private static final long serialVersionUID = 1L;
    private static final String JUNCTION_LINK_ID = "junctionLink";
    private static final String NODE_COMPONENT_ID = "nodeComponent";
    private LinkType linkType = LinkType.AJAX;

    public BaseTree(String id) {
        this(id, null);
    }

    public BaseTree(String id, IModel model) {
        super(id, model);
        ResourceReference css = this.getCSS();
        if (css != null) {
            this.add(HeaderContributor.forCss(css));
        }
    }

    protected ResourceReference getCSS() {
        return CSS;
    }

    protected void populateTreeItem(WebMarkupContainer item, int level) {
        TreeNode node = (TreeNode)item.getModelObject();
        Component junctionLink = this.newJunctionLink(item, JUNCTION_LINK_ID, node);
        junctionLink.setComponentBorder(new JunctionBorder(node, level));
        item.add(junctionLink);
        Component nodeComponent = this.newNodeComponent(NODE_COMPONENT_ID, item.getModel());
        item.add(nodeComponent);
        item.add(new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                TreeNode node = (TreeNode)component.getModelObject();
                if (BaseTree.this.getTreeState().isNodeSelected(node)) {
                    CharSequence oldClass = tag.getString("class");
                    if (Strings.isEmpty(oldClass)) {
                        tag.put("class", BaseTree.this.getSelectedClass());
                    } else {
                        tag.put("class", oldClass + " " + BaseTree.this.getSelectedClass());
                    }
                }
            }
        });
    }

    protected String getSelectedClass() {
        return "selected";
    }

    protected abstract Component newNodeComponent(String var1, IModel var2);

    private static boolean isNodeLast(TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent == null) {
            return true;
        }
        return parent.getChildAt(parent.getChildCount() - 1).equals(node);
    }

    protected Component newJunctionLink(MarkupContainer parent, String id, final TreeNode node) {
        MarkupContainer junctionLink;
        if (!node.isLeaf()) {
            junctionLink = this.newLink(id, new ILinkCallback(){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    if (BaseTree.this.isNodeExpanded(node)) {
                        BaseTree.this.getTreeState().collapseNode(node);
                    } else {
                        BaseTree.this.getTreeState().expandNode(node);
                    }
                    BaseTree.this.onJunctionLinkClicked(target, node);
                    BaseTree.this.updateTree(target);
                }
            });
            junctionLink.add(new AbstractBehavior(){
                private static final long serialVersionUID = 1L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    if (BaseTree.this.isNodeExpanded(node)) {
                        tag.put("class", "junction-open");
                    } else {
                        tag.put("class", "junction-closed");
                    }
                }
            });
        } else {
            junctionLink = new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.setName("span");
                    tag.put("class", "junction-corner");
                }
            };
        }
        return junctionLink;
    }

    protected void onJunctionLinkClicked(AjaxRequestTarget target, TreeNode node) {
    }

    public MarkupContainer newLink(String id, final ILinkCallback callback) {
        if (this.getLinkType() == LinkType.REGULAR) {
            return new Link(id){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    callback.onClick(null);
                }
            };
        }
        if (this.getLinkType() == LinkType.AJAX) {
            return new AjaxLink(id){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    callback.onClick(target);
                }
            };
        }
        return new AjaxFallbackLink(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                callback.onClick(target);
            }
        };
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(LinkType linkType) {
        if (this.linkType != linkType) {
            this.linkType = linkType;
            this.invalidateAll();
        }
    }

    protected boolean isForceRebuildOnSelectionChange() {
        return false;
    }

    public static interface ILinkCallback
    extends IClusterable {
        public void onClick(AjaxRequestTarget var1);
    }

    public static final class LinkType
    extends EnumeratedType {
        public static final LinkType AJAX = new LinkType("AJAX");
        public static final LinkType AJAX_FALLBACK = new LinkType("AJAX_FALLBACK");
        public static final LinkType REGULAR = new LinkType("REGULAR");
        private static final long serialVersionUID = 1L;

        public LinkType(String name) {
            super(name);
        }
    }

    private static class JunctionBorder
    implements IComponentBorder {
        private static final long serialVersionUID = 1L;
        private final TreeNode node;
        private final int level;

        public JunctionBorder(TreeNode node, int level) {
            this.node = node;
            this.level = level;
        }

        public void renderAfter(Component component) {
            RequestCycle.get().getResponse().write("</td>");
        }

        public void renderBefore(Component component) {
            int i;
            Response response = RequestCycle.get().getResponse();
            TreeNode parent = this.node.getParent();
            CharSequence[] classes = new CharSequence[this.level];
            for (i = 0; i < this.level; ++i) {
                classes[i] = parent == null || BaseTree.isNodeLast(parent) ? "spacer" : "line";
                parent = parent.getParent();
            }
            for (i = this.level - 1; i >= 0; --i) {
                response.write("<td class=\"" + classes[i] + "\"><span></span></td>");
            }
            if (BaseTree.isNodeLast(this.node)) {
                response.write("<td class=\"half-line\">");
            } else {
                response.write("<td class=\"line\">");
            }
        }
    }
}

