/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.pages;

import org.apache.wicket.Page;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.debug.PageView;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.string.Strings;

public class ExceptionErrorPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private final transient Throwable throwable;

    public ExceptionErrorPage(Throwable throwable, final Page page) {
        this.throwable = throwable;
        this.add(new MultiLineLabel("exception", Strings.toString(throwable)));
        String resource = "";
        String markup = "";
        MarkupStream markupStream = null;
        if (throwable instanceof MarkupException && (markupStream = ((MarkupException)throwable).getMarkupStream()) != null) {
            markup = markupStream.toHtmlDebugString();
            resource = markupStream.getResource().toString();
        }
        MultiLineLabel markupLabel = new MultiLineLabel("markup", markup);
        markupLabel.setEscapeModelStrings(false);
        WebMarkupContainer markupHighlight = new WebMarkupContainer("markupHighlight");
        markupHighlight.add(markupLabel);
        markupHighlight.add(new Label("resource", resource));
        this.add(markupHighlight);
        markupHighlight.setVisible(markupStream != null);
        this.add(new Link("displayPageViewLink"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                ExceptionErrorPage.this.replace(new PageView("componentTree", page));
                this.setVisible(false);
            }
        });
        this.add(new Label("componentTree", ""));
    }

    protected void configureResponse() {
        super.configureResponse();
        if (this.getWebRequestCycle().getResponse() instanceof WebResponse) {
            this.getWebRequestCycle().getWebResponse().getHttpServletResponse().setStatus(500);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isErrorPage() {
        return true;
    }

    public boolean isVersioned() {
        return false;
    }
}

