/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.IResponseFilter;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTimeFilter
implements IResponseFilter {
    private static final Logger log = LoggerFactory.getLogger((Class)ServerTimeFilter.class);

    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int index = responseBuffer.indexOf("<head>");
        long timeTaken = System.currentTimeMillis() - RequestCycle.get().getStartTime();
        if (index != -1) {
            AppendingStringBuffer script = new AppendingStringBuffer(75);
            script.append("\n");
            script.append("<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
            script.append("\nwindow.defaultStatus='Server time: ");
            script.append((double)timeTaken / 1000.0);
            script.append("s';\n");
            script.append("\n/*-->]]>*/</script>\n");
            script.append("\n");
            responseBuffer.insert(index + 6, script);
        }
        log.info(timeTaken + "ms server time taken for request " + RequestCycle.get().getRequest().getURL() + " response size: " + responseBuffer.length());
        return responseBuffer;
    }
}

