/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import java.lang.ref.WeakReference;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.util.concurrent.ConcurrentReaderHashMap;

public final class DefaultClassResolver
implements IClassResolver {
    private final ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class resolveClass(String classname) throws ClassNotFoundException {
        Class<Comparable<Byte>> clazz = null;
        WeakReference ref = (WeakReference)this.classes.get(classname);
        if (ref != null) {
            clazz = (Class<Byte>)ref.get();
        }
        if (clazz == null) {
            if (classname.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (classname.equals("short")) {
                clazz = Short.TYPE;
            } else if (classname.equals("int")) {
                clazz = Integer.TYPE;
            } else if (classname.equals("long")) {
                clazz = Long.TYPE;
            } else if (classname.equals("float")) {
                clazz = Float.TYPE;
            } else if (classname.equals("double")) {
                clazz = Double.TYPE;
            } else if (classname.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (classname.equals("char")) {
                clazz = Character.TYPE;
            } else {
                ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
                synchronized (concurrentReaderHashMap) {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = DefaultClassResolver.class.getClassLoader();
                    }
                    clazz = loader.loadClass(classname);
                }
                this.classes.put(classname, new WeakReference<Class<Byte>>(clazz));
            }
        }
        return clazz;
    }
}

