/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.environment.servlet;

import javax.servlet.ServletContextEvent;
import org.jboss.webbeans.bootstrap.api.Bootstrap;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.environment.servlet.discovery.TomcatWebBeanDiscovery;
import org.jboss.webbeans.environment.servlet.resources.TomcatResourceServices;
import org.jboss.webbeans.environment.servlet.util.Reflections;
import org.jboss.webbeans.environment.tomcat.WebBeansAnnotationProcessor;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.manager.api.WebBeansManager;
import org.jboss.webbeans.resources.spi.ResourceServices;
import org.jboss.webbeans.servlet.api.ServletListener;
import org.jboss.webbeans.servlet.api.helpers.ForwardingServletListener;

public class Listener
extends ForwardingServletListener {
    private static final Log log = Logging.getLog(Listener.class);
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.webbeans.bootstrap.WebBeansBootstrap";
    private static final String WEB_BEANS_LISTENER_CLASS_NAME = "org.jboss.webbeans.servlet.WebBeansListener";
    private static final String APPLICATION_BEAN_STORE_ATTRIBUTE_NAME = Listener.class.getName() + ".applicationBeanStore";
    private final transient Bootstrap bootstrap;
    private final transient ServletListener webBeansListener;
    private WebBeansManager manager;

    public Listener() {
        try {
            this.bootstrap = Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME, Bootstrap.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading Web Beans bootstrap, check that Web Beans is on the classpath", e);
        }
        try {
            this.webBeansListener = Reflections.newInstance(WEB_BEANS_LISTENER_CLASS_NAME, ServletListener.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading Web Beans listener, check that Web Beans is on the classpath", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.manager.shutdown();
        super.contextDestroyed(sce);
    }

    public void contextInitialized(ServletContextEvent sce) {
        ConcurrentHashMapBeanStore applicationBeanStore = new ConcurrentHashMapBeanStore();
        sce.getServletContext().setAttribute(APPLICATION_BEAN_STORE_ATTRIBUTE_NAME, (Object)applicationBeanStore);
        this.bootstrap.setEnvironment(Environments.SERVLET);
        this.bootstrap.getServices().add(WebBeanDiscovery.class, new TomcatWebBeanDiscovery(sce.getServletContext()){});
        try {
            this.bootstrap.getServices().add(ResourceServices.class, new TomcatResourceServices(){});
        }
        catch (NoClassDefFoundError e) {
            log.warn((Object)"@Resource injection not available in simple beans", new Object[0]);
        }
        this.bootstrap.setApplicationContext(applicationBeanStore);
        this.bootstrap.initialize();
        this.manager = this.bootstrap.getManager();
        boolean tomcat = true;
        try {
            Reflections.loadClass("org.apache.AnnotationProcessor", Object.class);
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"JSR-299 injection will not be available in Servlets, Filters etc. This facility is only available in Tomcat", new Object[0]);
            tomcat = false;
        }
        catch (NoClassDefFoundError e) {
            log.info((Object)"JSR-299 injection will not be available in Servlets, Filters etc. This facility is only available in Tomcat", new Object[0]);
            tomcat = false;
        }
        if (tomcat) {
            try {
                Class<Object> clazz = Reflections.loadClass(WebBeansAnnotationProcessor.class.getName(), Object.class);
                Object annotationProcessor = clazz.getConstructor(WebBeansManager.class).newInstance(this.manager);
                sce.getServletContext().setAttribute(WebBeansAnnotationProcessor.class.getName(), annotationProcessor);
            }
            catch (Exception e) {
                log.error((Object)"Unable to create Tomcat AnnotationProcessor. JSR-299 injection will not be available in Servlets, Filters etc.", e, new Object[0]);
            }
        }
        this.bootstrap.boot();
        super.contextInitialized(sce);
    }

    protected ServletListener delegate() {
        return this.webBeansListener;
    }
}

