/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.util.concurrent.atomic.AtomicInteger;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.Dependent;
import org.jboss.webbeans.context.AbstractContext;
import org.jboss.webbeans.context.ContextualInstance;
import org.jboss.webbeans.context.DependentStorageRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentContext
extends AbstractContext {
    private static DependentContext INSTANCE;
    private final ThreadLocal<AtomicInteger> reentrantActiveCount;
    private final ThreadLocal<DependentStorageRequest> dependentStorageRequest;

    public static DependentContext instance() {
        return INSTANCE;
    }

    public static DependentContext create() {
        INSTANCE = new DependentContext();
        return DependentContext.instance();
    }

    public DependentContext() {
        super(Dependent.class);
        super.setActive(false);
        this.reentrantActiveCount = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger(0);
            }
        };
        this.dependentStorageRequest = new ThreadLocal();
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (creationalContext != null) {
            T instance = contextual.create(creationalContext);
            if (this.dependentStorageRequest.get() != null) {
                this.dependentStorageRequest.get().getDependentInstancesStore().addDependentInstance(this.dependentStorageRequest.get().getKey(), ContextualInstance.of(contextual, instance));
            }
            return instance;
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public String toString() {
        String active = this.isActive() ? "Active " : "Inactive ";
        return active + "dependent context";
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            if (this.reentrantActiveCount.get().incrementAndGet() == 1) {
                super.setActive(true);
            }
        } else if (this.reentrantActiveCount.get().decrementAndGet() == 0) {
            super.setActive(false);
        }
    }

    public void startCollectingDependents(DependentStorageRequest dependentStorageRequest) {
        if (this.dependentStorageRequest.get() == null) {
            this.dependentStorageRequest.set(dependentStorageRequest);
        }
    }

    public void stopCollectingDependents(DependentStorageRequest dependentStorageRequest) {
        if (this.dependentStorageRequest.get() != null && this.dependentStorageRequest.get().equals(dependentStorageRequest)) {
            this.dependentStorageRequest.set(null);
        }
    }
}

