/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.StateManager;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CacheRetrieveFieldManager
extends AbstractFieldManager {
    StateManager sm;
    CachedPC cachedPC;

    public CacheRetrieveFieldManager(StateManager sm, CachedPC cachedPC) {
        this.sm = sm;
        this.cachedPC = cachedPC;
    }

    public Object fetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (value == null) {
            Object relationFieldValue = this.cachedPC.getRelationField(fmd.getName());
            if (relationFieldValue != null) {
                if (Collection.class.isAssignableFrom(relationFieldValue.getClass())) {
                    Collection coll = (Collection)relationFieldValue;
                    try {
                        Collection fieldColl = (Collection)coll.getClass().newInstance();
                        for (Object elementOid : coll) {
                            Object element = this.sm.getObjectManager().findObject(elementOid, null);
                            fieldColl.add(element);
                        }
                        return fieldColl;
                    }
                    catch (Exception e) {
                        NucleusLogger.CACHE.error("Exception thrown creating value for field " + fmd.getFullFieldName() + " of type " + relationFieldValue.getClass().getName(), e);
                        return null;
                    }
                }
                if (Map.class.isAssignableFrom(relationFieldValue.getClass())) {
                    Map map = (Map)relationFieldValue;
                    try {
                        Map fieldMap = (Map)map.getClass().newInstance();
                        for (Map.Entry entry : map.entrySet()) {
                            Object mapKey = null;
                            mapKey = fmd.getMap().keyIsPersistent() ? this.sm.getObjectManager().findObject(entry.getKey(), null) : (Object)entry.getKey();
                            Object mapValue = null;
                            mapValue = fmd.getMap().valueIsPersistent() ? this.sm.getObjectManager().findObject(entry.getValue(), null) : (Object)entry.getValue();
                            fieldMap.put(mapKey, mapValue);
                        }
                        return fieldMap;
                    }
                    catch (Exception e) {
                        NucleusLogger.CACHE.error("Exception thrown creating value for field " + fmd.getFullFieldName() + " of type " + relationFieldValue.getClass().getName(), e);
                        return null;
                    }
                }
                if (relationFieldValue.getClass().isArray()) {
                    try {
                        Object[] elementOIDs = (Object[])relationFieldValue;
                        Object fieldArr = Array.newInstance(fmd.getType().getComponentType(), elementOIDs.length);
                        for (int i = 0; i < elementOIDs.length; ++i) {
                            Object element = this.sm.getObjectManager().findObject(elementOIDs[i], null);
                            Array.set(fieldArr, i, element);
                        }
                        return fieldArr;
                    }
                    catch (NucleusException ne) {
                        NucleusLogger.CACHE.error("Exception thrown trying to find element of array while getting object with id " + this.sm.getInternalObjectId() + " from the L2 cache", ne);
                        return null;
                    }
                }
                try {
                    Object fieldPC = this.sm.getObjectManager().findObject(relationFieldValue, null);
                    NucleusLogger.CACHE.debug("CacheRetrieveFM.fetchObjectField oid=" + relationFieldValue + " will use " + StringUtils.toJVMIDString(fieldPC));
                    return fieldPC;
                }
                catch (NucleusObjectNotFoundException nonfe) {
                    return null;
                }
            }
            return null;
        }
        return value;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchBooleanField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchByteField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchCharField(fieldNumber);
    }

    public double fetchDoubleField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchDoubleField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchFloatField(fieldNumber);
    }

    public int fetchIntField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchIntField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchLongField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchShortField(fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchStringField(fieldNumber);
    }
}

