/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Entity
implements Serializable {
    static final long serialVersionUID = -836647825120453511L;
    public static final String KEY_RESERVED_PROPERTY = "__key__";
    private final Key key;
    private final Map<String, Object> propertyMap;

    public Entity(String kind) {
        this(kind, (Key)null);
    }

    public Entity(String kind, Key parent) {
        this(new Key(kind, parent));
    }

    public Entity(String kind, String keyName) {
        this(KeyFactory.createKey(kind, keyName));
    }

    public Entity(String kind, String keyName, Key parent) {
        this(parent == null ? KeyFactory.createKey(kind, keyName) : parent.getChild(kind, keyName));
    }

    Entity(Key key) {
        this.key = key;
        this.propertyMap = new HashMap<String, Object>();
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            Entity otherEntity = (Entity)object;
            return this.key.equals(otherEntity.key);
        }
        return false;
    }

    public Key getKey() {
        return this.key;
    }

    public String getKind() {
        return this.key.getKind();
    }

    public Key getParent() {
        return this.key.getParent();
    }

    public Object getProperty(String propertyName) {
        return Entity.unwrapValue(this.propertyMap.get(propertyName));
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.propertyMap.size());
        for (Map.Entry<String, Object> entry : this.propertyMap.entrySet()) {
            properties.put(entry.getKey(), Entity.unwrapValue(entry.getValue()));
        }
        return Collections.unmodifiableMap(properties);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean hasProperty(String propertyName) {
        return this.propertyMap.containsKey(propertyName);
    }

    public void removeProperty(String propertyName) {
        this.propertyMap.remove(propertyName);
    }

    public void setProperty(String propertyName, Object value) {
        DataTypeUtils.checkSupportedValue(value);
        this.propertyMap.put(propertyName, value);
    }

    public void setUnindexedProperty(String propertyName, Object value) {
        DataTypeUtils.checkSupportedValue(value);
        this.propertyMap.put(propertyName, new UnindexedValue(value));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<Entity [" + this.key + "]:\n");
        for (Map.Entry<String, Object> entry : this.propertyMap.entrySet()) {
            buffer.append("\t" + entry.getKey() + " = " + entry.getValue() + "\n");
        }
        buffer.append(">\n");
        return buffer.toString();
    }

    public String getAppId() {
        return this.key.getAppId();
    }

    static Object unwrapValue(Object obj) {
        if (obj instanceof UnindexedValue) {
            return ((UnindexedValue)obj).getValue();
        }
        return obj;
    }

    Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    static final class UnindexedValue
    implements Serializable {
        private final Object value;

        UnindexedValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object that) {
            if (that instanceof UnindexedValue) {
                UnindexedValue uv = (UnindexedValue)that;
                return this.value == null ? uv.value == null : this.value.equals(uv.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return this.value + " (unindexed)";
        }
    }
}

