/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionCleanupServlet
extends HttpServlet {
    static final String SESSION_ENTITY_TYPE = "_ah_SESSION";
    static final String EXPIRES_PROP = "_expires";
    private DatastoreService datastore;
    private MemcacheService memcache;

    public void init() {
        this.datastore = DatastoreServiceFactory.getDatastoreService();
        this.memcache = MemcacheServiceFactory.getMemcacheService();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        if ("clear".equals(request.getQueryString())) {
            this.clearAll(response);
        } else {
            this.sendForm(request.getRequestURI() + "?clear", response);
        }
    }

    private void clearAll(HttpServletResponse response) {
        Query query = new Query(SESSION_ENTITY_TYPE);
        query.addFilter(EXPIRES_PROP, Query.FilterOperator.LESS_THAN, System.currentTimeMillis());
        ArrayList<Key> killList = new ArrayList<Key>();
        for (Entity expiredSession : this.datastore.prepare(query).asIterable()) {
            Key key = expiredSession.getKey();
            killList.add(key);
        }
        this.datastore.delete(killList);
        response.setStatus(200);
        try {
            response.getWriter().println("Cleared " + killList.size() + " expired sessions.");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void sendForm(String actionUrl, HttpServletResponse response) {
        Query query = new Query(SESSION_ENTITY_TYPE);
        query.addFilter(EXPIRES_PROP, Query.FilterOperator.LESS_THAN, System.currentTimeMillis());
        int count = this.datastore.prepare(query).countEntities();
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        try {
            PrintWriter writer = response.getWriter();
            writer.println("<html><head><title>Session Cleanup</title></head>");
            writer.println("<body>There are currently " + count + " expired sessions.");
            writer.println("<p><form method=\"POST\" action=\"" + actionUrl + "\">");
            writer.println("<input type=\"submit\" value=\"Erase them all\" >");
            writer.println("</form></body></html>");
        }
        catch (IOException ex) {
            response.setStatus(500);
            try {
                response.getWriter().println(ex);
            }
            catch (IOException innerEx) {
                // empty catch block
            }
        }
        response.setStatus(200);
    }
}

