/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.ReferenceType;
import com.google.appengine.repackaged.com.google.common.collect.ComputationException;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingConcurrentMap;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.ReferenceMap;
import com.google.appengine.repackaged.com.google.common.collect.UncheckedThrower;
import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CancelableReferenceCache<K, V>
extends ForwardingConcurrentMap<K, V>
implements Serializable {
    final ConcurrentMap<K, V> map;
    static final Object CANCELLED = new Object(){

        public String toString() {
            throw new UnsupportedOperationException();
        }
    };
    private static final long serialVersionUID = 0L;

    V cancelled() {
        return (V)CANCELLED;
    }

    public CancelableReferenceCache(ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        MapMaker maker = new MapMaker();
        ReferenceMap.configureStrengths(maker, keyReferenceType, valueReferenceType);
        this.map = maker.makeComputingMap(new FunctionAdapter());
    }

    public CancelableReferenceCache() {
        this(ReferenceType.STRONG, ReferenceType.STRONG);
    }

    protected abstract V create(K var1, Runnable var2);

    @Override
    protected ConcurrentMap<K, V> delegate() {
        return this.map;
    }

    @Override
    public V get(Object key) {
        try {
            Object value = this.map.get(key);
            if (value == this.cancelled()) {
                throw new CancellationException();
            }
            return value;
        }
        catch (ComputationException e) {
            UncheckedThrower.throwAsUnchecked(e.getCause());
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FunctionAdapter
    implements Function<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private FunctionAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V apply(final K key) {
            final boolean[] cancelled = new boolean[]{false};
            try {
                Object v = CancelableReferenceCache.this.create(key, new Runnable(){

                    public void run() {
                        cancelled[0] = true;
                        CancelableReferenceCache.this.map.put(key, CancelableReferenceCache.this.cancelled());
                        CancelableReferenceCache.this.map.remove(key);
                    }
                });
                return v;
            }
            finally {
                if (cancelled[0]) {
                    throw new CancellationException();
                }
            }
        }
    }
}

