/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.net.rpc.DefaultStubCreationFilter;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcInterface;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc.StubCreationFilter;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.BlockingApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.ssl.SslSecurityLevel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class URLFetchServicePb {
    private URLFetchServicePb() {
    }

    public static final class URLFetchService {
        private static volatile StubCreationFilter stubCreationFilter_ = new DefaultStubCreationFilter();
        private static final RpcStubFactory stubFactory_ = new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new SimpleStub(stubCreationFilter_.filterStubParameters("URLFetchService", params));
            }
        };

        private URLFetchService() {
        }

        public static void setStubCreationFilter(StubCreationFilter filter) {
            stubCreationFilter_ = filter == null ? new DefaultStubCreationFilter() : filter;
        }

        public static RpcStubFactory stubFactory() {
            return stubFactory_;
        }

        public static BlockingStub newBlockingStub(RpcStubParameters params) {
            return new BlockingStub(stubCreationFilter_.filterStubParameters("URLFetchService", params));
        }

        public static Stub newStub(RpcStubParameters params) {
            return new Stub(stubCreationFilter_.filterStubParameters("URLFetchService", params));
        }

        public static ServerConfig exportService(Interface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            URLFetchService.exportServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportServiceUsingConfig(final Interface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Fetch", (ProtocolMessage)new URLFetchRequest(), (ProtocolMessage)new URLFetchResponse(), null, config.Fetch_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.fetch(rpc, (URLFetchRequest)rpc.internalRequest(), (URLFetchResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
        }

        public static RpcService newService(final Interface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return URLFetchService.exportService(impl, registry);
                }
            };
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            URLFetchService.exportBlockingServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(final BlockingInterface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Fetch", (ProtocolMessage)new URLFetchRequest(), (ProtocolMessage)new URLFetchResponse(), null, config.Fetch_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public URLFetchResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.fetch(rpc, (URLFetchRequest)rpc.internalRequest());
                }
            });
        }

        public static RpcService newBlockingService(final BlockingInterface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return URLFetchService.exportBlockingService(impl, registry);
                }
            };
        }

        public static void unexport(RpcHandlerRegistry registry) {
            registry.unregisterService("URLFetchService");
        }

        public static class ServerConfig
        extends RpcServerConfig {
            final RpcServerParameters Fetch_parameters_ = new RpcServerParameters();

            public ServerConfig() {
                this("URLFetchService");
            }

            public ServerConfig(String serviceName) {
                super(serviceName);
            }

            public void setRpcRunner(Executor t) {
                this.setRpcRunner_Fetch(t);
            }

            public void setRpcRunner_Fetch(Executor t) {
                this.Fetch_parameters_.setRpcRunner(t);
            }

            public void setServerLogging_Fetch(int t) {
                this.Fetch_parameters_.setServerLogging(t);
            }

            public void setSecurityLevel_Fetch(SslSecurityLevel t) {
                this.Fetch_parameters_.setSecurityLevel(t);
            }

            public void setRpcCancelCallback_Fetch(RpcCancelCallback t) {
                this.Fetch_parameters_.setRpcCancelCallback(t);
            }
        }

        public static class Stub
        extends BlockingStub
        implements Interface {
            Stub(RpcStubParameters params) {
                super(params);
            }

            public void fetch(RPC rpc, URLFetchRequest req, URLFetchResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Fetch_method_, "Fetch", req, reply, cb, this.Fetch_parameters_);
            }
        }

        public static interface Interface
        extends RpcInterface {
            public void fetch(RPC var1, URLFetchRequest var2, URLFetchResponse var3, RpcCallback var4);
        }

        public static class BlockingStub
        extends BaseStub
        implements BlockingInterface {
            BlockingStub(RpcStubParameters params) {
                super(params);
            }

            public URLFetchResponse fetch(RPC rpc, URLFetchRequest req) throws RpcException {
                URLFetchResponse reply = new URLFetchResponse();
                this.startBlockingRpc(rpc, this.Fetch_method_, "Fetch", req, reply, this.Fetch_parameters_);
                return reply;
            }
        }

        public static interface BlockingInterface
        extends RpcInterface {
            public URLFetchResponse fetch(RPC var1, URLFetchRequest var2) throws RpcException;
        }

        private static class BaseStub
        extends RpcStub {
            protected final String Fetch_method_;
            protected final RPC Fetch_parameters_ = this.newRpcPrototype(Method.Fetch);

            protected BaseStub(RpcStubParameters params) {
                super("URLFetchService", params, Method.class);
                this.Fetch_method_ = this.makeFullMethodName("Fetch");
            }
        }

        private static class SimpleStub
        extends RpcStub {
            public SimpleStub(RpcStubParameters params) {
                super("URLFetchService", params, Method.class);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Method {
            Fetch;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLFetchResponse
    extends ProtocolMessage<URLFetchResponse> {
        private static final long serialVersionUID = 1L;
        private byte[] content_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private int statuscode_ = 0;
        private List<Header> header_ = null;
        private boolean contentwastruncated_ = false;
        private long externalbytessent_ = 0L;
        private long externalbytesreceived_ = 0L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final URLFetchResponse IMMUTABLE_DEFAULT_INSTANCE = new URLFetchResponse(){
            private static final long serialVersionUID = 1L;

            public URLFetchResponse clearContent() {
                return this;
            }

            public URLFetchResponse setContentAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchResponse setContent(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchResponse setContent(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchResponse clearStatusCode() {
                return this;
            }

            public URLFetchResponse setStatusCode(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchResponse clearHeader() {
                return this;
            }

            public Header getMutableHeader(int i) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header addHeader() {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header addHeader(Header v) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header insertHeader(int i, Header v) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header removeHeader(int i) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public URLFetchResponse clearContentWasTruncated() {
                return this;
            }

            public URLFetchResponse setContentWasTruncated(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchResponse clearExternalBytesSent() {
                return this;
            }

            public URLFetchResponse setExternalBytesSent(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchResponse clearExternalBytesReceived() {
                return this;
            }

            public URLFetchResponse setExternalBytesReceived(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchResponse mergeFrom(URLFetchResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public URLFetchResponse freeze() {
                return this;
            }

            public URLFetchResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kContent = 1;
        public static final int kStatusCode = 2;
        public static final int kHeaderGroup = 3;
        public static final int kHeaderKey = 4;
        public static final int kHeaderValue = 5;
        public static final int kContentWasTruncated = 6;
        public static final int kExternalBytesSent = 7;
        public static final int kExternalBytesReceived = 8;
        public static final String[] text = new String[9];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getContentAsBytes() {
            return this.content_;
        }

        public final boolean hasContent() {
            return (this.optional_0_ & 1) != 0;
        }

        public URLFetchResponse clearContent() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.content_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public URLFetchResponse setContentAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.content_ = x;
            return this;
        }

        public final String getContent() {
            return ProtocolSupport.toStringUtf8(this.content_);
        }

        public URLFetchResponse setContent(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.content_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getContent(Charset cs) {
            return ProtocolSupport.toString(this.content_, cs);
        }

        public URLFetchResponse setContent(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.content_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final int getStatusCode() {
            return this.statuscode_;
        }

        public final boolean hasStatusCode() {
            return (this.optional_0_ & 2) != 0;
        }

        public URLFetchResponse clearStatusCode() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.statuscode_ = 0;
            return this;
        }

        public URLFetchResponse setStatusCode(int x) {
            this.optional_0_ |= 2;
            this.statuscode_ = x;
            return this;
        }

        public final int headerSize() {
            return this.header_ != null ? this.header_.size() : 0;
        }

        public final Header getHeader(int i) {
            assert (i >= 0 && i < (this.header_ != null ? this.header_.size() : 0));
            return this.header_.get(i);
        }

        public URLFetchResponse clearHeader() {
            if (this.header_ != null) {
                this.header_.clear();
            }
            return this;
        }

        public Header getMutableHeader(int i) {
            assert (i >= 0 && this.header_ != null && i < this.header_.size());
            return this.header_.get(i);
        }

        public Header addHeader() {
            Header v = new Header();
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(v);
            return v;
        }

        public Header addHeader(Header v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(v);
            return v;
        }

        public Header insertHeader(int i, Header v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(i, v);
            return v;
        }

        public Header removeHeader(int i) {
            return this.header_.remove(i);
        }

        public final Iterator<Header> headerIterator() {
            if (this.header_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.header_.iterator();
        }

        public final List<Header> headers() {
            return ProtocolSupport.unmodifiableList(this.header_);
        }

        public final List<Header> mutableHeaders() {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            return this.header_;
        }

        public final boolean isContentWasTruncated() {
            return this.contentwastruncated_;
        }

        public final boolean hasContentWasTruncated() {
            return (this.optional_0_ & 4) != 0;
        }

        public URLFetchResponse clearContentWasTruncated() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.contentwastruncated_ = false;
            return this;
        }

        public URLFetchResponse setContentWasTruncated(boolean x) {
            this.optional_0_ |= 4;
            this.contentwastruncated_ = x;
            return this;
        }

        public final long getExternalBytesSent() {
            return this.externalbytessent_;
        }

        public final boolean hasExternalBytesSent() {
            return (this.optional_0_ & 8) != 0;
        }

        public URLFetchResponse clearExternalBytesSent() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.externalbytessent_ = 0L;
            return this;
        }

        public URLFetchResponse setExternalBytesSent(long x) {
            this.optional_0_ |= 8;
            this.externalbytessent_ = x;
            return this;
        }

        public final long getExternalBytesReceived() {
            return this.externalbytesreceived_;
        }

        public final boolean hasExternalBytesReceived() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public URLFetchResponse clearExternalBytesReceived() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.externalbytesreceived_ = 0L;
            return this;
        }

        public URLFetchResponse setExternalBytesReceived(long x) {
            this.optional_0_ |= 0x10;
            this.externalbytesreceived_ = x;
            return this;
        }

        @Override
        public URLFetchResponse mergeFrom(URLFetchResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.content_ = that.content_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.statuscode_ = that.statuscode_;
            }
            if (that.header_ != null) {
                for (Header v : that.header_) {
                    this.addHeader().mergeFrom(v);
                }
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.contentwastruncated_ = that.contentwastruncated_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.externalbytessent_ = that.externalbytessent_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.externalbytesreceived_ = that.externalbytesreceived_;
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(URLFetchResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(URLFetchResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(URLFetchResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFDF) != (that_t0 & 0xFFFFFFDF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.content_, that.content_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.statuscode_ != that.statuscode_) {
                return false;
            }
            int n = this.header_ != null ? this.header_.size() : 0;
            if (n != (that.header_ != null ? that.header_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.header_.get(i).equals(that.header_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 4) != 0 && this.contentwastruncated_ != that.contentwastruncated_) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.externalbytessent_ != that.externalbytessent_) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && this.externalbytesreceived_ != that.externalbytesreceived_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x20) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof URLFetchResponse && this.equals((URLFetchResponse)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -1294680166;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.content_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? this.statuscode_ : -113);
            hash *= 31;
            int n2 = n = this.header_ != null ? this.header_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.header_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 4) != 0 ? (this.contentwastruncated_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? ProtocolSupport.hashCode(this.externalbytessent_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? ProtocolSupport.hashCode(this.externalbytesreceived_) : -113);
            if ((this_t0 & 0x20) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 2) {
                return "missing field: StatusCode";
            }
            if (this.header_ != null) {
                for (Header v : this.header_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.varLongSize(this.statuscode_);
            int m = this.header_ != null ? this.header_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.header_.get(i).encodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1D) != 0) {
                if ((this_t0 & 1) != 0) {
                    n += 1 + Protocol.stringSize(this.content_.length);
                }
                if ((this_t0 & 4) != 0) {
                    n += 2;
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.varLongSize(this.externalbytessent_);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 1 + Protocol.varLongSize(this.externalbytesreceived_);
                }
            }
            return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 35;
            int m = this.header_ != null ? this.header_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.header_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.content_.length;
            }
            return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x20;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.content_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.statuscode_ = 0;
            if (this.header_ != null) {
                this.header_.clear();
            }
            this.contentwastruncated_ = false;
            this.externalbytessent_ = 0L;
            this.externalbytesreceived_ = 0L;
            this.uninterpreted = null;
        }

        @Override
        public URLFetchResponse newInstance() {
            return new URLFetchResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)10);
                sink.putPrefixedData(this.content_);
            }
            sink.putByte((byte)16);
            sink.putVarLong(this.statuscode_);
            int n = m = this.header_ != null ? this.header_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Header v = this.header_.get(i);
                sink.putByte((byte)27);
                v.outputTo(sink);
            }
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)48);
                sink.putBoolean(this.contentwastruncated_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)56);
                sink.putVarLong(this.externalbytessent_);
            }
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)64);
                sink.putVarLong(this.externalbytesreceived_);
            }
            if ((this_t0 & 0x20) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block9: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block9;
                    }
                    case 10: {
                        this.content_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block9;
                    }
                    case 16: {
                        this.statuscode_ = source.getVarInt();
                        this_t0 |= 2;
                        continue block9;
                    }
                    case 27: {
                        if (this.addHeader().merge(source)) continue block9;
                        result = false;
                        break block9;
                    }
                    case 48: {
                        this.contentwastruncated_ = source.getBoolean();
                        this_t0 |= 4;
                        continue block9;
                    }
                    case 56: {
                        this.externalbytessent_ = source.getVarLong();
                        this_t0 |= 8;
                        continue block9;
                    }
                    case 64: {
                        this.externalbytesreceived_ = source.getVarLong();
                        this_t0 |= 0x10;
                        continue block9;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x20;
                        continue block9;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public URLFetchResponse freeze() {
            this.content_ = ProtocolSupport.freezeString(this.content_);
            this.header_ = ProtocolSupport.freezeMessages(this.header_);
            return this;
        }

        @Override
        public URLFetchResponse unfreeze() {
            this.header_ = ProtocolSupport.unfreezeMessages(this.header_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.header_);
        }

        static {
            URLFetchResponse.text[0] = "ErrorCode";
            URLFetchResponse.text[1] = "Content";
            URLFetchResponse.text[2] = "StatusCode";
            URLFetchResponse.text[3] = "Header";
            URLFetchResponse.text[4] = "Key";
            URLFetchResponse.text[5] = "Value";
            URLFetchResponse.text[6] = "ContentWasTruncated";
            URLFetchResponse.text[7] = "ExternalBytesSent";
            URLFetchResponse.text[8] = "ExternalBytesReceived";
            types = new int[9];
            Arrays.fill(types, 6);
            URLFetchResponse.types[0] = 0;
            URLFetchResponse.types[1] = 2;
            URLFetchResponse.types[2] = 0;
            URLFetchResponse.types[3] = 3;
            URLFetchResponse.types[4] = 2;
            URLFetchResponse.types[5] = 2;
            URLFetchResponse.types[6] = 0;
            URLFetchResponse.types[7] = 0;
            URLFetchResponse.types[8] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(URLFetchResponse.class, "Z%apphosting/api/urlfetch_service.proto\n\u001bapphosting.URLFetchResponse\u0013\u001a\u0007Content \u0001(\u00020\t8\u0001\u0014\u0013\u001a\nStatusCode \u0002(\u00000\u00058\u0002\u0014\u0013\u001a\u0006Header \u0003(\u00030\n8\u0003\u0014\u0013\u001a\nHeader.Key \u0004(\u00020\t8\u0002`\u0002\u0014\u0013\u001a\fHeader.Value \u0005(\u00020\t8\u0002`\u0002\u0014\u0013\u001a\u0013ContentWasTruncated \u0006(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014\u0013\u001a\u0011ExternalBytesSent \u0007(\u00000\u00038\u0001\u0014\u0013\u001a\u0015ExternalBytesReceived \b(\u00000\u00038\u0001\u0014", new ProtocolType.FieldType("Content", "content", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("StatusCode", "statuscode", 2, 1, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("Header", "header", 3, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Header.class), new ProtocolType.FieldType("ContentWasTruncated", "contentwastruncated", 6, 2, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("ExternalBytesSent", "externalbytessent", 7, 3, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("ExternalBytesReceived", "externalbytesreceived", 8, 4, ProtocolType.FieldBaseType.INT64, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Header
        extends ProtocolMessage<Header> {
            private static final long serialVersionUID = 1L;
            private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Header IMMUTABLE_DEFAULT_INSTANCE = new Header(){
                private static final long serialVersionUID = 1L;

                public Header clearKey() {
                    return this;
                }

                public Header setKeyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setKey(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setKey(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header clearValue() {
                    return this;
                }

                public Header setValueAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setValue(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setValue(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header mergeFrom(Header that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Header freeze() {
                    return this;
                }

                public Header unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getKeyAsBytes() {
                return this.key_;
            }

            public final boolean hasKey() {
                return (this.optional_0_ & 1) != 0;
            }

            public Header clearKey() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Header setKeyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.key_ = x;
                return this;
            }

            public final String getKey() {
                return ProtocolSupport.toStringUtf8(this.key_);
            }

            public Header setKey(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getKey(Charset cs) {
                return ProtocolSupport.toString(this.key_, cs);
            }

            public Header setKey(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final byte[] getValueAsBytes() {
                return this.value_;
            }

            public final boolean hasValue() {
                return (this.optional_0_ & 2) != 0;
            }

            public Header clearValue() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Header setValueAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.value_ = x;
                return this;
            }

            public final String getValue() {
                return ProtocolSupport.toStringUtf8(this.value_);
            }

            public Header setValue(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getValue(Charset cs) {
                return ProtocolSupport.toString(this.value_, cs);
            }

            public Header setValue(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            @Override
            public Header mergeFrom(Header that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.key_ = that.key_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.value_ = that.value_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Header that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Header that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Header that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.value_, that.value_)) {
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Header && this.equals((Header)that);
            }

            @Override
            public int hashCode() {
                int hash = -1889292356;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.value_) : -113);
                if ((this_t0 & 4) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return "missing field: Header.Key";
                    }
                    return "missing field: Header.Value";
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 3 + Protocol.stringSize(this.key_.length) + Protocol.stringSize(this.value_.length);
                int this_t0 = this.optional_0_;
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 13 + this.key_.length + this.value_.length;
                int this_t0 = this.optional_0_;
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 4;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.uninterpreted = null;
            }

            @Override
            public Header newInstance() {
                return new Header();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)34);
                sink.putPrefixedData(this.key_);
                sink.putByte((byte)42);
                sink.putPrefixedData(this.value_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)28);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 28: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 34: {
                            this.key_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 42: {
                            this.value_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 4;
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Header freeze() {
                this.key_ = ProtocolSupport.freezeString(this.key_);
                this.value_ = ProtocolSupport.freezeString(this.value_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Header.class, null, new ProtocolType.FieldType("Key", "key", 4, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("Value", "value", 5, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED));

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLFetchRequest
    extends ProtocolMessage<URLFetchRequest> {
        private static final long serialVersionUID = 1L;
        private int method_ = 0;
        private byte[] url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<Header> header_ = null;
        private byte[] payload_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private boolean followredirects_ = true;
        private double deadline_ = 0.0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final URLFetchRequest IMMUTABLE_DEFAULT_INSTANCE = new URLFetchRequest(){
            private static final long serialVersionUID = 1L;

            public URLFetchRequest clearMethod() {
                return this;
            }

            public URLFetchRequest setMethod(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest clearUrl() {
                return this;
            }

            public URLFetchRequest setUrlAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest setUrl(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest setUrl(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest clearHeader() {
                return this;
            }

            public Header getMutableHeader(int i) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header addHeader() {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header addHeader(Header v) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header insertHeader(int i, Header v) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public Header removeHeader(int i) {
                return (Header)ProtocolSupport.unsupportedOperation();
            }

            public URLFetchRequest clearPayload() {
                return this;
            }

            public URLFetchRequest setPayloadAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest setPayload(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest setPayload(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest clearFollowRedirects() {
                return this;
            }

            public URLFetchRequest setFollowRedirects(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest clearDeadline() {
                return this;
            }

            public URLFetchRequest setDeadline(double x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public URLFetchRequest mergeFrom(URLFetchRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public URLFetchRequest freeze() {
                return this;
            }

            public URLFetchRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kMethod = 1;
        public static final int kUrl = 2;
        public static final int kHeaderGroup = 3;
        public static final int kHeaderKey = 4;
        public static final int kHeaderValue = 5;
        public static final int kPayload = 6;
        public static final int kFollowRedirects = 7;
        public static final int kDeadline = 8;
        public static final String[] text = new String[9];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int getMethod() {
            return this.method_;
        }

        public RequestMethod getMethodEnum() {
            return this.hasMethod() ? RequestMethod.valueOf(this.getMethod()) : null;
        }

        public final boolean hasMethod() {
            return (this.optional_0_ & 1) != 0;
        }

        public URLFetchRequest clearMethod() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.method_ = 0;
            return this;
        }

        public URLFetchRequest setMethod(int x) {
            this.optional_0_ |= 1;
            this.method_ = x;
            return this;
        }

        public URLFetchRequest setMethod(RequestMethod x) {
            if (x == null) {
                this.optional_0_ &= 0xFFFFFFFE;
                this.method_ = 0;
            } else {
                this.setMethod(x.getValue());
            }
            return this;
        }

        public final byte[] getUrlAsBytes() {
            return this.url_;
        }

        public final boolean hasUrl() {
            return (this.optional_0_ & 2) != 0;
        }

        public URLFetchRequest clearUrl() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public URLFetchRequest setUrlAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.url_ = x;
            return this;
        }

        public final String getUrl() {
            return ProtocolSupport.toStringUtf8(this.url_);
        }

        public URLFetchRequest setUrl(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.url_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getUrl(Charset cs) {
            return ProtocolSupport.toString(this.url_, cs);
        }

        public URLFetchRequest setUrl(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.url_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final int headerSize() {
            return this.header_ != null ? this.header_.size() : 0;
        }

        public final Header getHeader(int i) {
            assert (i >= 0 && i < (this.header_ != null ? this.header_.size() : 0));
            return this.header_.get(i);
        }

        public URLFetchRequest clearHeader() {
            if (this.header_ != null) {
                this.header_.clear();
            }
            return this;
        }

        public Header getMutableHeader(int i) {
            assert (i >= 0 && this.header_ != null && i < this.header_.size());
            return this.header_.get(i);
        }

        public Header addHeader() {
            Header v = new Header();
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(v);
            return v;
        }

        public Header addHeader(Header v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(v);
            return v;
        }

        public Header insertHeader(int i, Header v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            this.header_.add(i, v);
            return v;
        }

        public Header removeHeader(int i) {
            return this.header_.remove(i);
        }

        public final Iterator<Header> headerIterator() {
            if (this.header_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.header_.iterator();
        }

        public final List<Header> headers() {
            return ProtocolSupport.unmodifiableList(this.header_);
        }

        public final List<Header> mutableHeaders() {
            if (this.header_ == null) {
                this.header_ = new ArrayList<Header>(4);
            }
            return this.header_;
        }

        public final byte[] getPayloadAsBytes() {
            return this.payload_;
        }

        public final boolean hasPayload() {
            return (this.optional_0_ & 4) != 0;
        }

        public URLFetchRequest clearPayload() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.payload_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public URLFetchRequest setPayloadAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.payload_ = x;
            return this;
        }

        public final String getPayload() {
            return ProtocolSupport.toStringUtf8(this.payload_);
        }

        public URLFetchRequest setPayload(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.payload_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getPayload(Charset cs) {
            return ProtocolSupport.toString(this.payload_, cs);
        }

        public URLFetchRequest setPayload(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.payload_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final boolean isFollowRedirects() {
            return this.followredirects_;
        }

        public final boolean hasFollowRedirects() {
            return (this.optional_0_ & 8) != 0;
        }

        public URLFetchRequest clearFollowRedirects() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.followredirects_ = true;
            return this;
        }

        public URLFetchRequest setFollowRedirects(boolean x) {
            this.optional_0_ |= 8;
            this.followredirects_ = x;
            return this;
        }

        public final double getDeadline() {
            return this.deadline_;
        }

        public final boolean hasDeadline() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public URLFetchRequest clearDeadline() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.deadline_ = 0.0;
            return this;
        }

        public URLFetchRequest setDeadline(double x) {
            this.optional_0_ |= 0x10;
            this.deadline_ = x;
            return this;
        }

        @Override
        public URLFetchRequest mergeFrom(URLFetchRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.method_ = that.method_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.url_ = that.url_;
            }
            if (that.header_ != null) {
                for (Header v : that.header_) {
                    this.addHeader().mergeFrom(v);
                }
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.payload_ = that.payload_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.followredirects_ = that.followredirects_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.deadline_ = that.deadline_;
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(URLFetchRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(URLFetchRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(URLFetchRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFDF) != (that_t0 & 0xFFFFFFDF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.method_ != that.method_) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.url_, that.url_)) {
                return false;
            }
            int n = this.header_ != null ? this.header_.size() : 0;
            if (n != (that.header_ != null ? that.header_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.header_.get(i).equals(that.header_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 4) != 0 && !Arrays.equals(this.payload_, that.payload_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.followredirects_ != that.followredirects_) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && this.deadline_ != that.deadline_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x20) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof URLFetchRequest && this.equals((URLFetchRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = 1615653556;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.method_ : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.url_) : -113);
            hash *= 31;
            int n2 = n = this.header_ != null ? this.header_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.header_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.payload_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? (this.followredirects_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? ProtocolSupport.hashCode(this.deadline_) : -113);
            if ((this_t0 & 0x20) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 3) {
                if ((this_t0 & 1) == 0) {
                    return "missing field: Method";
                }
                return "missing field: Url";
            }
            if (this.header_ != null) {
                for (Header v : this.header_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 2 + Protocol.varLongSize(this.method_) + Protocol.stringSize(this.url_.length);
            int m = this.header_ != null ? this.header_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.header_.get(i).encodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1C) != 0) {
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.stringSize(this.payload_.length);
                }
                if ((this_t0 & 8) != 0) {
                    n += 2;
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 9;
                }
            }
            return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 28 + this.url_.length;
            int m = this.header_ != null ? this.header_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.header_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                n += 6 + this.payload_.length;
            }
            return (this_t0 & 0x20) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x20;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.method_ = 0;
            this.url_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.header_ != null) {
                this.header_.clear();
            }
            this.payload_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.followredirects_ = true;
            this.deadline_ = 0.0;
            this.uninterpreted = null;
        }

        @Override
        public URLFetchRequest newInstance() {
            return new URLFetchRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            sink.putByte((byte)8);
            sink.putVarLong(this.method_);
            sink.putByte((byte)18);
            sink.putPrefixedData(this.url_);
            int n = m = this.header_ != null ? this.header_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Header v = this.header_.get(i);
                sink.putByte((byte)27);
                v.outputTo(sink);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)50);
                sink.putPrefixedData(this.payload_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)56);
                sink.putBoolean(this.followredirects_);
            }
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)65);
                sink.putDouble(this.deadline_);
            }
            if ((this_t0 & 0x20) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block9: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block9;
                    }
                    case 8: {
                        this.method_ = source.getVarInt();
                        this_t0 |= 1;
                        continue block9;
                    }
                    case 18: {
                        this.url_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block9;
                    }
                    case 27: {
                        if (this.addHeader().merge(source)) continue block9;
                        result = false;
                        break block9;
                    }
                    case 50: {
                        this.payload_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block9;
                    }
                    case 56: {
                        this.followredirects_ = source.getBoolean();
                        this_t0 |= 8;
                        continue block9;
                    }
                    case 65: {
                        this.deadline_ = source.getDouble();
                        this_t0 |= 0x10;
                        continue block9;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x20;
                        continue block9;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public URLFetchRequest freeze() {
            this.url_ = ProtocolSupport.freezeString(this.url_);
            this.header_ = ProtocolSupport.freezeMessages(this.header_);
            this.payload_ = ProtocolSupport.freezeString(this.payload_);
            return this;
        }

        @Override
        public URLFetchRequest unfreeze() {
            this.header_ = ProtocolSupport.unfreezeMessages(this.header_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.header_);
        }

        static {
            URLFetchRequest.text[0] = "ErrorCode";
            URLFetchRequest.text[1] = "Method";
            URLFetchRequest.text[2] = "Url";
            URLFetchRequest.text[3] = "Header";
            URLFetchRequest.text[4] = "Key";
            URLFetchRequest.text[5] = "Value";
            URLFetchRequest.text[6] = "Payload";
            URLFetchRequest.text[7] = "FollowRedirects";
            URLFetchRequest.text[8] = "Deadline";
            types = new int[9];
            Arrays.fill(types, 6);
            URLFetchRequest.types[0] = 0;
            URLFetchRequest.types[1] = 0;
            URLFetchRequest.types[2] = 2;
            URLFetchRequest.types[3] = 3;
            URLFetchRequest.types[4] = 2;
            URLFetchRequest.types[5] = 2;
            URLFetchRequest.types[6] = 2;
            URLFetchRequest.types[7] = 0;
            URLFetchRequest.types[8] = 1;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(URLFetchRequest.class, "Z%apphosting/api/urlfetch_service.proto\n\u001aapphosting.URLFetchRequest\u0013\u001a\u0006Method \u0001(\u00000\u00058\u0002h\u0000\u0014\u0013\u001a\u0003Url \u0002(\u00020\t8\u0002\u0014\u0013\u001a\u0006Header \u0003(\u00030\n8\u0003\u0014\u0013\u001a\nHeader.Key \u0004(\u00020\t8\u0002`\u0002\u0014\u0013\u001a\fHeader.Value \u0005(\u00020\t8\u0002`\u0002\u0014\u0013\u001a\u0007Payload \u0006(\u00020\t8\u0001\u0014\u0013\u001a\u000fFollowRedirects \u0007(\u00000\b8\u0001B\u0004true\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0004true\u00a4\u0001\u0014\u0013\u001a\bDeadline \b(\u00010\u00018\u0001\u0014sz\rRequestMethod\u008b\u0001\u0092\u0001\u0003GET\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u0004POST\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0004HEAD\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u0003PUT\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0006DELETE\u0098\u0001\u0005\u008c\u0001t", new ProtocolType.FieldType("Method", "method", 1, 0, ProtocolType.Presence.REQUIRED, RequestMethod.class), new ProtocolType.FieldType("Url", "url", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("Header", "header", 3, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Header.class), new ProtocolType.FieldType("Payload", "payload", 6, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("FollowRedirects", "followredirects", 7, 3, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("Deadline", "deadline", 8, 4, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RequestMethod implements ProtocolMessageEnum
        {
            GET(1),
            POST(2),
            HEAD(3),
            PUT(4),
            DELETE(5);

            public static final RequestMethod RequestMethod_MIN;
            public static final RequestMethod RequestMethod_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static RequestMethod valueOf(int value) {
                switch (value) {
                    case 1: {
                        return GET;
                    }
                    case 2: {
                        return POST;
                    }
                    case 3: {
                        return HEAD;
                    }
                    case 4: {
                        return PUT;
                    }
                    case 5: {
                        return DELETE;
                    }
                }
                return null;
            }

            private RequestMethod(int v) {
                this.value = v;
            }

            static {
                RequestMethod_MIN = GET;
                RequestMethod_MAX = DELETE;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Header
        extends ProtocolMessage<Header> {
            private static final long serialVersionUID = 1L;
            private byte[] key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private byte[] value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Header IMMUTABLE_DEFAULT_INSTANCE = new Header(){
                private static final long serialVersionUID = 1L;

                public Header clearKey() {
                    return this;
                }

                public Header setKeyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setKey(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setKey(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header clearValue() {
                    return this;
                }

                public Header setValueAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setValue(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header setValue(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Header mergeFrom(Header that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Header freeze() {
                    return this;
                }

                public Header unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getKeyAsBytes() {
                return this.key_;
            }

            public final boolean hasKey() {
                return (this.optional_0_ & 1) != 0;
            }

            public Header clearKey() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Header setKeyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.key_ = x;
                return this;
            }

            public final String getKey() {
                return ProtocolSupport.toStringUtf8(this.key_);
            }

            public Header setKey(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getKey(Charset cs) {
                return ProtocolSupport.toString(this.key_, cs);
            }

            public Header setKey(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.key_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final byte[] getValueAsBytes() {
                return this.value_;
            }

            public final boolean hasValue() {
                return (this.optional_0_ & 2) != 0;
            }

            public Header clearValue() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Header setValueAsBytes(byte[] x) {
                this.optional_0_ |= 2;
                this.value_ = x;
                return this;
            }

            public final String getValue() {
                return ProtocolSupport.toStringUtf8(this.value_);
            }

            public Header setValue(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getValue(Charset cs) {
                return ProtocolSupport.toString(this.value_, cs);
            }

            public Header setValue(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 2;
                this.value_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            @Override
            public Header mergeFrom(Header that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.key_ = that.key_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.value_ = that.value_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Header that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Header that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Header that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.key_, that.key_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && !Arrays.equals(this.value_, that.value_)) {
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Header && this.equals((Header)that);
            }

            @Override
            public int hashCode() {
                int hash = -1889292356;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.key_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.value_) : -113);
                if ((this_t0 & 4) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 3) != 3) {
                    if ((this_t0 & 1) == 0) {
                        return "missing field: Header.Key";
                    }
                    return "missing field: Header.Value";
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 3 + Protocol.stringSize(this.key_.length) + Protocol.stringSize(this.value_.length);
                int this_t0 = this.optional_0_;
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 13 + this.key_.length + this.value_.length;
                int this_t0 = this.optional_0_;
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 4;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                this.key_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.uninterpreted = null;
            }

            @Override
            public Header newInstance() {
                return new Header();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)34);
                sink.putPrefixedData(this.key_);
                sink.putByte((byte)42);
                sink.putPrefixedData(this.value_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 4) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)28);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 28: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 34: {
                            this.key_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 42: {
                            this.value_ = source.getPrefixedData();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 4;
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Header freeze() {
                this.key_ = ProtocolSupport.freezeString(this.key_);
                this.value_ = ProtocolSupport.freezeString(this.value_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Header.class, null, new ProtocolType.FieldType("Key", "key", 4, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("Value", "value", 5, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED));

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLFetchServiceError
    extends ProtocolMessage<URLFetchServiceError> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final URLFetchServiceError IMMUTABLE_DEFAULT_INSTANCE = new URLFetchServiceError(){
            private static final long serialVersionUID = 1L;

            public URLFetchServiceError mergeFrom(URLFetchServiceError that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public URLFetchServiceError freeze() {
                return this;
            }

            public URLFetchServiceError unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public URLFetchServiceError mergeFrom(URLFetchServiceError that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(URLFetchServiceError that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(URLFetchServiceError that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(URLFetchServiceError that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof URLFetchServiceError && this.equals((URLFetchServiceError)that);
        }

        @Override
        public int hashCode() {
            int hash = -1253487031;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public URLFetchServiceError newInstance() {
            return new URLFetchServiceError();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            URLFetchServiceError.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            URLFetchServiceError.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(URLFetchServiceError.class, "Z%apphosting/api/urlfetch_service.proto\n\u001fapphosting.URLFetchServiceErrorsz\tErrorCode\u008b\u0001\u0092\u0001\u0002OK\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\u000bINVALID_URL\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000bFETCH_ERROR\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0011UNSPECIFIED_ERROR\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u0012RESPONSE_TOO_LARGE\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0011DEADLINE_EXCEEDED\u0098\u0001\u0005\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorCode implements ProtocolMessageEnum
        {
            OK(0),
            INVALID_URL(1),
            FETCH_ERROR(2),
            UNSPECIFIED_ERROR(3),
            RESPONSE_TOO_LARGE(4),
            DEADLINE_EXCEEDED(5);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 0: {
                        return OK;
                    }
                    case 1: {
                        return INVALID_URL;
                    }
                    case 2: {
                        return FETCH_ERROR;
                    }
                    case 3: {
                        return UNSPECIFIED_ERROR;
                    }
                    case 4: {
                        return RESPONSE_TOO_LARGE;
                    }
                    case 5: {
                        return DEADLINE_EXCEEDED;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = OK;
                ErrorCode_MAX = DEADLINE_EXCEEDED;
            }
        }
    }
}

