/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.time.ITimeFrameSource;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.time.TimeFrame;

public final class TimeMap {
    private final Map sources = new ConcurrentHashMap();

    public Object get() {
        return this.get(Time.now());
    }

    public Object get(Time time) {
        Iterator iterator = this.sources.keySet().iterator();
        while (iterator.hasNext()) {
            TimeFrame current = ((ITimeFrameSource)iterator.next()).getTimeFrame();
            if (!current.contains(time)) continue;
            return this.sources.get(current);
        }
        return null;
    }

    public void put(ITimeFrameSource source, Object o) {
        TimeFrame timeframe = source.getTimeFrame();
        Iterator iterator = this.sources.keySet().iterator();
        while (iterator.hasNext()) {
            TimeFrame current = ((ITimeFrameSource)iterator.next()).getTimeFrame();
            if (!timeframe.overlaps(current)) continue;
            throw new IllegalArgumentException("Timeframe " + timeframe + " overlaps timeframe " + current);
        }
        this.sources.put(source, o);
    }
}

