/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.IResourceFactory;
import org.apache.wicket.IResponseFilter;
import org.apache.wicket.Localizer;
import org.apache.wicket.Page;
import org.apache.wicket.application.DefaultClassResolver;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.markup.IMarkupCache;
import org.apache.wicket.markup.IMarkupParserFactory;
import org.apache.wicket.markup.MarkupCache;
import org.apache.wicket.markup.MarkupParserFactory;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.PackageResourceGuard;
import org.apache.wicket.markup.html.form.persistence.CookieValuePersisterSettings;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.PropertiesFactory;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.session.DefaultPageFactory;
import org.apache.wicket.session.pagemap.IPageMapEvictionStrategy;
import org.apache.wicket.session.pagemap.LeastRecentlyAccessedEvictionStrategy;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.settings.IExceptionSettings;
import org.apache.wicket.settings.IFrameworkSettings;
import org.apache.wicket.settings.IMarkupSettings;
import org.apache.wicket.settings.IPageSettings;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.settings.IRequestLoggerSettings;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.settings.ISecuritySettings;
import org.apache.wicket.settings.ISessionSettings;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.crypt.KeyInSessionSunJceCryptFactory;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.file.IResourcePath;
import org.apache.wicket.util.file.Path;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.watch.ModificationWatcher;

public final class Settings
implements IApplicationSettings,
IDebugSettings,
IExceptionSettings,
IMarkupSettings,
IPageSettings,
IRequestCycleSettings,
IResourceSettings,
ISecuritySettings,
ISessionSettings,
IFrameworkSettings,
IRequestLoggerSettings {
    private boolean outputComponentPath = false;
    private WeakReference accessDeniedPage;
    private boolean ajaxDebugModeEnabled = false;
    private final Application application;
    private IAuthorizationStrategy authorizationStrategy = IAuthorizationStrategy.ALLOW_ALL;
    private boolean automaticLinking = false;
    private boolean automaticMultiWindowSupport = true;
    private boolean bufferResponse = true;
    private IClassResolver classResolver = new DefaultClassResolver();
    private final List componentResolvers = new ArrayList();
    private boolean componentUseCheck = true;
    private boolean compressWhitespace = false;
    private CookieValuePersisterSettings cookieValuePersisterSettings = new CookieValuePersisterSettings();
    private ICryptFactory cryptFactory;
    private String defaultAfterDisabledLink = "</em>";
    private String defaultBeforeDisabledLink = "<em>";
    private String defaultMarkupEncoding;
    private boolean disableGZipCompression = false;
    private boolean enforceMounts = false;
    private boolean gatherExtendedBrowserInfo = false;
    private WeakReference internalErrorPage;
    private boolean linePreciseReportingOnAddComponentEnabled = false;
    private boolean linePreciseReportingOnNewComponentEnabled = false;
    private Localizer localizer;
    private IMarkupParserFactory markupParserFactory;
    private IMarkupCache markupCache;
    private boolean throwExceptionOnMissingXmlDeclaration = false;
    private int maxPageMaps = 5;
    private final Map nameToResourceFactory = new HashMap();
    private boolean overriddenStringResourceLoaders = false;
    private IPackageResourceGuard packageResourceGuard = new PackageResourceGuard();
    private WeakReference pageExpiredErrorPage;
    private IPageFactory pageFactory = new DefaultPageFactory();
    private IPageMapEvictionStrategy pageMapEvictionStrategy = new LeastRecentlyAccessedEvictionStrategy(5);
    private IPropertiesFactory propertiesFactory;
    private IRequestCycleSettings.RenderStrategy renderStrategy = REDIRECT_TO_BUFFER;
    private IResourceFinder resourceFinder = new Path();
    private Duration resourcePollFrequency = null;
    private IResourceStreamLocator resourceStreamLocator;
    private ModificationWatcher resourceWatcher;
    private List responseFilters;
    private String responseRequestEncoding = "UTF-8";
    private final List stringResourceLoaders = new ArrayList(4);
    private boolean stripComments = false;
    private boolean stripWicketTags = false;
    private boolean stripXmlDeclarationFromOutput;
    private boolean throwExceptionOnMissingResource = true;
    private boolean pageIdUniquePerSession = false;
    private Duration timeout = Duration.ONE_MINUTE;
    private IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener = new IUnauthorizedComponentInstantiationListener(){

        public void onUnauthorizedInstantiation(Component component) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
    };
    private IExceptionSettings.UnexpectedExceptionDisplay unexpectedExceptionDisplay = SHOW_EXCEPTION_PAGE;
    private boolean useDefaultOnMissingResource = true;
    private boolean versionPagesByDefault = true;
    private boolean recordSessionSize = true;
    private int requestsWindowSize = 0;
    private boolean requestLoggerEnabled;
    private boolean stripJavascriptCommentsAndWhitespace;
    private boolean outputMarkupContainerClassName = false;
    private boolean addLastModifiedTimeToResourceReferenceUrl = false;
    private CharSequence parentFolderPlaceholder = "$up$";
    private Bytes defaultMaximumUploadSize = Bytes.MAX;

    public Settings(Application application) {
        this.application = application;
        this.stringResourceLoaders.add(new ComponentStringResourceLoader());
        this.stringResourceLoaders.add(new ClassStringResourceLoader(this.application.getClass()));
    }

    public void addComponentResolver(IComponentResolver resolver) {
        this.componentResolvers.add(resolver);
    }

    public void addResourceFactory(String name, IResourceFactory resourceFactory) {
        this.nameToResourceFactory.put(name, resourceFactory);
    }

    public void addResourceFolder(String resourceFolder) {
        IResourceFinder finder = this.getResourceFinder();
        if (!(finder instanceof IResourcePath)) {
            throw new IllegalArgumentException("To add a resource folder, the application's resource finder must be an instance of IResourcePath");
        }
        IResourcePath path = (IResourcePath)finder;
        path.add(resourceFolder);
    }

    public void addResponseFilter(IResponseFilter responseFilter) {
        if (this.responseFilters == null) {
            this.responseFilters = new ArrayList(3);
        }
        this.responseFilters.add(responseFilter);
    }

    public void addStringResourceLoader(IStringResourceLoader loader) {
        if (!this.overriddenStringResourceLoaders) {
            this.stringResourceLoaders.clear();
            this.overriddenStringResourceLoaders = true;
        }
        this.stringResourceLoaders.add(loader);
    }

    public Class getAccessDeniedPage() {
        return (Class)this.accessDeniedPage.get();
    }

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    public boolean getAutomaticLinking() {
        return this.automaticLinking;
    }

    public boolean getAutomaticMultiWindowSupport() {
        return this.automaticMultiWindowSupport;
    }

    public boolean getBufferResponse() {
        return this.bufferResponse;
    }

    public IClassResolver getClassResolver() {
        return this.classResolver;
    }

    public List getComponentResolvers() {
        return this.componentResolvers;
    }

    public boolean getComponentUseCheck() {
        return this.componentUseCheck;
    }

    public boolean getCompressWhitespace() {
        return this.compressWhitespace;
    }

    public CookieValuePersisterSettings getCookieValuePersisterSettings() {
        return this.cookieValuePersisterSettings;
    }

    public synchronized ICryptFactory getCryptFactory() {
        if (this.cryptFactory == null) {
            this.cryptFactory = new KeyInSessionSunJceCryptFactory();
        }
        return this.cryptFactory;
    }

    public String getDefaultAfterDisabledLink() {
        return this.defaultAfterDisabledLink;
    }

    public String getDefaultBeforeDisabledLink() {
        return this.defaultBeforeDisabledLink;
    }

    public String getDefaultMarkupEncoding() {
        return this.defaultMarkupEncoding;
    }

    public boolean getDisableGZipCompression() {
        return this.disableGZipCompression;
    }

    public boolean getEnforceMounts() {
        return this.enforceMounts;
    }

    public boolean getGatherExtendedBrowserInfo() {
        return this.gatherExtendedBrowserInfo;
    }

    public Class getInternalErrorPage() {
        return (Class)this.internalErrorPage.get();
    }

    public Localizer getLocalizer() {
        if (this.localizer == null) {
            this.localizer = new Localizer();
        }
        return this.localizer;
    }

    public void setLocalizer(Localizer localizer) {
        this.localizer = localizer;
    }

    public IMarkupParserFactory getMarkupParserFactory() {
        if (this.markupParserFactory == null) {
            this.markupParserFactory = new MarkupParserFactory();
        }
        return this.markupParserFactory;
    }

    public final int getMaxPageMaps() {
        return this.maxPageMaps;
    }

    public IPackageResourceGuard getPackageResourceGuard() {
        return this.packageResourceGuard;
    }

    public Class getPageExpiredErrorPage() {
        return (Class)this.pageExpiredErrorPage.get();
    }

    public IPageFactory getPageFactory() {
        return this.pageFactory;
    }

    public IPageMapEvictionStrategy getPageMapEvictionStrategy() {
        return this.pageMapEvictionStrategy;
    }

    public IPropertiesFactory getPropertiesFactory() {
        if (this.propertiesFactory == null) {
            this.propertiesFactory = new PropertiesFactory(Application.get());
        }
        return this.propertiesFactory;
    }

    public IRequestCycleSettings.RenderStrategy getRenderStrategy() {
        return this.renderStrategy;
    }

    public IResourceFactory getResourceFactory(String name) {
        return (IResourceFactory)this.nameToResourceFactory.get(name);
    }

    public IResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }

    public Duration getResourcePollFrequency() {
        return this.resourcePollFrequency;
    }

    public IResourceStreamLocator getResourceStreamLocator() {
        if (this.resourceStreamLocator == null) {
            this.resourceStreamLocator = new ResourceStreamLocator(this.getResourceFinder());
        }
        return this.resourceStreamLocator;
    }

    public ModificationWatcher getResourceWatcher(boolean start) {
        Duration pollFrequency;
        if (this.resourceWatcher == null && start && (pollFrequency = this.getResourcePollFrequency()) != null) {
            this.resourceWatcher = new ModificationWatcher(pollFrequency);
        }
        return this.resourceWatcher;
    }

    public List getResponseFilters() {
        if (this.responseFilters == null) {
            return null;
        }
        return Collections.unmodifiableList(this.responseFilters);
    }

    public String getResponseRequestEncoding() {
        return this.responseRequestEncoding;
    }

    public List getStringResourceLoaders() {
        return Collections.unmodifiableList(this.stringResourceLoaders);
    }

    public boolean getStripComments() {
        return this.stripComments;
    }

    public boolean getStripWicketTags() {
        return this.stripWicketTags;
    }

    public boolean getStripXmlDeclarationFromOutput() {
        return this.stripXmlDeclarationFromOutput;
    }

    public boolean getThrowExceptionOnMissingResource() {
        return this.throwExceptionOnMissingResource;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public IUnauthorizedComponentInstantiationListener getUnauthorizedComponentInstantiationListener() {
        return this.unauthorizedComponentInstantiationListener;
    }

    public IExceptionSettings.UnexpectedExceptionDisplay getUnexpectedExceptionDisplay() {
        return this.unexpectedExceptionDisplay;
    }

    public boolean getUseDefaultOnMissingResource() {
        return this.useDefaultOnMissingResource;
    }

    public String getVersion() {
        String implVersion = null;
        Package pkg = this.getClass().getPackage();
        if (pkg != null) {
            implVersion = pkg.getImplementationVersion();
        }
        return Strings.isEmpty(implVersion) ? "n/a" : implVersion;
    }

    public boolean getVersionPagesByDefault() {
        return this.versionPagesByDefault;
    }

    public boolean isAjaxDebugModeEnabled() {
        return this.ajaxDebugModeEnabled;
    }

    public void setAccessDeniedPage(Class accessDeniedPage) {
        if (accessDeniedPage == null) {
            throw new IllegalArgumentException("Argument accessDeniedPage may not be null");
        }
        this.checkPageClass(accessDeniedPage);
        this.accessDeniedPage = new WeakReference<Class>(accessDeniedPage);
    }

    public void setAjaxDebugModeEnabled(boolean enable) {
        this.ajaxDebugModeEnabled = enable;
    }

    public void setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("authorization strategy cannot be set to null");
        }
        this.authorizationStrategy = strategy;
    }

    public void setAutomaticLinking(boolean automaticLinking) {
        this.automaticLinking = automaticLinking;
    }

    public void setAutomaticMultiWindowSupport(boolean automaticMultiWindowSupport) {
        this.automaticMultiWindowSupport = automaticMultiWindowSupport;
    }

    public void setBufferResponse(boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
    }

    public void setClassResolver(IClassResolver defaultClassResolver) {
        this.classResolver = defaultClassResolver;
    }

    public void setComponentUseCheck(boolean componentUseCheck) {
        this.componentUseCheck = componentUseCheck;
    }

    public void setCompressWhitespace(boolean compressWhitespace) {
        this.compressWhitespace = compressWhitespace;
    }

    public void setCookieValuePersisterSettings(CookieValuePersisterSettings cookieValuePersisterSettings) {
        this.cookieValuePersisterSettings = cookieValuePersisterSettings;
    }

    public void setCryptFactory(ICryptFactory cryptFactory) {
        if (cryptFactory == null) {
            throw new IllegalArgumentException("cryptFactory cannot be null");
        }
        this.cryptFactory = cryptFactory;
    }

    public void setDefaultAfterDisabledLink(String defaultAfterDisabledLink) {
        this.defaultAfterDisabledLink = defaultAfterDisabledLink;
    }

    public void setDefaultBeforeDisabledLink(String defaultBeforeDisabledLink) {
        this.defaultBeforeDisabledLink = defaultBeforeDisabledLink;
    }

    public void setDefaultMarkupEncoding(String encoding) {
        this.defaultMarkupEncoding = encoding;
    }

    public void setDisableGZipCompression(boolean disableGZipCompression) {
        this.disableGZipCompression = disableGZipCompression;
    }

    public void setEnforceMounts(boolean enforce) {
        this.enforceMounts = enforce;
    }

    public void setGatherExtendedBrowserInfo(boolean gatherExtendedBrowserInfo) {
        this.gatherExtendedBrowserInfo = gatherExtendedBrowserInfo;
    }

    public void setInternalErrorPage(Class internalErrorPage) {
        if (internalErrorPage == null) {
            throw new IllegalArgumentException("Argument internalErrorPage may not be null");
        }
        this.checkPageClass(internalErrorPage);
        this.internalErrorPage = new WeakReference<Class>(internalErrorPage);
    }

    public void setMarkupParserFactory(IMarkupParserFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("markup parser factory cannot be null");
        }
        this.markupParserFactory = factory;
    }

    public final void setMaxPageMaps(int maxPageMaps) {
        this.maxPageMaps = maxPageMaps;
    }

    public void setPackageResourceGuard(IPackageResourceGuard packageResourceGuard) {
        if (packageResourceGuard == null) {
            throw new IllegalArgumentException("Argument packageResourceGuard may not be null");
        }
        this.packageResourceGuard = packageResourceGuard;
    }

    public void setPageExpiredErrorPage(Class pageExpiredErrorPage) {
        if (pageExpiredErrorPage == null) {
            throw new IllegalArgumentException("Argument pageExpiredErrorPage may not be null");
        }
        this.checkPageClass(pageExpiredErrorPage);
        this.pageExpiredErrorPage = new WeakReference<Class>(pageExpiredErrorPage);
    }

    public void setPageFactory(IPageFactory defaultPageFactory) {
        this.pageFactory = defaultPageFactory;
    }

    public void setPageMapEvictionStrategy(IPageMapEvictionStrategy pageMapEvictionStrategy) {
        this.pageMapEvictionStrategy = pageMapEvictionStrategy;
    }

    public void setPropertiesFactory(IPropertiesFactory factory) {
        this.propertiesFactory = factory;
    }

    public void setRenderStrategy(IRequestCycleSettings.RenderStrategy renderStrategy) {
        this.renderStrategy = renderStrategy;
    }

    public void setResourceFinder(IResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
        this.resourceStreamLocator = null;
    }

    public void setResourcePollFrequency(Duration resourcePollFrequency) {
        this.resourcePollFrequency = resourcePollFrequency;
    }

    public void setResourceStreamLocator(IResourceStreamLocator resourceStreamLocator) {
        this.resourceStreamLocator = resourceStreamLocator;
    }

    public void setResponseRequestEncoding(String responseRequestEncoding) {
        this.responseRequestEncoding = responseRequestEncoding;
    }

    public void setStripComments(boolean stripComments) {
        this.stripComments = stripComments;
    }

    public void setStripWicketTags(boolean stripWicketTags) {
        this.stripWicketTags = stripWicketTags;
    }

    public void setStripXmlDeclarationFromOutput(boolean strip) {
        this.stripXmlDeclarationFromOutput = strip;
    }

    public void setThrowExceptionOnMissingResource(boolean throwExceptionOnMissingResource) {
        this.throwExceptionOnMissingResource = throwExceptionOnMissingResource;
    }

    public void setTimeout(Duration timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException("timeout cannot be null");
        }
        this.timeout = timeout;
    }

    public void setUnauthorizedComponentInstantiationListener(IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener) {
        this.unauthorizedComponentInstantiationListener = unauthorizedComponentInstantiationListener;
    }

    public void setUnexpectedExceptionDisplay(IExceptionSettings.UnexpectedExceptionDisplay unexpectedExceptionDisplay) {
        this.unexpectedExceptionDisplay = unexpectedExceptionDisplay;
    }

    public void setUseDefaultOnMissingResource(boolean useDefaultOnMissingResource) {
        this.useDefaultOnMissingResource = useDefaultOnMissingResource;
    }

    public void setVersionPagesByDefault(boolean pagesVersionedByDefault) {
        this.versionPagesByDefault = pagesVersionedByDefault;
    }

    private void checkPageClass(Class pageClass) {
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("argument " + pageClass + " must be a subclass of Page");
        }
    }

    public boolean getRecordSessionSize() {
        return this.recordSessionSize;
    }

    public int getRequestsWindowSize() {
        return this.requestsWindowSize;
    }

    public boolean isRequestLoggerEnabled() {
        return this.requestLoggerEnabled;
    }

    public void setRecordSessionSize(boolean record) {
        this.recordSessionSize = record;
    }

    public void setRequestLoggerEnabled(boolean enable) {
        this.requestLoggerEnabled = enable;
    }

    public void setRequestsWindowSize(int size) {
        this.requestsWindowSize = size;
    }

    public boolean getStripJavascriptCommentsAndWhitespace() {
        return this.stripJavascriptCommentsAndWhitespace;
    }

    public void setStripJavascriptCommentsAndWhitespace(boolean value) {
        this.stripJavascriptCommentsAndWhitespace = value;
    }

    public void setOutputMarkupContainerClassName(boolean enable) {
        this.outputMarkupContainerClassName = enable;
    }

    public boolean isOutputMarkupContainerClassName() {
        return this.outputMarkupContainerClassName;
    }

    public IMarkupCache getMarkupCache() {
        if (this.markupCache == null) {
            this.markupCache = new MarkupCache(this.application);
        }
        return this.markupCache;
    }

    public void setMarkupCache(IMarkupCache markupCache) {
        this.markupCache = markupCache;
    }

    public Bytes getDefaultMaximumUploadSize() {
        return this.defaultMaximumUploadSize;
    }

    public void setDefaultMaximumUploadSize(Bytes defaultMaximumUploadSize) {
        this.defaultMaximumUploadSize = defaultMaximumUploadSize;
    }

    public void setPageIdUniquePerSession(boolean value) {
        this.pageIdUniquePerSession = value;
    }

    public boolean isPageIdUniquePerSession() {
        return this.pageIdUniquePerSession;
    }

    public boolean isLinePreciseReportingOnAddComponentEnabled() {
        return this.linePreciseReportingOnAddComponentEnabled;
    }

    public boolean isLinePreciseReportingOnNewComponentEnabled() {
        return this.linePreciseReportingOnNewComponentEnabled;
    }

    public void setLinePreciseReportingOnAddComponentEnabled(boolean enable) {
        this.linePreciseReportingOnAddComponentEnabled = enable;
    }

    public void setLinePreciseReportingOnNewComponentEnabled(boolean enable) {
        this.linePreciseReportingOnNewComponentEnabled = enable;
    }

    public void setAddLastModifiedTimeToResourceReferenceUrl(boolean value) {
        this.addLastModifiedTimeToResourceReferenceUrl = value;
    }

    public boolean getAddLastModifiedTimeToResourceReferenceUrl() {
        return this.addLastModifiedTimeToResourceReferenceUrl;
    }

    public boolean getThrowExceptionOnMissingXmlDeclaration() {
        return this.throwExceptionOnMissingXmlDeclaration;
    }

    public void setThrowExceptionOnMissingXmlDeclaration(boolean throwException) {
        this.throwExceptionOnMissingXmlDeclaration = throwException;
    }

    public CharSequence getParentFolderPlaceholder() {
        return this.parentFolderPlaceholder;
    }

    public void setParentFolderPlaceholder(CharSequence sequence) {
        this.parentFolderPlaceholder = sequence;
    }

    public boolean isOutputComponentPath() {
        return this.outputComponentPath;
    }

    public void setOutputComponentPath(boolean outputComponentPath) {
        this.outputComponentPath = outputComponentPath;
    }
}

