/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.io.IOException;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.RequestContext;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.protocol.http.portlet.PortletServletResponseWrapper;
import org.apache.wicket.protocol.http.portlet.WicketResponseState;

public class PortletRenderServletResponseWrapper
extends PortletServletResponseWrapper {
    RenderResponse renderResponse;

    public PortletRenderServletResponseWrapper(HttpServletResponse response, RenderResponse renderResponse, WicketResponseState responseState) {
        super(response, responseState);
        this.renderResponse = renderResponse;
    }

    public void setContentType(String arg0) {
        this.renderResponse.setContentType(arg0);
    }

    public void sendRedirect(String redirectLocation) throws IOException {
        RequestContext rc = RequestContext.get();
        if (rc instanceof PortletRequestContext) {
            String wicketUrl = ((PortletRequestContext)rc).getLastEncodedPath(redirectLocation);
            if (wicketUrl != null) {
                redirectLocation = wicketUrl;
            } else {
                String contextPath = ((PortletRequestContext)rc).getPortletRequest().getContextPath();
                if (redirectLocation.startsWith(contextPath + "/") && (redirectLocation = redirectLocation.substring(contextPath.length())).length() == 0) {
                    redirectLocation = "/";
                }
            }
        }
        super.sendRedirect(redirectLocation);
    }
}

