/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.collections.IntHashMap;
import org.apache.wicket.version.IPageVersionManager;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondLevelCacheSessionStore
extends HttpSessionStore {
    private static Logger log = LoggerFactory.getLogger((Class)SecondLevelCacheSessionStore.class);
    static final ThreadLocal usedPages = new ThreadLocal();
    private final IPageStore pageStore;

    public static ThreadLocal getUsedPages() {
        return usedPages;
    }

    public SecondLevelCacheSessionStore(Application application, IPageStore pageStore) {
        super(application);
        this.pageStore = pageStore;
        Application.get().getPageSettings().setAutomaticMultiWindowSupport(false);
    }

    public IPageMap createPageMap(String name) {
        return new SecondLevelCachePageMap(Session.get().getId(), Application.get(), name);
    }

    public void onEndRequest(Request request) {
        super.onEndRequest(request);
        usedPages.set(null);
    }

    public void destroy() {
        super.destroy();
        this.getStore().destroy();
    }

    public IPageStore getStore() {
        return this.pageStore;
    }

    public IPageVersionManager newVersionManager(Page page) {
        return new SecondLevelCachePageVersionManager(page);
    }

    public void setAttribute(Request request, String name, Object value) {
        if (!(value instanceof Page)) {
            super.setAttribute(request, name, value);
        }
    }

    protected void onUnbind(String sessionId) {
        this.getStore().unbind(sessionId);
    }

    private static final class SecondLevelCachePageVersionManager
    implements IPageVersionManager {
        private static final long serialVersionUID = 1L;
        private short currentVersionNumber;
        private short currentAjaxVersionNumber;
        private short lastAjaxVersionNumber;
        private final Page page;
        private transient boolean versionStarted;

        public SecondLevelCachePageVersionManager(Page page) {
            this.page = page;
        }

        public void beginVersion(boolean mergeVersion) {
            if (this.versionStarted) {
                return;
            }
            this.versionStarted = true;
            if (!mergeVersion) {
                this.currentVersionNumber = (short)(this.currentVersionNumber + 1);
                this.lastAjaxVersionNumber = this.currentAjaxVersionNumber;
                this.currentAjaxVersionNumber = 0;
            } else if (RequestCycle.get().getRequest() instanceof WebRequest && ((WebRequest)RequestCycle.get().getRequest()).isAjax()) {
                this.currentAjaxVersionNumber = (short)(this.currentAjaxVersionNumber + 1);
            }
        }

        public void componentAdded(Component component) {
        }

        public void componentModelChanging(Component component) {
        }

        public void componentRemoved(Component component) {
        }

        public void componentStateChanging(Change change) {
        }

        public void endVersion(boolean mergeVersion) {
            this.versionStarted = false;
            String sessionId = this.page.getSession().getId();
            if (sessionId != null) {
                this.page.getSession().touch(this.page);
            }
        }

        public void expireOldestVersion() {
        }

        public int getAjaxVersionNumber() {
            return this.currentAjaxVersionNumber;
        }

        public int getCurrentVersionNumber() {
            return this.currentVersionNumber;
        }

        public Page getVersion(int versionNumber) {
            if (this.currentVersionNumber == versionNumber) {
                return this.page;
            }
            return null;
        }

        public int getVersions() {
            return 0;
        }

        public void ignoreVersionMerge() {
            this.currentVersionNumber = (short)(this.currentVersionNumber + 1);
            this.lastAjaxVersionNumber = this.currentAjaxVersionNumber;
            this.currentAjaxVersionNumber = 0;
        }

        public Page rollbackPage(int numberOfVersions) {
            String sessionId = this.page.getSession().getId();
            if (sessionId != null) {
                int versionNumber = this.currentVersionNumber;
                int ajaxNumber = this.currentAjaxVersionNumber;
                if (this.versionStarted) {
                    --versionNumber;
                    --ajaxNumber;
                }
                IPageStore store = ((SecondLevelCacheSessionStore)Application.get().getSessionStore()).getStore();
                if (ajaxNumber >= numberOfVersions) {
                    return store.getPage(sessionId, this.page.getPageMapName(), this.page.getNumericId(), versionNumber, ajaxNumber - numberOfVersions);
                }
                --versionNumber;
                if ((ajaxNumber = this.lastAjaxVersionNumber - (numberOfVersions - ajaxNumber)) < 0) {
                    log.error("trying to rollback to many versions, jumping over 2 page versions is not supported yet.");
                    return null;
                }
                return store.getPage(sessionId, this.page.getPageMapName(), this.page.getNumericId(), versionNumber, ajaxNumber);
            }
            return null;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
        }
    }

    private static final class SecondLevelCachePageMap
    extends PageMap {
        private static final long serialVersionUID = 1L;
        private transient Object lastPage = null;
        private final String applicationKey;
        private String sessionId;

        private IPageStore getPageStore() {
            Application application = Application.get(this.applicationKey);
            if (application != null) {
                SecondLevelCacheSessionStore store = (SecondLevelCacheSessionStore)application.getSessionStore();
                return store.getStore();
            }
            return null;
        }

        private Page getLastPage() {
            IPageStore store;
            Page result = null;
            if (this.lastPage instanceof Page) {
                result = (Page)this.lastPage;
            } else if (this.lastPage != null && (store = this.getPageStore()) instanceof ISerializationAwarePageStore) {
                result = ((ISerializationAwarePageStore)store).convertToPage(this.lastPage);
                this.lastPage = result;
            }
            return result;
        }

        private void setLastPage(Page lastPage) {
            this.lastPage = lastPage;
        }

        private SecondLevelCachePageMap(String sessionId, Application application, String name) {
            super(name);
            this.applicationKey = application.getApplicationKey();
            this.sessionId = sessionId;
        }

        public boolean containsPage(int id, int versionNumber) {
            Page lastPage;
            Page page = lastPage = this.lastPage instanceof Page ? (Page)this.lastPage : null;
            if (lastPage != null && lastPage.getNumericId() == id && lastPage.getCurrentVersionNumber() == versionNumber) {
                return true;
            }
            return this.getStore().containsPage(this.getSession().getId(), this.getName(), id, versionNumber);
        }

        public Page get(int id, int versionNumber) {
            Page page;
            IntHashMap pages;
            HashMap<String, IntHashMap> pageMaps = (HashMap<String, IntHashMap>)usedPages.get();
            if (pageMaps == null) {
                pageMaps = new HashMap<String, IntHashMap>();
                usedPages.set(pageMaps);
            }
            if ((pages = (IntHashMap)pageMaps.get(this.getName())) == null) {
                pages = new IntHashMap();
                pageMaps.put(this.getName(), pages);
            }
            if ((page = (Page)pages.get(id)) != null) {
                return page;
            }
            String sessionId = this.getSession().getId();
            if (this.getLastPage() != null && this.getLastPage().getNumericId() == id) {
                Page page2 = page = versionNumber != -1 ? this.getLastPage().getVersion(versionNumber) : this.getLastPage();
                if (page != null) {
                    this.getStore().pageAccessed(sessionId, page);
                    pages.put(id, page);
                    return page;
                }
            }
            if (sessionId != null) {
                this.setLastPage(null);
                page = this.getStore().getPage(sessionId, this.getName(), id, versionNumber, -1);
                pages.put(id, page);
                return page;
            }
            return null;
        }

        public void put(Page page) {
            Session session;
            String sessionId;
            if (!page.isPageStateless() && (sessionId = (session = this.getSession()).getId()) != null && !session.isSessionInvalidated()) {
                this.sessionId = sessionId;
                this.getStore().storePage(sessionId, page);
                this.setLastPage(page);
                this.dirty();
            }
        }

        public void clear() {
            super.clear();
            String sessionId = this.getSession().getId();
            if (sessionId != null) {
                this.getStore().removePage(sessionId, this.getName(), -1);
            }
        }

        public void removeEntry(IPageMapEntry entry) {
            String sessionId = this.getSession().getId();
            if (sessionId != null) {
                this.getStore().removePage(sessionId, this.getName(), entry.getNumericId());
            }
        }

        private IPageStore getStore() {
            return ((SecondLevelCacheSessionStore)Application.get().getSessionStore()).getStore();
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            IPageStore store = this.getPageStore();
            if (this.sessionId != null && !(store instanceof IClusteredPageStore)) {
                Object page = this.lastPage;
                if (store instanceof ISerializationAwarePageStore) {
                    page = ((ISerializationAwarePageStore)store).prepareForSerialization(this.sessionId, page);
                }
                try {
                    s.writeObject(page);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Failed to serialize " + page.toString(), e);
                }
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            IPageStore store = this.getPageStore();
            if (this.sessionId != null && !(store instanceof IClusteredPageStore)) {
                Object lastPage = s.readObject();
                if (store instanceof ISerializationAwarePageStore) {
                    lastPage = ((ISerializationAwarePageStore)store).restoreAfterSerialization((Serializable)lastPage);
                }
                this.lastPage = lastPage;
            }
        }
    }

    public static interface ISerializationAwarePageStore
    extends IPageStore {
        public Serializable prepareForSerialization(String var1, Object var2);

        public Object restoreAfterSerialization(Serializable var1);

        public Page convertToPage(Object var1);
    }

    public static interface IClusteredPageStore
    extends IPageStore {
    }

    public static interface IPageStore {
        public void destroy();

        public Page getPage(String var1, String var2, int var3, int var4, int var5);

        public void pageAccessed(String var1, Page var2);

        public void removePage(String var1, String var2, int var3);

        public void storePage(String var1, Page var2);

        public void unbind(String var1);

        public boolean containsPage(String var1, String var2, int var3, int var4);
    }
}

