/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketMessageResolver
implements IComponentResolver {
    private static final Logger log = LoggerFactory.getLogger((Class)WicketMessageResolver.class);
    private static final String DEFAULT_VALUE = "DEFAULT_WICKET_MESSAGE_RESOLVER_VALUE";
    private static final long serialVersionUID = 1L;

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        WicketTag wtag;
        if (tag instanceof WicketTag && (wtag = (WicketTag)tag).isMessageTag()) {
            String messageKey = wtag.getAttributes().getString("key");
            if (messageKey == null || messageKey.trim().length() == 0) {
                throw new MarkupException("Wrong format of <wicket:message key='xxx'>: attribute 'key' is missing");
            }
            String id = "_message_" + container.getPage().getAutoIndex();
            MessageLabel label = new MessageLabel(id, messageKey);
            label.setRenderBodyOnly(container.getApplication().getMarkupSettings().getStripWicketTags());
            container.autoAdd(label, markupStream);
            return true;
        }
        return false;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("message");
    }

    public static class MessageLabel
    extends WebComponent {
        private static final long serialVersionUID = 1L;

        public MessageLabel(String id, String messageKey) {
            super(id, new Model((Serializable)((Object)messageKey)));
            this.setEscapeModelStrings(false);
        }

        protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            String key = this.getModelObjectAsString();
            String value = this.getLocalizer().getString(key, (Component)this.getParent(), WicketMessageResolver.DEFAULT_VALUE);
            if (value != null && !WicketMessageResolver.DEFAULT_VALUE.equals(value)) {
                this.replaceComponentTagBody(markupStream, openTag, value.trim());
            } else {
                MarkupElement body;
                log.debug("No value found for wicket:message tag with key: {}", (Object)key);
                markupStream.setCurrentIndex(markupStream.getCurrentIndex() - 1);
                ComponentTag tag = markupStream.getTag();
                markupStream.next();
                if (!tag.isOpenClose() && (body = markupStream.get()) instanceof RawMarkup) {
                    this.replaceComponentTagBody(markupStream, openTag, body.toCharSequence());
                }
            }
        }

        protected void onComponentTag(ComponentTag tag) {
            if (tag.isOpenClose()) {
                tag.setType(XmlTag.OPEN);
            }
            super.onComponentTag(tag);
        }
    }
}

