/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainerWithAssociatedMarkup;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.model.IModel;

public class Panel
extends WebMarkupContainerWithAssociatedMarkup {
    private static final long serialVersionUID = 1L;
    private boolean wasOpenCloseTag = false;

    public Panel(String id) {
        super(id);
    }

    public Panel(String id, IModel model) {
        super(id, model);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (tag.isOpenClose()) {
            this.wasOpenCloseTag = true;
            tag.setType(XmlTag.OPEN);
        }
        super.onComponentTag(tag);
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.renderAssociatedMarkup("panel", "Markup for a panel component has to contain part '<wicket:panel>'");
        if (!this.wasOpenCloseTag) {
            markupStream.skipRawMarkup();
            if (!markupStream.get().closes(openTag)) {
                throw new MarkupException("close tag not found for tag: " + openTag.toString() + ". Component: " + this.toString());
            }
        }
    }

    public void renderHead(HtmlHeaderContainer container) {
        this.renderHeadFromAssociatedMarkupFile(container);
        super.renderHead(container);
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("panel");
    }
}

