/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigation;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationIncrementLink;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationLink;
import org.apache.wicket.markup.html.panel.Panel;

public class PagingNavigator
extends Panel {
    private static final long serialVersionUID = 1L;
    private PagingNavigation pagingNavigation;
    private final IPageable pageable;
    private final IPagingLabelProvider labelProvider;

    public PagingNavigator(String id, IPageable pageable) {
        this(id, pageable, null);
    }

    public PagingNavigator(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(id);
        this.pageable = pageable;
        this.labelProvider = labelProvider;
    }

    public final IPageable getPageable() {
        return this.pageable;
    }

    protected void onBeforeRender() {
        if (this.get("first") == null) {
            this.pagingNavigation = this.newNavigation(this.pageable, this.labelProvider);
            this.add(this.pagingNavigation);
            this.add(this.newPagingNavigationLink("first", this.pageable, 0));
            this.add(this.newPagingNavigationIncrementLink("prev", this.pageable, -1));
            this.add(this.newPagingNavigationIncrementLink("next", this.pageable, 1));
            this.add(this.newPagingNavigationLink("last", this.pageable, -1));
        }
        super.onBeforeRender();
    }

    protected Link newPagingNavigationIncrementLink(String id, IPageable pageable, int increment) {
        return new PagingNavigationIncrementLink(id, pageable, increment);
    }

    protected Link newPagingNavigationLink(String id, IPageable pageable, int pageNumber) {
        return new PagingNavigationLink(id, pageable, pageNumber);
    }

    protected PagingNavigation newNavigation(IPageable pageable, IPagingLabelProvider labelProvider) {
        return new PagingNavigation("navigation", pageable, labelProvider);
    }

    public final PagingNavigation getPagingNavigation() {
        return this.pagingNavigation;
    }
}

