/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.image.resource.LocalizedImageResource;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.value.ValueMap;

public class Image
extends WebComponent
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private final LocalizedImageResource localizedImageResource = new LocalizedImageResource(this);

    public Image(String id) {
        super(id);
    }

    public Image(String id, ResourceReference resourceReference) {
        this(id, resourceReference, null);
    }

    public Image(String id, ResourceReference resourceReference, ValueMap resourceParameters) {
        super(id);
        this.setImageResourceReference(resourceReference, resourceParameters);
    }

    public Image(String id, Resource imageResource) {
        super(id);
        this.setImageResource(imageResource);
    }

    public Image(String id, IModel model) {
        super(id, model);
    }

    public Image(String id, String string) {
        this(id, new Model((Serializable)((Object)string)));
    }

    public void onResourceRequested() {
        this.localizedImageResource.onResourceRequested();
    }

    public void setImageResource(Resource imageResource) {
        this.localizedImageResource.setResource(imageResource);
    }

    public void setImageResourceReference(ResourceReference resourceReference) {
        this.localizedImageResource.setResourceReference(resourceReference);
    }

    public void setImageResourceReference(ResourceReference resourceReference, ValueMap parameters) {
        this.localizedImageResource.setResourceReference(resourceReference, parameters);
    }

    public Component setModel(IModel model) {
        this.localizedImageResource.setResourceReference(null);
        this.localizedImageResource.setResource(null);
        return super.setModel(model);
    }

    protected Resource getImageResource() {
        return this.localizedImageResource.getResource();
    }

    protected ResourceReference getImageResourceReference() {
        return this.localizedImageResource.getResourceReference();
    }

    protected IModel initModel() {
        return null;
    }

    protected void onComponentTag(ComponentTag tag) {
        ResourceReference resourceReference;
        this.checkComponentTag(tag, "img");
        super.onComponentTag(tag);
        Resource resource = this.getImageResource();
        if (resource != null) {
            this.localizedImageResource.setResource(resource);
        }
        if ((resourceReference = this.getImageResourceReference()) != null) {
            this.localizedImageResource.setResourceReference(resourceReference);
        }
        this.localizedImageResource.setSrcAttribute(tag);
    }

    protected boolean getStatelessHint() {
        return (this.getImageResource() == null || this.getImageResource() == this.localizedImageResource.getResource()) && this.localizedImageResource.isStateless();
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
    }
}

