/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.util.string.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedbackMessages
implements IClusterable {
    private static final Logger log = LoggerFactory.getLogger((Class)FeedbackMessages.class);
    private static final long serialVersionUID = 1L;
    private List messages = new CopyOnWriteArrayList();

    public final void add(Component reporter, String message, int level) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), level));
    }

    public final int clear() {
        return this.clear(null);
    }

    public final int clear(IFeedbackMessageFilter filter) {
        if (this.messages.size() == 0) {
            return 0;
        }
        List toDelete = this.messages(filter);
        int count = toDelete.size();
        this.messages.removeAll(toDelete);
        this.trimToSize();
        return count;
    }

    public final void debug(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 100));
    }

    public final void error(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 400));
    }

    public final void fatal(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 500));
    }

    public final boolean hasErrorMessageFor(Component component) {
        return this.hasMessageFor(component, 400);
    }

    public final boolean hasMessage(IFeedbackMessageFilter filter) {
        return this.messages(filter).size() != 0;
    }

    public final boolean hasMessageFor(Component component) {
        return this.messageForComponent(component) != null;
    }

    public final boolean hasMessageFor(Component component, int level) {
        FeedbackMessage message = this.messageForComponent(component);
        return message != null && message.isLevel(level);
    }

    public final void info(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 200));
    }

    public final boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public final Iterator iterator() {
        return this.messages.iterator();
    }

    public final FeedbackMessage messageForComponent(Component component) {
        Iterator iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            FeedbackMessage message = (FeedbackMessage)iterator.next();
            if (message.getReporter() != component) continue;
            return message;
        }
        return null;
    }

    public final List messages(IFeedbackMessageFilter filter) {
        if (this.messages.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FeedbackMessage> list = new ArrayList<FeedbackMessage>();
        Iterator iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            FeedbackMessage message = (FeedbackMessage)iterator.next();
            if (filter != null && !filter.accept(message)) continue;
            list.add(message);
        }
        return list;
    }

    public final int size() {
        return this.messages.size();
    }

    public final int size(IFeedbackMessageFilter filter) {
        int count = 0;
        Iterator iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            FeedbackMessage message = (FeedbackMessage)iterator.next();
            if (filter != null && !filter.accept(message)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "[feedbackMessages = " + StringList.valueOf(this.messages) + "]";
    }

    public final void trimToSize() {
        if (this.messages instanceof ArrayList) {
            ((ArrayList)this.messages).trimToSize();
        }
    }

    public final void warn(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 300));
    }

    final void add(FeedbackMessage message) {
        if (log.isDebugEnabled()) {
            log.debug("Adding feedback message " + message);
        }
        this.messages.add(message);
    }
}

