/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.webbeans.servlet.ServletLifecycle;
import org.jboss.webbeans.servlet.api.helpers.AbstractServletListener;

public class WebBeansListener
extends AbstractServletListener {
    private final ServletLifecycle lifecycle = ServletLifecycle.instance();

    public void sessionCreated(HttpSessionEvent event) {
        this.lifecycle.beginSession(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.lifecycle.endSession(event.getSession());
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (!(event.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalStateException("Non HTTP-Servlet lifecycle not defined");
        }
        this.lifecycle.endRequest((HttpServletRequest)event.getServletRequest());
    }

    public void requestInitialized(ServletRequestEvent event) {
        if (!(event.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalStateException("Non HTTP-Servlet lifecycle not defined");
        }
        this.lifecycle.beginRequest((HttpServletRequest)event.getServletRequest());
    }
}

