/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.conversation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.context.Conversation;
import javax.context.SessionScoped;
import javax.inject.Current;
import javax.inject.Produces;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.WebBean;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.conversation.ConversationConcurrentAccessTimeout;
import org.jboss.webbeans.conversation.ConversationEntry;
import org.jboss.webbeans.conversation.ConversationIdName;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.conversation.ConversationInactivityTimeout;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.conversation.ConversationTerminator;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.HttpSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SessionScoped
@WebBean
public class ServletConversationManager
implements ConversationManager,
Serializable {
    private static final long serialVersionUID = 889078932817674680L;
    private static LogProvider log = Logging.getLogProvider(ServletConversationManager.class);
    private static final long CONVERSATION_TIMEOUT_IN_MS = 600000L;
    private static final long CONVERSATION_CONCURRENT_ACCESS_TIMEOUT_IN_MS = 1000L;
    private static final String CONVERSATION_ID_NAME = "cid";
    @Current
    private ConversationTerminator conversationTerminator;
    @Current
    private ConversationImpl currentConversation;
    @ConversationConcurrentAccessTimeout
    private long concurrentAccessTimeout;
    private Map<String, ConversationEntry> longRunningConversations;

    public ServletConversationManager() {
        log.trace("Created " + this.getClass());
        this.longRunningConversations = new ConcurrentHashMap<String, ConversationEntry>();
    }

    @Produces
    @ConversationInactivityTimeout
    @WebBean
    public static long getConversationTimeoutInMilliseconds() {
        log.trace("Produced conversation timeout 600000");
        return 600000L;
    }

    @Produces
    @ConversationConcurrentAccessTimeout
    @WebBean
    public static long getConversationConcurrentAccessTimeout() {
        log.trace("Produced conversation concurrent access timeout 1000");
        return 1000L;
    }

    @Produces
    @ConversationIdName
    @WebBean
    public static String getConversationIdName() {
        log.trace("Produced conversation id name cid");
        return CONVERSATION_ID_NAME;
    }

    @Override
    public void beginOrRestoreConversation(String cid) {
        if (cid == null) {
            log.trace("No conversation id to restore");
            return;
        }
        if (!this.longRunningConversations.containsKey(cid)) {
            log.warn("Could not restore long-running conversation " + cid);
            return;
        }
        ConversationEntry resumedConversationEntry = this.longRunningConversations.get(cid);
        try {
            if (!resumedConversationEntry.lock(this.concurrentAccessTimeout)) {
                return;
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted while trying to acquire lock");
            return;
        }
        if (!resumedConversationEntry.cancelTermination()) {
            resumedConversationEntry.unlock();
        } else {
            String oldConversation = this.currentConversation.toString();
            this.currentConversation.switchTo(resumedConversationEntry.getConversation());
            log.trace("Conversation switched from " + oldConversation + " to " + this.currentConversation);
        }
    }

    @Override
    public void cleanupConversation() {
        ConversationEntry longRunningConversation;
        log.trace("Cleaning up conversation for " + this.currentConversation);
        String cid = this.currentConversation.getId();
        if (this.currentConversation.isLongRunning()) {
            Future<?> terminationHandle = this.scheduleForTermination(cid, this.currentConversation.getTimeout());
            longRunningConversation = this.longRunningConversations.get(cid);
            if (longRunningConversation != null) {
                longRunningConversation.unlock();
                longRunningConversation.reScheduleTermination(terminationHandle);
            } else {
                ConversationEntry conversationEntry = ConversationEntry.of(this.currentConversation, terminationHandle);
                this.longRunningConversations.put(cid, conversationEntry);
            }
            log.trace("Scheduled " + this.currentConversation + " for termination, there are now " + this.longRunningConversations.size() + " long-running conversations");
        } else {
            log.trace("Destroying transient conversation " + this.currentConversation);
            ConversationEntry longRunningConversation2 = this.longRunningConversations.remove(cid);
            if (longRunningConversation2 != null) {
                longRunningConversation2.cancelTermination();
                longRunningConversation2.unlock();
            }
            ConversationContext.INSTANCE.destroy();
        }
        String originalCid = this.currentConversation.getOriginalCid();
        ConversationEntry conversationEntry = longRunningConversation = originalCid == null ? null : this.longRunningConversations.get(originalCid);
        if (longRunningConversation != null) {
            longRunningConversation.unlock();
            longRunningConversation.reScheduleTermination(this.scheduleForTermination(originalCid, this.currentConversation.getTimeout()));
        }
    }

    private Future<?> scheduleForTermination(String cid, long timeout) {
        HttpSession session = CurrentManager.rootManager().getInstanceByType(HttpSessionManager.class, new Annotation[0]).getSession();
        TerminationTask terminationTask = new TerminationTask(cid, session);
        return this.conversationTerminator.scheduleForTermination(terminationTask, timeout);
    }

    @Override
    public void destroyAllConversations() {
        HttpSession session = CurrentManager.rootManager().getInstanceByType(HttpSessionManager.class, new Annotation[0]).getSession();
        log.debug("Destroying " + this.longRunningConversations.size() + " long-running conversations in session " + session.getId());
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            conversationEntry.destroy(session);
        }
        this.longRunningConversations.clear();
    }

    @Override
    public Set<Conversation> getLongRunningConversations() {
        HashSet<Conversation> conversations = new HashSet<Conversation>();
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            conversations.add(conversationEntry.getConversation());
        }
        return Collections.unmodifiableSet(conversations);
    }

    private class TerminationTask
    implements Runnable {
        private String cid;
        private HttpSession session;

        public TerminationTask(String cid, HttpSession session) {
            this.cid = cid;
            this.session = session;
        }

        public void run() {
            log.debug("Conversation " + this.cid + " timed out. Destroying it");
            ((ConversationEntry)ServletConversationManager.this.longRunningConversations.remove(this.cid)).destroy(this.session);
            log.trace("There are now " + ServletConversationManager.this.longRunningConversations.size() + " long-running conversations");
        }
    }
}

