/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb.panel;

import java.lang.reflect.Constructor;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.panel.BreadCrumbPanel;
import org.apache.wicket.extensions.breadcrumb.panel.IBreadCrumbPanelFactory;

public final class BreadCrumbPanelFactory
implements IBreadCrumbPanelFactory {
    private static final long serialVersionUID = 1L;
    private Class panelClass;

    public BreadCrumbPanelFactory(Class panelClass) {
        if (panelClass == null) {
            throw new IllegalArgumentException("argument panelClass must be not null");
        }
        if (!BreadCrumbPanel.class.isAssignableFrom(panelClass)) {
            throw new IllegalArgumentException("argument panelClass (" + panelClass + ") must extend class " + BreadCrumbPanel.class.getName());
        }
        this.panelClass = panelClass;
        this.getConstructor();
    }

    public final BreadCrumbPanel create(String componentId, IBreadCrumbModel breadCrumbModel) {
        Constructor ctor = this.getConstructor();
        try {
            return (BreadCrumbPanel)ctor.newInstance(componentId, breadCrumbModel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final Constructor getConstructor() {
        try {
            Constructor ctor = this.panelClass.getConstructor(String.class, IBreadCrumbModel.class);
            return ctor;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

