#!/usr/bin/perl


# /************************************************************************
# ** Copyright (C) 2006 Shinji Kono
# ** 連絡先： 琉球大学情報工学科 河野 真治  
# ** （E-Mail Address: kono@ie.u-ryukyu.ac.jp）
# **
# **    このソースのいかなる複写，改変，修正も許諾します。ただし、
# **    その際には、誰が貢献したを示すこの部分を残すこと。
# **    再配布や雑誌の付録などの問い合わせも必要ありません。
# **    営利利用も上記に反しない範囲で許可します。
# **    バイナリの配布の際にはversion messageを保存することを条件とします。
# **    このプログラムについては特に何の保証もしない、悪しからず。
# **
# **    Everyone is permitted to do anything on this program 
# **    including copying, modifying, improving,
# **    as long as you don't try to pretend that you wrote it.
# **    i.e., the above copyright notice has to appear in all copies.  
# **    Binary distribution requires original version messages.
# **    You don't have to ask before copying, redistribution or publishing.
# **    THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE.
# ***********************************************************************/

$in="conv_func.tbl";
$out="conv/conv.h";
$def="conv/convdef.h";
$nul="conv/null.c";

open(IN,"<$in") or die("can't open $in");
open(OUT,">$out") or die("can't open $out");
print OUT "/* Do not edit this file. This is automatically generated. */\n";
print OUT "/* Edit $in */\n";
open(DEF,">$def") or die("can't open $def");
print DEF "/* Do not edit this file. This is automatically generated. */\n";
print DEF "/* Edit $in */\n";
open(NUL,">$nul") or die("can't open $nul");
print NUL "/* Do not edit this file. This is automatically generated. */\n";
print NUL "/* Edit $in */\n";

print OUT "typedef struct converter {\n";

print NUL "#include <stdio.h>\n";
print NUL "#include \"mc.h\"\n";
print NUL "#include \"mc-parse.h\"\n";

print NUL "#include \"conv/conv.h\"\n";
print NUL "#include \"conv/convdef.h\"\n";
print NUL "#include \"conv/null.h\"\n";


while(<IN>) {
    if (/([^\s]*)\s+([_a-zA-Z0-9]*)\((.*)\)/) {
	$type=$1; $name=$2; $arg=$3;
	# print OUT "$type=$name=$arg\n";
	$return = ($type && $type ne "void")? "return ($type)0;" : "";
	print OUT "    $type (*$name)($arg);\n";
	print NUL "static $type\n$name($arg)\n{ $return}\n\n";
	print DEF "static $_";
    }
}

print OUT "} Converter;\n";

foreach $def ('conv/c.h','conv/c2cbc.h','conv/cbc2c.h','conv/null.h' ) {
    $def =~ m-conv/(.*)\.h-; $m = $1;
    open(DEF,">$def") or die("can't open $def");
    print DEF "/* Do not edit this file. This is automatically generated. */\n";

    print OUT "extern Converter ${m}_converter;\n";
    print DEF "\nextern Converter $1_converter;\n";
    print DEF "\n\n\nConverter $1_converter = {\n";
    open(IN,"<$in") or die("can't open $in");
    while(<IN>) {
	if (/([^\s]*)\s+([_a-zA-Z0-9]*)\((.*)\)/) {
	    $type=$1; $name=$2; $arg=$3;
	    print DEF "    \&$name,\n";
	}
    }
    print DEF "};\n";
}

