/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class Touch
extends Task {
    private static final DateFormatFactory DEFAULT_DF_FACTORY = new DateFormatFactory(){

        public DateFormat getPrimaryFormat() {
            return DateFormat.getDateTimeInstance(3, 3, Locale.US);
        }

        public DateFormat getFallbackFormat() {
            return DateFormat.getDateTimeInstance(3, 2, Locale.US);
        }
    };
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File file;
    private long millis = -1L;
    private String dateTime;
    private Vector filesets = new Vector();
    private Vector filelists = new Vector();
    private boolean dateTimeConfigured;
    private boolean mkdirs;
    private boolean verbose = true;
    private FileNameMapper fileNameMapper = null;
    private DateFormatFactory dfFactory = DEFAULT_DF_FACTORY;

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public void setDatetime(String dateTime) {
        if (this.dateTime != null) {
            this.log("Resetting datetime attribute to " + dateTime, 3);
        }
        this.dateTime = dateTime;
        this.dateTimeConfigured = false;
    }

    public void setMkdirs(boolean mkdirs) {
        this.mkdirs = mkdirs;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPattern(final String pattern) {
        this.dfFactory = new DateFormatFactory(){

            public DateFormat getPrimaryFormat() {
                return new SimpleDateFormat(pattern);
            }

            public DateFormat getFallbackFormat() {
                return null;
            }
        };
    }

    public void addConfiguredMapper(Mapper mapper) {
        this.add(mapper.getImplementation());
    }

    public void add(FileNameMapper fileNameMapper) throws BuildException {
        if (this.fileNameMapper != null) {
            throw new BuildException("Only one mapper may be added to the " + this.getTaskName() + " task.");
        }
        this.fileNameMapper = fileNameMapper;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void addFilelist(FileList list) {
        this.filelists.addElement(list);
    }

    protected synchronized void checkConfiguration() throws BuildException {
        if (this.file == null && this.filesets.size() + this.filelists.size() == 0) {
            throw new BuildException("Specify at least one source--a file, filelist or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to touch directories.");
        }
        if (this.dateTime != null && !this.dateTimeConfigured) {
            long workmillis = this.millis;
            DateFormat df = this.dfFactory.getPrimaryFormat();
            ParseException pe = null;
            try {
                workmillis = df.parse(this.dateTime).getTime();
            }
            catch (ParseException peOne) {
                df = this.dfFactory.getFallbackFormat();
                if (df == null) {
                    pe = peOne;
                }
                try {
                    workmillis = df.parse(this.dateTime).getTime();
                }
                catch (ParseException peTwo) {
                    pe = peTwo;
                }
            }
            if (pe != null) {
                throw new BuildException(pe.getMessage(), pe, this.getLocation());
            }
            if (workmillis < 0L) {
                throw new BuildException("Date of " + this.dateTime + " results in negative " + "milliseconds value " + "relative to epoch " + "(January 1, 1970, " + "00:00:00 GMT).");
            }
            this.log("Setting millis to " + workmillis + " from datetime attribute", this.millis < 0L ? 4 : 3);
            this.setMillis(workmillis);
            this.dateTimeConfigured = true;
        }
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        this.touch();
    }

    protected void touch() throws BuildException {
        int i;
        long defaultTimestamp = this.getTimestamp();
        if (this.file != null) {
            this.touch(this.file.getParentFile(), this.file.getName(), defaultTimestamp);
        }
        for (i = 0; i < this.filesets.size(); ++i) {
            int j;
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            String[] srcDirs = ds.getIncludedDirectories();
            for (j = 0; j < srcFiles.length; ++j) {
                this.touch(fromDir, srcFiles[j], defaultTimestamp);
            }
            for (j = 0; j < srcDirs.length; ++j) {
                this.touch(fromDir, srcDirs[j], defaultTimestamp);
            }
        }
        for (i = 0; i < this.filelists.size(); ++i) {
            FileList fl = (FileList)this.filelists.elementAt(i);
            File fromDir = fl.getDir(this.getProject());
            String[] srcFiles = fl.getFiles(this.getProject());
            for (int j = 0; j < srcFiles.length; ++j) {
                this.touch(fromDir, srcFiles[j], defaultTimestamp);
            }
        }
    }

    protected void touch(File file) {
        this.touch(file, this.getTimestamp());
    }

    private long getTimestamp() {
        return this.millis < 0L ? System.currentTimeMillis() : this.millis;
    }

    private void touch(File fromDir, String filename, long defaultTimestamp) {
        File f = FILE_UTILS.resolveFile(fromDir, filename);
        if (this.fileNameMapper == null) {
            this.touch(f, defaultTimestamp);
        } else {
            String[] mapped = this.fileNameMapper.mapFileName(filename);
            if (mapped != null && mapped.length > 0) {
                long modTime = f.exists() ? f.lastModified() : defaultTimestamp;
                for (int i = 0; i < mapped.length; ++i) {
                    this.touch(this.getProject().resolveFile(mapped[i]), modTime);
                }
            }
        }
    }

    private void touch(File file, long modTime) {
        if (!file.exists()) {
            this.log("Creating " + file, this.verbose ? 2 : 3);
            try {
                FILE_UTILS.createNewFile(file, this.mkdirs);
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create " + file, ioe, this.getLocation());
            }
        }
        if (!file.canWrite()) {
            throw new BuildException("Can not change modification date of read-only file " + file);
        }
        FILE_UTILS.setFileLastModified(file, modTime);
    }

    private static interface DateFormatFactory {
        public DateFormat getPrimaryFormat();

        public DateFormat getFallbackFormat();
    }
}

