/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.win32.DEVMODE;
import org.eclipse.swt.internal.win32.DEVMODEA;
import org.eclipse.swt.internal.win32.DEVMODEW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    static /* synthetic */ Class class$0;

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    static int checkStyle(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0 && ((n &= 0xEFFFFFFF) & n2) == 0) {
            n |= shell == null ? 65536 : 32768;
        }
        return n;
    }

    public void setPrinterData(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            SWT.error(43);
        }
    }

    public PrinterData open() {
        int n;
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = PRINTDLG.sizeof;
        Shell shell = this.getParent();
        if (shell != null) {
            pRINTDLG.hwndOwner = shell.handle;
        }
        pRINTDLG.Flags = 1024;
        OS.PrintDlg(pRINTDLG);
        int n2 = 0;
        int n3 = OS.GetProcessHeap();
        byte[] byArray = this.printerData.otherData;
        if (byArray != null && byArray.length != 0) {
            n2 = OS.HeapAlloc(n3, 8, byArray.length);
            OS.MoveMemory(n2, byArray, byArray.length);
            if (pRINTDLG.hDevMode != 0) {
                OS.GlobalFree(pRINTDLG.hDevMode);
            }
            pRINTDLG.hDevMode = n2;
        }
        int n4 = pRINTDLG.hDevMode;
        int n5 = OS.GlobalLock(n4);
        DEVMODE dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
        OS.MoveMemory(dEVMODE, n5, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
        dEVMODE.dmFields |= 1;
        dEVMODE.dmOrientation = (short)(this.printerData.orientation == 1 ? 1 : 2);
        if (this.printerData.copyCount != 1) {
            dEVMODE.dmFields |= 0x100;
            dEVMODE.dmCopies = (short)this.printerData.copyCount;
        }
        if (this.printerData.collate) {
            dEVMODE.dmFields |= 0x8000;
            dEVMODE.dmCollate = 1;
        }
        OS.MoveMemory(n5, dEVMODE, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
        OS.GlobalUnlock(n4);
        pRINTDLG.Flags = 262144;
        if (this.printerData.printToFile) {
            pRINTDLG.Flags |= 0x20;
        }
        switch (this.printerData.scope) {
            case 1: {
                pRINTDLG.Flags |= 2;
                break;
            }
            case 2: {
                pRINTDLG.Flags |= 1;
                break;
            }
            default: {
                pRINTDLG.Flags |= 0;
            }
        }
        pRINTDLG.nMinPage = 1;
        pRINTDLG.nMaxPage = (short)-1;
        pRINTDLG.nFromPage = (short)Math.min(65535, Math.max(1, this.printerData.startPage));
        pRINTDLG.nToPage = (short)Math.min(65535, Math.max(1, this.printerData.endPage));
        Display display = shell.getDisplay();
        Shell[] shellArray = display.getShells();
        if ((this.getStyle() & 0x30000) != 0) {
            int n6 = 0;
            while (n6 < shellArray.length) {
                if (shellArray[n6].isEnabled() && shellArray[n6] != shell) {
                    shellArray[n6].setEnabled(false);
                } else {
                    shellArray[n6] = null;
                }
                ++n6;
            }
        }
        PrinterData printerData = null;
        String string = "org.eclipse.swt.internal.win32.runMessagesInIdle";
        Object object = display.getData(string);
        display.setData(string, new Boolean(true));
        boolean bl = OS.PrintDlg(pRINTDLG);
        display.setData(string, object);
        if ((this.getStyle() & 0x30000) != 0) {
            n = 0;
            while (n < shellArray.length) {
                if (shellArray[n] != null && !shellArray[n].isDisposed()) {
                    shellArray[n].setEnabled(true);
                }
                ++n;
            }
        }
        if (bl) {
            n4 = pRINTDLG.hDevNames;
            n = OS.GlobalSize(n4) / TCHAR.sizeof * TCHAR.sizeof;
            n5 = OS.GlobalLock(n4);
            short[] sArray = new short[4];
            OS.MoveMemory(sArray, n5, 2 * sArray.length);
            TCHAR tCHAR = new TCHAR(0, n);
            OS.MoveMemory(tCHAR, n5, n);
            OS.GlobalUnlock(n4);
            if (pRINTDLG.hDevNames != 0) {
                OS.GlobalFree(pRINTDLG.hDevNames);
            }
            short s = sArray[0];
            int n7 = 0;
            while (s + n7 < n) {
                if (tCHAR.tcharAt(s + n7) == 0) break;
                ++n7;
            }
            String string2 = tCHAR.toString(s, n7);
            short s2 = sArray[1];
            n7 = 0;
            while (s2 + n7 < n) {
                if (tCHAR.tcharAt(s2 + n7) == 0) break;
                ++n7;
            }
            String string3 = tCHAR.toString(s2, n7);
            short s3 = sArray[2];
            n7 = 0;
            while (s3 + n7 < n) {
                if (tCHAR.tcharAt(s3 + n7) == 0) break;
                ++n7;
            }
            String string4 = tCHAR.toString(s3, n7);
            printerData = new PrinterData(string2, string3);
            if ((pRINTDLG.Flags & 2) != 0) {
                printerData.scope = 1;
                printerData.startPage = pRINTDLG.nFromPage & 0xFFFF;
                printerData.endPage = pRINTDLG.nToPage & 0xFFFF;
            } else if ((pRINTDLG.Flags & 1) != 0) {
                printerData.scope = 2;
            }
            boolean bl2 = printerData.printToFile = (pRINTDLG.Flags & 0x20) != 0;
            if (printerData.printToFile) {
                printerData.fileName = string4;
            }
            printerData.copyCount = pRINTDLG.nCopies;
            printerData.collate = (pRINTDLG.Flags & 0x10) != 0;
            n4 = pRINTDLG.hDevMode;
            n = OS.GlobalSize(n4);
            n5 = OS.GlobalLock(n4);
            printerData.otherData = new byte[n];
            OS.MoveMemory(printerData.otherData, n5, n);
            dEVMODE = OS.IsUnicode ? new DEVMODEW() : new DEVMODEA();
            OS.MoveMemory(dEVMODE, n5, OS.IsUnicode ? OS.DEVMODEW_sizeof() : OS.DEVMODEA_sizeof());
            if ((dEVMODE.dmFields & 1) != 0) {
                short s4 = dEVMODE.dmOrientation;
                printerData.orientation = s4 == 2 ? 2 : 1;
            }
            OS.GlobalUnlock(n4);
            if (pRINTDLG.hDevMode != 0) {
                OS.GlobalFree(pRINTDLG.hDevMode);
            }
            if (n2 != 0) {
                OS.HeapFree(n3, 0, n2);
            }
            this.printerData = printerData;
        }
        return printerData;
    }
}

