/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt.editor;

import java.awt.Paint;
import java.awt.Stroke;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.experimental.chart.swt.editor.SWTAxisEditor;
import org.jfree.experimental.chart.swt.editor.SWTPlotAppearanceEditor;
import org.jfree.experimental.swt.SWTUtils;

class SWTPlotEditor
extends Composite {
    private SWTAxisEditor domainAxisPropertyPanel;
    private SWTAxisEditor rangeAxisPropertyPanel;
    private SWTPlotAppearanceEditor plotAppearance;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.editor.LocalizationBundle");

    public SWTPlotEditor(Composite parent, int style, Plot plot) {
        super(parent, style);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        this.setLayout((Layout)layout);
        Group plotType = new Group((Composite)this, 0);
        FillLayout plotTypeLayout = new FillLayout();
        plotTypeLayout.marginWidth = 4;
        plotTypeLayout.marginHeight = 4;
        plotType.setLayout((Layout)plotTypeLayout);
        plotType.setText(plot.getPlotType() + localizationResources.getString(":"));
        TabFolder tabs = new TabFolder((Composite)plotType, 0);
        TabItem item1 = new TabItem(tabs, 0);
        item1.setText(localizationResources.getString("Domain_Axis"));
        CategoryAxis domainAxis = null;
        if (plot instanceof CategoryPlot) {
            domainAxis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof XYPlot) {
            domainAxis = ((XYPlot)plot).getDomainAxis();
        }
        this.domainAxisPropertyPanel = SWTAxisEditor.getInstance((Composite)tabs, 0, (Axis)domainAxis);
        item1.setControl((Control)this.domainAxisPropertyPanel);
        TabItem item2 = new TabItem(tabs, 0);
        item2.setText(localizationResources.getString("Range_Axis"));
        ValueAxis rangeAxis = null;
        if (plot instanceof CategoryPlot) {
            rangeAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            rangeAxis = ((XYPlot)plot).getRangeAxis();
        }
        this.rangeAxisPropertyPanel = SWTAxisEditor.getInstance((Composite)tabs, 0, (Axis)rangeAxis);
        item2.setControl((Control)this.rangeAxisPropertyPanel);
        TabItem item3 = new TabItem(tabs, 0);
        item3.setText(localizationResources.getString("Appearance"));
        this.plotAppearance = new SWTPlotAppearanceEditor((Composite)tabs, 0, plot);
        item3.setControl((Control)this.plotAppearance);
    }

    public Color getBackgroundPaint() {
        return this.plotAppearance.getBackGroundPaint();
    }

    public Color getOutlinePaint() {
        return this.plotAppearance.getOutlinePaint();
    }

    public Stroke getOutlineStroke() {
        return this.plotAppearance.getStroke();
    }

    public void updatePlotProperties(Plot plot) {
        CategoryPlot p;
        plot.setBackgroundPaint((Paint)SWTUtils.toAwtColor(this.getBackgroundPaint()));
        plot.setOutlinePaint((Paint)SWTUtils.toAwtColor(this.getOutlinePaint()));
        plot.setOutlineStroke(this.getOutlineStroke());
        if (this.domainAxisPropertyPanel != null) {
            CategoryAxis domainAxis = null;
            if (plot instanceof CategoryPlot) {
                p = (CategoryPlot)plot;
                domainAxis = p.getDomainAxis();
            } else if (plot instanceof XYPlot) {
                p = (XYPlot)plot;
                domainAxis = p.getDomainAxis();
            }
            if (domainAxis != null) {
                this.domainAxisPropertyPanel.setAxisProperties((Axis)domainAxis);
            }
        }
        if (this.rangeAxisPropertyPanel != null) {
            ValueAxis rangeAxis = null;
            if (plot instanceof CategoryPlot) {
                p = (CategoryPlot)plot;
                rangeAxis = p.getRangeAxis();
            } else if (plot instanceof XYPlot) {
                p = (XYPlot)plot;
                rangeAxis = p.getRangeAxis();
            }
            if (rangeAxis != null) {
                this.rangeAxisPropertyPanel.setAxisProperties((Axis)rangeAxis);
            }
        }
        if (this.plotAppearance.getPlotOrientation() != null) {
            CategoryPlot p2;
            if (plot instanceof CategoryPlot) {
                p2 = (CategoryPlot)plot;
                p2.setOrientation(this.plotAppearance.getPlotOrientation());
            } else if (plot instanceof XYPlot) {
                p2 = (XYPlot)plot;
                p2.setOrientation(this.plotAppearance.getPlotOrientation());
            }
        }
    }
}

