/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    static ImageTransfer _instance = new ImageTransfer();
    static final String PICT = "PICT";
    static final String TIFF = "TIFF";
    static final int PICTID = ImageTransfer.registerType("PICT");
    static final int TIFFID = ImageTransfer.registerType("TIFF");

    ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -1;
        ImageData imageData = (ImageData)object;
        Image image = new Image((Device)Display.getCurrent(), imageData);
        int n = image.handle;
        int n2 = OS.CGImageGetWidth(n);
        int n3 = OS.CGImageGetHeight(n);
        int n4 = OS.CGImageGetAlphaInfo(n);
        int n5 = OS.CGImageGetBytesPerRow(n);
        Rect rect = new Rect();
        rect.left = 0;
        rect.top = 0;
        rect.right = (short)n2;
        rect.bottom = (short)n3;
        int[] nArray = new int[1];
        int n6 = 24;
        if (n4 != 6) {
            n6 = 32;
        }
        OS.NewGWorldFromPtr(nArray, n6, rect, 0, 0, 0, image.data, n5);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.GetGWorld(nArray2, nArray3);
        OS.SetGWorld(nArray[0], nArray3[0]);
        int n7 = OS.OpenPicture(rect);
        int n8 = OS.GetPortBitMapForCopyBits(nArray[0]);
        OS.CopyBits(n8, n8, rect, rect, (short)0, 0);
        OS.ClosePicture();
        OS.SetGWorld(nArray2[0], nArray3[0]);
        OS.DisposeGWorld(nArray[0]);
        int n9 = OS.GetHandleSize(n7);
        OS.HLock(n7);
        int[] nArray4 = new int[1];
        OS.memmove(nArray4, n7, 4);
        byte[] byArray = new byte[n9];
        OS.memmove(byArray, nArray4[0], n9);
        OS.HUnlock(n7);
        OS.KillPicture(n7);
        image.dispose();
        transferData.data = new byte[][]{byArray};
        transferData.result = 0;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0) {
            return null;
        }
        byte[] byArray = transferData.data[0];
        int n = byArray.length;
        int n2 = OS.NewPtr(n);
        OS.memmove(n2, byArray, n);
        int n3 = OS.CGDataProviderCreateWithData(0, n2, n, 0);
        if (n3 != 0) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = OS.QDPictCreateWithProvider(n3);
            CGRect cGRect = new CGRect();
            OS.QDPictGetBounds(n8, cGRect);
            int n9 = (int)cGRect.width;
            int n10 = (int)cGRect.height;
            int n11 = n9 * 4;
            int n12 = n10 * n11;
            int n13 = OS.NewPtr(n12);
            if (n13 == 0) {
                SWT.error(2);
            }
            if ((n7 = OS.CGDataProviderCreateWithData(0, n13, n12, 0)) == 0) {
                OS.DisposePtr(n13);
                SWT.error(2);
            }
            if ((n6 = OS.CGColorSpaceCreateDeviceRGB()) == 0) {
                SWT.error(2);
            }
            int n14 = OS.CGImageCreate(n9, n10, 8, 32, n11, n6, 6, n7, null, true, 0);
            OS.CGDataProviderRelease(n7);
            if (n14 == 0) {
                OS.DisposePtr(n13);
                SWT.error(2);
            }
            if ((n5 = OS.CGBitmapContextCreate(n13, n9, n10, n4 = OS.CGImageGetBitsPerComponent(n14), n11, n6, 6)) == 0) {
                OS.CGImageRelease(n14);
                OS.DisposePtr(n13);
                SWT.error(2);
            }
            int n15 = OS.QDPictDrawToCGContext(n5, cGRect, n8);
            ImageData imageData = null;
            if (n15 == 0) {
                Image image = Image.carbon_new(Display.getCurrent(), 0, n14, n13);
                imageData = image.getImageData();
                image.dispose();
            }
            OS.CGContextRelease(n5);
            OS.QDPictRelease(n8);
            return imageData;
        }
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{PICTID};
    }

    protected String[] getTypeNames() {
        return new String[]{PICT};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

