/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Tray
extends Widget {
    int itemCount;
    TrayItem[] items = new TrayItem[4];

    Tray(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
    }

    void createItem(TrayItem trayItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TrayItem[] trayItemArray = new TrayItem[this.items.length + 4];
            System.arraycopy(this.items, 0, trayItemArray, 0, this.items.length);
            this.items = trayItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = trayItem;
    }

    void destroyItem(TrayItem trayItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == trayItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
    }

    public TrayItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TrayItem[] getItems() {
        this.checkWidget();
        TrayItem[] trayItemArray = new TrayItem[this.itemCount];
        System.arraycopy(this.items, 0, trayItemArray, 0, trayItemArray.length);
        return trayItemArray;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                TrayItem trayItem = this.items[n];
                if (trayItem != null && !trayItem.isDisposed()) {
                    trayItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.display.tray == this) {
            this.display.tray = null;
        }
    }
}

