/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.Density;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionParams
extends RenderParams {
    private final ILayoutPullParser mLayoutDescription;
    private final RenderingMode mRenderingMode;
    private boolean mLayoutOnly = false;
    private Map<ResourceReference, AdapterBinding> mAdapterBindingMap;
    private boolean mExtendedViewInfoMode = false;

    public SessionParams(ILayoutPullParser layoutDescription, RenderingMode renderingMode, Object projectKey, int screenWidth, int screenHeight, Density density, float xdpi, float ydpi, RenderResources renderResources, IProjectCallback projectCallback, int minSdkVersion, int targetSdkVersion, LayoutLog log) {
        super(projectKey, screenWidth, screenHeight, density, xdpi, ydpi, renderResources, projectCallback, minSdkVersion, targetSdkVersion, log);
        this.mLayoutDescription = layoutDescription;
        this.mRenderingMode = renderingMode;
    }

    public SessionParams(SessionParams params) {
        super(params);
        this.mLayoutDescription = params.mLayoutDescription;
        this.mRenderingMode = params.mRenderingMode;
        if (params.mAdapterBindingMap != null) {
            this.mAdapterBindingMap = new HashMap<ResourceReference, AdapterBinding>(params.mAdapterBindingMap);
        }
        this.mExtendedViewInfoMode = params.mExtendedViewInfoMode;
    }

    public ILayoutPullParser getLayoutDescription() {
        return this.mLayoutDescription;
    }

    public RenderingMode getRenderingMode() {
        return this.mRenderingMode;
    }

    public void setLayoutOnly() {
        this.mLayoutOnly = true;
    }

    public boolean isLayoutOnly() {
        return this.mLayoutOnly;
    }

    public void addAdapterBinding(ResourceReference reference, AdapterBinding data) {
        if (this.mAdapterBindingMap == null) {
            this.mAdapterBindingMap = new HashMap<ResourceReference, AdapterBinding>();
        }
        this.mAdapterBindingMap.put(reference, data);
    }

    public Map<ResourceReference, AdapterBinding> getAdapterBindings() {
        if (this.mAdapterBindingMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.mAdapterBindingMap);
    }

    public void setExtendedViewInfoMode(boolean mode) {
        this.mExtendedViewInfoMode = mode;
    }

    public boolean getExtendedViewInfoMode() {
        return this.mExtendedViewInfoMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderingMode {
        NORMAL(false, false),
        V_SCROLL(false, true),
        H_SCROLL(true, false),
        FULL_EXPAND(true, true);

        private final boolean mHorizExpand;
        private final boolean mVertExpand;

        private RenderingMode(boolean horizExpand, boolean vertExpand) {
            this.mHorizExpand = horizExpand;
            this.mVertExpand = vertExpand;
        }

        public boolean isHorizExpand() {
            return this.mHorizExpand;
        }

        public boolean isVertExpand() {
            return this.mVertExpand;
        }
    }
}

