/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.resources.Density;
import com.android.resources.ScreenSize;

public abstract class RenderParams {
    public static final long DEFAULT_TIMEOUT = 250L;
    private final Object mProjectKey;
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final Density mDensity;
    private final float mXdpi;
    private final float mYdpi;
    private final RenderResources mRenderResources;
    private final IProjectCallback mProjectCallback;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    private final LayoutLog mLog;
    private boolean mCustomBackgroundEnabled;
    private int mCustomBackgroundColor;
    private long mTimeout;
    private IImageFactory mImageFactory = null;
    private ScreenSize mConfigScreenSize = null;
    private String mAppIcon = null;
    private String mAppLabel = null;
    private String mLocale = null;
    private boolean mForceNoDecor;

    public RenderParams(Object projectKey, int screenWidth, int screenHeight, Density density, float xdpi, float ydpi, RenderResources renderResources, IProjectCallback projectCallback, int minSdkVersion, int targetSdkVersion, LayoutLog log) {
        this.mProjectKey = projectKey;
        this.mScreenWidth = screenWidth;
        this.mScreenHeight = screenHeight;
        this.mDensity = density;
        this.mXdpi = xdpi;
        this.mYdpi = ydpi;
        this.mRenderResources = renderResources;
        this.mProjectCallback = projectCallback;
        this.mMinSdkVersion = minSdkVersion;
        this.mTargetSdkVersion = targetSdkVersion;
        this.mLog = log;
        this.mCustomBackgroundEnabled = false;
        this.mTimeout = 250L;
    }

    public RenderParams(RenderParams params) {
        this.mProjectKey = params.mProjectKey;
        this.mScreenWidth = params.mScreenWidth;
        this.mScreenHeight = params.mScreenHeight;
        this.mDensity = params.mDensity;
        this.mXdpi = params.mXdpi;
        this.mYdpi = params.mYdpi;
        this.mRenderResources = params.mRenderResources;
        this.mProjectCallback = params.mProjectCallback;
        this.mMinSdkVersion = params.mMinSdkVersion;
        this.mTargetSdkVersion = params.mTargetSdkVersion;
        this.mLog = params.mLog;
        this.mCustomBackgroundEnabled = params.mCustomBackgroundEnabled;
        this.mCustomBackgroundColor = params.mCustomBackgroundColor;
        this.mTimeout = params.mTimeout;
        this.mImageFactory = params.mImageFactory;
        this.mConfigScreenSize = params.mConfigScreenSize;
        this.mAppIcon = params.mAppIcon;
        this.mAppLabel = params.mAppLabel;
        this.mLocale = params.mLocale;
        this.mForceNoDecor = params.mForceNoDecor;
    }

    public void setOverrideBgColor(int color) {
        this.mCustomBackgroundEnabled = true;
        this.mCustomBackgroundColor = color;
    }

    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    public void setImageFactory(IImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    public void setConfigScreenSize(ScreenSize size) {
        this.mConfigScreenSize = size;
    }

    public void setAppIcon(String appIcon) {
        this.mAppIcon = appIcon;
    }

    public void setAppLabel(String appLabel) {
        this.mAppLabel = appLabel;
    }

    public void setLocale(String locale) {
        this.mLocale = locale;
    }

    public void setForceNoDecor() {
        this.mForceNoDecor = true;
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    public Density getDensity() {
        return this.mDensity;
    }

    public float getXdpi() {
        return this.mXdpi;
    }

    public float getYdpi() {
        return this.mYdpi;
    }

    public RenderResources getResources() {
        return this.mRenderResources;
    }

    public IProjectCallback getProjectCallback() {
        return this.mProjectCallback;
    }

    public LayoutLog getLog() {
        return this.mLog;
    }

    public boolean isBgColorOverridden() {
        return this.mCustomBackgroundEnabled;
    }

    public int getOverrideBgColor() {
        return this.mCustomBackgroundColor;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public IImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    public ScreenSize getConfigScreenSize() {
        return this.mConfigScreenSize;
    }

    public String getAppIcon() {
        return this.mAppIcon;
    }

    public String getAppLabel() {
        return this.mAppLabel;
    }

    public String getLocale() {
        return this.mLocale;
    }

    public boolean isForceNoDecor() {
        return this.mForceNoDecor;
    }
}

