/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;

public final class ThrowingCstInsn
extends CstInsn {
    private final TypeList catches;

    public ThrowingCstInsn(Rop opcode, SourcePosition position, RegisterSpecList sources, TypeList catches, Constant cst) {
        super(opcode, position, null, sources, cst);
        if (opcode.getBranchingness() != 6) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        if (catches == null) {
            throw new NullPointerException("catches == null");
        }
        this.catches = catches;
    }

    public String getInlineString() {
        return this.getConstant().toHuman() + " " + ThrowingInsn.toCatchString(this.catches);
    }

    public TypeList getCatches() {
        return this.catches;
    }

    public void accept(Insn.Visitor visitor) {
        visitor.visitThrowingCstInsn(this);
    }

    public Insn withAddedCatch(Type type) {
        return new ThrowingCstInsn(this.getOpcode(), this.getPosition(), this.getSources(), this.catches.withAddedType(type), this.getConstant());
    }

    public Insn withRegisterOffset(int delta) {
        return new ThrowingCstInsn(this.getOpcode(), this.getPosition(), this.getSources().withOffset(delta), this.catches, this.getConstant());
    }

    public Insn withNewRegisters(RegisterSpec result, RegisterSpecList sources) {
        return new ThrowingCstInsn(this.getOpcode(), this.getPosition(), sources, this.catches, this.getConstant());
    }
}

