/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.InsnFormat;

public final class Dop {
    private final int opcode;
    private final int family;
    private final InsnFormat format;
    private final boolean hasResult;
    private final String name;

    public Dop(int opcode, int family, InsnFormat format, boolean hasResult, String name) {
        if (opcode < -1 || opcode > 255) {
            throw new IllegalArgumentException("bogus opcode");
        }
        if (family < -1 || family > 255) {
            throw new IllegalArgumentException("bogus family");
        }
        if (format == null) {
            throw new NullPointerException("format == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.opcode = opcode;
        this.family = family;
        this.format = format;
        this.hasResult = hasResult;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int getFamily() {
        return this.family;
    }

    public InsnFormat getFormat() {
        return this.format;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public String getName() {
        return this.name;
    }

    public Dop getOppositeTest() {
        switch (this.opcode) {
            case 50: {
                return Dops.IF_NE;
            }
            case 51: {
                return Dops.IF_EQ;
            }
            case 52: {
                return Dops.IF_GE;
            }
            case 53: {
                return Dops.IF_LT;
            }
            case 54: {
                return Dops.IF_LE;
            }
            case 55: {
                return Dops.IF_GT;
            }
            case 56: {
                return Dops.IF_NEZ;
            }
            case 57: {
                return Dops.IF_EQZ;
            }
            case 58: {
                return Dops.IF_GEZ;
            }
            case 59: {
                return Dops.IF_LTZ;
            }
            case 60: {
                return Dops.IF_LEZ;
            }
            case 61: {
                return Dops.IF_GTZ;
            }
        }
        throw new IllegalArgumentException("bogus opcode: " + this);
    }
}

