/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.android.camera.burst;

import java.util.List;

/**
 * Represents an artifact generated by burst.
 * <p/>
 * An artifact consists of media items of the same type. An artifact can be a
 * collection of images, collages, GIFs or any other media item.
 * <p/>
 * The type of artifact is returned by {@link #getType()}.
 */
public interface BurstArtifact {
    /**
     * Gets all media items in the artifact.
     *
     * @return all media items in the artifact.
     */
    public List<BurstMediaItem> getMediaItems();

    /**
     * Returns the type name of this artifact.
     */
    public String getType();

    /**
     * Returns the localized name of this artifact.
     */
    public String getLocalizedName();
}