/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
// ============================================================(Auto)=
// FILE: h245_decoder.h
//
// DESC: PER Decode routines for H.245
// -------------------------------------------------------------------
//  Copyright (c) 1998- 2000, PacketVideo Corporation.
//                   All Rights Reserved.
// ===================================================================

#ifndef PER_DECODER
#define PER_DECODER

void Decode_MultimediaSystemControlMessage(PS_MultimediaSystemControlMessage x, PS_InStream stream);
void Decode_RequestMessage(PS_RequestMessage x, PS_InStream stream);
void Decode_ResponseMessage(PS_ResponseMessage x, PS_InStream stream);
void Decode_CommandMessage(PS_CommandMessage x, PS_InStream stream);
void Decode_IndicationMessage(PS_IndicationMessage x, PS_InStream stream);
void Decode_GenericInformation(PS_GenericInformation x, PS_InStream stream);
void Decode_NonStandardMessage(PS_NonStandardMessage x, PS_InStream stream);
void Decode_NonStandardParameter(PS_NonStandardParameter x, PS_InStream stream);
void Decode_NonStandardIdentifier(PS_NonStandardIdentifier x, PS_InStream stream);
void Decode_H221NonStandard(PS_H221NonStandard x, PS_InStream stream);
void Decode_MasterSlaveDetermination(PS_MasterSlaveDetermination x, PS_InStream stream);
void Decode_MasterSlaveDeterminationAck(PS_MasterSlaveDeterminationAck x, PS_InStream stream);
void Decode_Decision(PS_Decision x, PS_InStream stream);
void Decode_MasterSlaveDeterminationReject(PS_MasterSlaveDeterminationReject x, PS_InStream stream);
void Decode_MsdRejectCause(PS_MsdRejectCause x, PS_InStream stream);
void Decode_MasterSlaveDeterminationRelease(PS_MasterSlaveDeterminationRelease x, PS_InStream stream);
void Decode_TerminalCapabilitySet(PS_TerminalCapabilitySet x, PS_InStream stream);
void Decode_CapabilityTableEntry(PS_CapabilityTableEntry x, PS_InStream stream);
void Decode_CapabilityDescriptor(PS_CapabilityDescriptor x, PS_InStream stream);
void Decode_AlternativeCapabilitySet(PS_AlternativeCapabilitySet x, PS_InStream stream);
void Decode_TerminalCapabilitySetAck(PS_TerminalCapabilitySetAck x, PS_InStream stream);
void Decode_TerminalCapabilitySetReject(PS_TerminalCapabilitySetReject x, PS_InStream stream);
void Decode_TcsRejectCause(PS_TcsRejectCause x, PS_InStream stream);
void Decode_TableEntryCapacityExceeded(PS_TableEntryCapacityExceeded x, PS_InStream stream);
void Decode_TerminalCapabilitySetRelease(PS_TerminalCapabilitySetRelease x, PS_InStream stream);
void Decode_Capability(PS_Capability x, PS_InStream stream);
void Decode_H233EncryptionReceiveCapability(PS_H233EncryptionReceiveCapability x, PS_InStream stream);
void Decode_H235SecurityCapability(PS_H235SecurityCapability x, PS_InStream stream);
void Decode_MultiplexCapability(PS_MultiplexCapability x, PS_InStream stream);
void Decode_H222Capability(PS_H222Capability x, PS_InStream stream);
void Decode_VCCapability(PS_VCCapability x, PS_InStream stream);
void Decode_Aal1ViaGateway(PS_Aal1ViaGateway x, PS_InStream stream);
void Decode_AvailableBitRates(PS_AvailableBitRates x, PS_InStream stream);
void Decode_VccAal5Type(PS_VccAal5Type x, PS_InStream stream);
void Decode_RangeOfBitRates(PS_RangeOfBitRates x, PS_InStream stream);
void Decode_VccAal5(PS_VccAal5 x, PS_InStream stream);
void Decode_VccAal1(PS_VccAal1 x, PS_InStream stream);
void Decode_H223Capability(PS_H223Capability x, PS_InStream stream);
void Decode_MobileOperationTransmitCapability(PS_MobileOperationTransmitCapability x, PS_InStream stream);
void Decode_H223MultiplexTableCapability(PS_H223MultiplexTableCapability x, PS_InStream stream);
void Decode_Enhanced(PS_Enhanced x, PS_InStream stream);
void Decode_H223AnnexCCapability(PS_H223AnnexCCapability x, PS_InStream stream);
void Decode_V76Capability(PS_V76Capability x, PS_InStream stream);
void Decode_V75Capability(PS_V75Capability x, PS_InStream stream);
void Decode_H2250Capability(PS_H2250Capability x, PS_InStream stream);
void Decode_McCapability(PS_McCapability x, PS_InStream stream);
void Decode_MediaPacketizationCapability(PS_MediaPacketizationCapability x, PS_InStream stream);
void Decode_RSVPParameters(PS_RSVPParameters x, PS_InStream stream);
void Decode_QOSMode(PS_QOSMode x, PS_InStream stream);
void Decode_ATMParameters(PS_ATMParameters x, PS_InStream stream);
void Decode_QOSCapability(PS_QOSCapability x, PS_InStream stream);
void Decode_MediaTransportType(PS_MediaTransportType x, PS_InStream stream);
void Decode_Atm_AAL5_compressed(PS_Atm_AAL5_compressed x, PS_InStream stream);
void Decode_MediaChannelCapability(PS_MediaChannelCapability x, PS_InStream stream);
void Decode_TransportCapability(PS_TransportCapability x, PS_InStream stream);
void Decode_RedundancyEncodingCapability(PS_RedundancyEncodingCapability x, PS_InStream stream);
void Decode_RedundancyEncodingMethod(PS_RedundancyEncodingMethod x, PS_InStream stream);
void Decode_RTPH263VideoRedundancyEncoding(PS_RTPH263VideoRedundancyEncoding x, PS_InStream stream);
void Decode_FrameToThreadMapping(PS_FrameToThreadMapping x, PS_InStream stream);
void Decode_RTPH263VideoRedundancyFrameMapping(PS_RTPH263VideoRedundancyFrameMapping x, PS_InStream stream);
void Decode_MultipointCapability(PS_MultipointCapability x, PS_InStream stream);
void Decode_MediaDistributionCapability(PS_MediaDistributionCapability x, PS_InStream stream);
void Decode_VideoCapability(PS_VideoCapability x, PS_InStream stream);
void Decode_H261VideoCapability(PS_H261VideoCapability x, PS_InStream stream);
void Decode_H262VideoCapability(PS_H262VideoCapability x, PS_InStream stream);
void Decode_H263VideoCapability(PS_H263VideoCapability x, PS_InStream stream);
void Decode_EnhancementLayerInfo(PS_EnhancementLayerInfo x, PS_InStream stream);
void Decode_BEnhancementParameters(PS_BEnhancementParameters x, PS_InStream stream);
void Decode_EnhancementOptions(PS_EnhancementOptions x, PS_InStream stream);
void Decode_H263Options(PS_H263Options x, PS_InStream stream);
void Decode_TransparencyParameters(PS_TransparencyParameters x, PS_InStream stream);
void Decode_RefPictureSelection(PS_RefPictureSelection x, PS_InStream stream);
void Decode_VideoBackChannelSend(PS_VideoBackChannelSend x, PS_InStream stream);
void Decode_AdditionalPictureMemory(PS_AdditionalPictureMemory x, PS_InStream stream);
void Decode_CustomPictureClockFrequency(PS_CustomPictureClockFrequency x, PS_InStream stream);
void Decode_CustomPictureFormat(PS_CustomPictureFormat x, PS_InStream stream);
void Decode_PixelAspectInformation(PS_PixelAspectInformation x, PS_InStream stream);
void Decode_ExtendedPARItem(PS_ExtendedPARItem x, PS_InStream stream);
void Decode_MPI(PS_MPI x, PS_InStream stream);
void Decode_CustomPCFItem(PS_CustomPCFItem x, PS_InStream stream);
void Decode_H263VideoModeCombos(PS_H263VideoModeCombos x, PS_InStream stream);
void Decode_H263ModeComboFlags(PS_H263ModeComboFlags x, PS_InStream stream);
void Decode_IS11172VideoCapability(PS_IS11172VideoCapability x, PS_InStream stream);
void Decode_AudioCapability(PS_AudioCapability x, PS_InStream stream);
void Decode_G7231(PS_G7231 x, PS_InStream stream);
void Decode_G729Extensions(PS_G729Extensions x, PS_InStream stream);
void Decode_G7231AnnexCCapability(PS_G7231AnnexCCapability x, PS_InStream stream);
void Decode_G723AnnexCAudioMode(PS_G723AnnexCAudioMode x, PS_InStream stream);
void Decode_IS11172AudioCapability(PS_IS11172AudioCapability x, PS_InStream stream);
void Decode_IS13818AudioCapability(PS_IS13818AudioCapability x, PS_InStream stream);
void Decode_GSMAudioCapability(PS_GSMAudioCapability x, PS_InStream stream);
void Decode_DataApplicationCapability(PS_DataApplicationCapability x, PS_InStream stream);
void Decode_Application(PS_Application x, PS_InStream stream);
void Decode_T38fax(PS_T38fax x, PS_InStream stream);
void Decode_Nlpid(PS_Nlpid x, PS_InStream stream);
void Decode_T84(PS_T84 x, PS_InStream stream);
void Decode_DataProtocolCapability(PS_DataProtocolCapability x, PS_InStream stream);
void Decode_V76wCompression(PS_V76wCompression x, PS_InStream stream);
void Decode_CompressionType(PS_CompressionType x, PS_InStream stream);
void Decode_V42bis(PS_V42bis x, PS_InStream stream);
void Decode_T84Profile(PS_T84Profile x, PS_InStream stream);
void Decode_T84Restricted(PS_T84Restricted x, PS_InStream stream);
void Decode_T38FaxProfile(PS_T38FaxProfile x, PS_InStream stream);
void Decode_T38FaxRateManagement(PS_T38FaxRateManagement x, PS_InStream stream);
void Decode_T38FaxUdpOptions(PS_T38FaxUdpOptions x, PS_InStream stream);
void Decode_T38FaxUdpEC(PS_T38FaxUdpEC x, PS_InStream stream);
void Decode_EncryptionAuthenticationAndIntegrity(PS_EncryptionAuthenticationAndIntegrity x, PS_InStream stream);
void Decode_EncryptionCapability(PS_EncryptionCapability x, PS_InStream stream);
void Decode_MediaEncryptionAlgorithm(PS_MediaEncryptionAlgorithm x, PS_InStream stream);
void Decode_AuthenticationCapability(PS_AuthenticationCapability x, PS_InStream stream);
void Decode_IntegrityCapability(PS_IntegrityCapability x, PS_InStream stream);
void Decode_UserInputCapability(PS_UserInputCapability x, PS_InStream stream);
void Decode_ConferenceCapability(PS_ConferenceCapability x, PS_InStream stream);
void Decode_GenericCapability(PS_GenericCapability x, PS_InStream stream);
void Decode_CapabilityIdentifier(PS_CapabilityIdentifier x, PS_InStream stream);
void Decode_GenericParameter(PS_GenericParameter x, PS_InStream stream);
void Decode_ParameterIdentifier(PS_ParameterIdentifier x, PS_InStream stream);
void Decode_ParameterValue(PS_ParameterValue x, PS_InStream stream);
void Decode_OpenLogicalChannel(PS_OpenLogicalChannel x, PS_InStream stream);
void Decode_ReverseLogicalChannelParameters(PS_ReverseLogicalChannelParameters x, PS_InStream stream);
void Decode_RlcMultiplexParameters(PS_RlcMultiplexParameters x, PS_InStream stream);
void Decode_ForwardLogicalChannelParameters(PS_ForwardLogicalChannelParameters x, PS_InStream stream);
void Decode_MultiplexParameters(PS_MultiplexParameters x, PS_InStream stream);
void Decode_NetworkAccessParameters(PS_NetworkAccessParameters x, PS_InStream stream);
void Decode_T120SetupProcedure(PS_T120SetupProcedure x, PS_InStream stream);
void Decode_NetworkAddress(PS_NetworkAddress x, PS_InStream stream);
void Decode_Distribution(PS_Distribution x, PS_InStream stream);
void Decode_Q2931Address(PS_Q2931Address x, PS_InStream stream);
void Decode_Address(PS_Address x, PS_InStream stream);
void Decode_V75Parameters(PS_V75Parameters x, PS_InStream stream);
void Decode_DataType(PS_DataType x, PS_InStream stream);
void Decode_H235Media(PS_H235Media x, PS_InStream stream);
void Decode_MediaType(PS_MediaType x, PS_InStream stream);
void Decode_H222LogicalChannelParameters(PS_H222LogicalChannelParameters x, PS_InStream stream);
void Decode_H223LogicalChannelParameters(PS_H223LogicalChannelParameters x, PS_InStream stream);
void Decode_AdaptationLayerType(PS_AdaptationLayerType x, PS_InStream stream);
void Decode_Al3(PS_Al3 x, PS_InStream stream);
void Decode_H223AL1MParameters(PS_H223AL1MParameters x, PS_InStream stream);
void Decode_ArqType(PS_ArqType x, PS_InStream stream);
void Decode_CrcLength(PS_CrcLength x, PS_InStream stream);
void Decode_HeaderFEC(PS_HeaderFEC x, PS_InStream stream);
void Decode_TransferMode(PS_TransferMode x, PS_InStream stream);
void Decode_H223AL2MParameters(PS_H223AL2MParameters x, PS_InStream stream);
void Decode_Al2HeaderFEC(PS_Al2HeaderFEC x, PS_InStream stream);
void Decode_H223AL3MParameters(PS_H223AL3MParameters x, PS_InStream stream);
void Decode_Al3ArqType(PS_Al3ArqType x, PS_InStream stream);
void Decode_Al3CrcLength(PS_Al3CrcLength x, PS_InStream stream);
void Decode_HeaderFormat(PS_HeaderFormat x, PS_InStream stream);
void Decode_H223AnnexCArqParameters(PS_H223AnnexCArqParameters x, PS_InStream stream);
void Decode_NumberOfRetransmissions(PS_NumberOfRetransmissions x, PS_InStream stream);
void Decode_V76LogicalChannelParameters(PS_V76LogicalChannelParameters x, PS_InStream stream);
void Decode_Mode(PS_Mode x, PS_InStream stream);
void Decode_ERM(PS_ERM x, PS_InStream stream);
void Decode_Recovery(PS_Recovery x, PS_InStream stream);
void Decode_SuspendResume(PS_SuspendResume x, PS_InStream stream);
void Decode_V76HDLCParameters(PS_V76HDLCParameters x, PS_InStream stream);
void Decode_CRCLength(PS_CRCLength x, PS_InStream stream);
void Decode_H2250LogicalChannelParameters(PS_H2250LogicalChannelParameters x, PS_InStream stream);
void Decode_MediaPacketization(PS_MediaPacketization x, PS_InStream stream);
void Decode_RTPPayloadType(PS_RTPPayloadType x, PS_InStream stream);
void Decode_PayloadDescriptor(PS_PayloadDescriptor x, PS_InStream stream);
void Decode_RedundancyEncoding(PS_RedundancyEncoding x, PS_InStream stream);
void Decode_TransportAddress(PS_TransportAddress x, PS_InStream stream);
void Decode_UnicastAddress(PS_UnicastAddress x, PS_InStream stream);
void Decode_IPSourceRouteAddress(PS_IPSourceRouteAddress x, PS_InStream stream);
void Decode_Routing(PS_Routing x, PS_InStream stream);
void Decode_IP6Address(PS_IP6Address x, PS_InStream stream);
void Decode_IPXAddress(PS_IPXAddress x, PS_InStream stream);
void Decode_IPAddress(PS_IPAddress x, PS_InStream stream);
void Decode_MulticastAddress(PS_MulticastAddress x, PS_InStream stream);
void Decode_MaIp6Address(PS_MaIp6Address x, PS_InStream stream);
void Decode_MaIpAddress(PS_MaIpAddress x, PS_InStream stream);
void Decode_EncryptionSync(PS_EncryptionSync x, PS_InStream stream);
void Decode_EscrowData(PS_EscrowData x, PS_InStream stream);
void Decode_OpenLogicalChannelAck(PS_OpenLogicalChannelAck x, PS_InStream stream);
void Decode_ForwardMultiplexAckParameters(PS_ForwardMultiplexAckParameters x, PS_InStream stream);
void Decode_AckReverseLogicalChannelParameters(PS_AckReverseLogicalChannelParameters x, PS_InStream stream);
void Decode_AckMultiplexParameters(PS_AckMultiplexParameters x, PS_InStream stream);
void Decode_OpenLogicalChannelReject(PS_OpenLogicalChannelReject x, PS_InStream stream);
void Decode_OlcRejectCause(PS_OlcRejectCause x, PS_InStream stream);
void Decode_OpenLogicalChannelConfirm(PS_OpenLogicalChannelConfirm x, PS_InStream stream);
void Decode_H2250LogicalChannelAckParameters(PS_H2250LogicalChannelAckParameters x, PS_InStream stream);
void Decode_CloseLogicalChannel(PS_CloseLogicalChannel x, PS_InStream stream);
void Decode_Reason(PS_Reason x, PS_InStream stream);
void Decode_Source(PS_Source x, PS_InStream stream);
void Decode_CloseLogicalChannelAck(PS_CloseLogicalChannelAck x, PS_InStream stream);
void Decode_RequestChannelClose(PS_RequestChannelClose x, PS_InStream stream);
void Decode_RccReason(PS_RccReason x, PS_InStream stream);
void Decode_RequestChannelCloseAck(PS_RequestChannelCloseAck x, PS_InStream stream);
void Decode_RequestChannelCloseReject(PS_RequestChannelCloseReject x, PS_InStream stream);
void Decode_RccRejectCause(PS_RccRejectCause x, PS_InStream stream);
void Decode_RequestChannelCloseRelease(PS_RequestChannelCloseRelease x, PS_InStream stream);
void Decode_MultiplexEntrySend(PS_MultiplexEntrySend x, PS_InStream stream);
void Decode_MultiplexEntryDescriptor(PS_MultiplexEntryDescriptor x, PS_InStream stream);
void Decode_MultiplexElement(PS_MultiplexElement x, PS_InStream stream);
void Decode_RepeatCount(PS_RepeatCount x, PS_InStream stream);
void Decode_MuxType(PS_MuxType x, PS_InStream stream);
void Decode_MultiplexEntrySendAck(PS_MultiplexEntrySendAck x, PS_InStream stream);
void Decode_MultiplexEntrySendReject(PS_MultiplexEntrySendReject x, PS_InStream stream);
void Decode_MultiplexEntryRejectionDescriptions(PS_MultiplexEntryRejectionDescriptions x, PS_InStream stream);
void Decode_MeRejectCause(PS_MeRejectCause x, PS_InStream stream);
void Decode_MultiplexEntrySendRelease(PS_MultiplexEntrySendRelease x, PS_InStream stream);
void Decode_RequestMultiplexEntry(PS_RequestMultiplexEntry x, PS_InStream stream);
void Decode_RequestMultiplexEntryAck(PS_RequestMultiplexEntryAck x, PS_InStream stream);
void Decode_RequestMultiplexEntryReject(PS_RequestMultiplexEntryReject x, PS_InStream stream);
void Decode_RequestMultiplexEntryRejectionDescriptions(PS_RequestMultiplexEntryRejectionDescriptions x, PS_InStream stream);
void Decode_RmeRejectCause(PS_RmeRejectCause x, PS_InStream stream);
void Decode_RequestMultiplexEntryRelease(PS_RequestMultiplexEntryRelease x, PS_InStream stream);
void Decode_RequestMode(PS_RequestMode x, PS_InStream stream);
void Decode_RequestModeAck(PS_RequestModeAck x, PS_InStream stream);
void Decode_Response(PS_Response x, PS_InStream stream);
void Decode_RequestModeReject(PS_RequestModeReject x, PS_InStream stream);
void Decode_RmRejectCause(PS_RmRejectCause x, PS_InStream stream);
void Decode_RequestModeRelease(PS_RequestModeRelease x, PS_InStream stream);
void Decode_ModeDescription(PS_ModeDescription x, PS_InStream stream);
void Decode_ModeElement(PS_ModeElement x, PS_InStream stream);
void Decode_ModeType(PS_ModeType x, PS_InStream stream);
void Decode_H235Mode(PS_H235Mode x, PS_InStream stream);
void Decode_MediaMode(PS_MediaMode x, PS_InStream stream);
void Decode_H223ModeParameters(PS_H223ModeParameters x, PS_InStream stream);
void Decode_ModeAdaptationLayerType(PS_ModeAdaptationLayerType x, PS_InStream stream);
void Decode_ModeAl3(PS_ModeAl3 x, PS_InStream stream);
void Decode_V76ModeParameters(PS_V76ModeParameters x, PS_InStream stream);
void Decode_H2250ModeParameters(PS_H2250ModeParameters x, PS_InStream stream);
void Decode_RedundancyEncodingMode(PS_RedundancyEncodingMode x, PS_InStream stream);
void Decode_SecondaryEncoding(PS_SecondaryEncoding x, PS_InStream stream);
void Decode_VideoMode(PS_VideoMode x, PS_InStream stream);
void Decode_H261VideoMode(PS_H261VideoMode x, PS_InStream stream);
void Decode_Resolution(PS_Resolution x, PS_InStream stream);
void Decode_H262VideoMode(PS_H262VideoMode x, PS_InStream stream);
void Decode_ProfileAndLevel(PS_ProfileAndLevel x, PS_InStream stream);
void Decode_H263VideoMode(PS_H263VideoMode x, PS_InStream stream);
void Decode_H263Resolution(PS_H263Resolution x, PS_InStream stream);
void Decode_IS11172VideoMode(PS_IS11172VideoMode x, PS_InStream stream);
void Decode_AudioMode(PS_AudioMode x, PS_InStream stream);
void Decode_ModeG7231(PS_ModeG7231 x, PS_InStream stream);
void Decode_IS11172AudioMode(PS_IS11172AudioMode x, PS_InStream stream);
void Decode_MultichannelType(PS_MultichannelType x, PS_InStream stream);
void Decode_AudioSampling(PS_AudioSampling x, PS_InStream stream);
void Decode_AudioLayer(PS_AudioLayer x, PS_InStream stream);
void Decode_IS13818AudioMode(PS_IS13818AudioMode x, PS_InStream stream);
void Decode_Is13818MultichannelType(PS_Is13818MultichannelType x, PS_InStream stream);
void Decode_Is13818AudioSampling(PS_Is13818AudioSampling x, PS_InStream stream);
void Decode_Is13818AudioLayer(PS_Is13818AudioLayer x, PS_InStream stream);
void Decode_G7231AnnexCMode(PS_G7231AnnexCMode x, PS_InStream stream);
void Decode_ModeG723AnnexCAudioMode(PS_ModeG723AnnexCAudioMode x, PS_InStream stream);
void Decode_DataMode(PS_DataMode x, PS_InStream stream);
void Decode_DmApplication(PS_DmApplication x, PS_InStream stream);
void Decode_DmT38fax(PS_DmT38fax x, PS_InStream stream);
void Decode_DmNlpid(PS_DmNlpid x, PS_InStream stream);
void Decode_EncryptionMode(PS_EncryptionMode x, PS_InStream stream);
void Decode_RoundTripDelayRequest(PS_RoundTripDelayRequest x, PS_InStream stream);
void Decode_RoundTripDelayResponse(PS_RoundTripDelayResponse x, PS_InStream stream);
void Decode_MaintenanceLoopRequest(PS_MaintenanceLoopRequest x, PS_InStream stream);
void Decode_MlRequestType(PS_MlRequestType x, PS_InStream stream);
void Decode_MaintenanceLoopAck(PS_MaintenanceLoopAck x, PS_InStream stream);
void Decode_MlAckType(PS_MlAckType x, PS_InStream stream);
void Decode_MaintenanceLoopReject(PS_MaintenanceLoopReject x, PS_InStream stream);
void Decode_MlRejectCause(PS_MlRejectCause x, PS_InStream stream);
void Decode_MlRejectType(PS_MlRejectType x, PS_InStream stream);
void Decode_MaintenanceLoopOffCommand(PS_MaintenanceLoopOffCommand x, PS_InStream stream);
void Decode_CommunicationModeCommand(PS_CommunicationModeCommand x, PS_InStream stream);
void Decode_CommunicationModeRequest(PS_CommunicationModeRequest x, PS_InStream stream);
void Decode_CommunicationModeResponse(PS_CommunicationModeResponse x, PS_InStream stream);
void Decode_CommunicationModeTableEntry(PS_CommunicationModeTableEntry x, PS_InStream stream);
void Decode_CmtDataType(PS_CmtDataType x, PS_InStream stream);
void Decode_ConferenceRequest(PS_ConferenceRequest x, PS_InStream stream);
void Decode_RequestTerminalCertificate(PS_RequestTerminalCertificate x, PS_InStream stream);
void Decode_CertSelectionCriteria(PS_CertSelectionCriteria x, PS_InStream stream);
void Decode_Criteria(PS_Criteria x, PS_InStream stream);
void Decode_TerminalLabel(PS_TerminalLabel x, PS_InStream stream);
void Decode_ConferenceResponse(PS_ConferenceResponse x, PS_InStream stream);
void Decode_SendThisSourceResponse(PS_SendThisSourceResponse x, PS_InStream stream);
void Decode_MakeTerminalBroadcasterResponse(PS_MakeTerminalBroadcasterResponse x, PS_InStream stream);
void Decode_BroadcastMyLogicalChannelResponse(PS_BroadcastMyLogicalChannelResponse x, PS_InStream stream);
void Decode_TerminalCertificateResponse(PS_TerminalCertificateResponse x, PS_InStream stream);
void Decode_ChairTokenOwnerResponse(PS_ChairTokenOwnerResponse x, PS_InStream stream);
void Decode_ExtensionAddressResponse(PS_ExtensionAddressResponse x, PS_InStream stream);
void Decode_MakeMeChairResponse(PS_MakeMeChairResponse x, PS_InStream stream);
void Decode_PasswordResponse(PS_PasswordResponse x, PS_InStream stream);
void Decode_ConferenceIDResponse(PS_ConferenceIDResponse x, PS_InStream stream);
void Decode_TerminalIDResponse(PS_TerminalIDResponse x, PS_InStream stream);
void Decode_MCTerminalIDResponse(PS_MCTerminalIDResponse x, PS_InStream stream);
void Decode_RequestAllTerminalIDsResponse(PS_RequestAllTerminalIDsResponse x, PS_InStream stream);
void Decode_TerminalInformation(PS_TerminalInformation x, PS_InStream stream);
void Decode_RemoteMCRequest(PS_RemoteMCRequest x, PS_InStream stream);
void Decode_RemoteMCResponse(PS_RemoteMCResponse x, PS_InStream stream);
void Decode_Reject(PS_Reject x, PS_InStream stream);
void Decode_MultilinkRequest(PS_MultilinkRequest x, PS_InStream stream);
void Decode_MaximumHeaderInterval(PS_MaximumHeaderInterval x, PS_InStream stream);
void Decode_RequestType(PS_RequestType x, PS_InStream stream);
void Decode_RemoveConnection(PS_RemoveConnection x, PS_InStream stream);
void Decode_AddConnection(PS_AddConnection x, PS_InStream stream);
void Decode_CallInformation(PS_CallInformation x, PS_InStream stream);
void Decode_MultilinkResponse(PS_MultilinkResponse x, PS_InStream stream);
void Decode_RespMaximumHeaderInterval(PS_RespMaximumHeaderInterval x, PS_InStream stream);
void Decode_RespRemoveConnection(PS_RespRemoveConnection x, PS_InStream stream);
void Decode_RespAddConnection(PS_RespAddConnection x, PS_InStream stream);
void Decode_ResponseCode(PS_ResponseCode x, PS_InStream stream);
void Decode_Rejected(PS_Rejected x, PS_InStream stream);
void Decode_RespCallInformation(PS_RespCallInformation x, PS_InStream stream);
void Decode_MultilinkIndication(PS_MultilinkIndication x, PS_InStream stream);
void Decode_ExcessiveError(PS_ExcessiveError x, PS_InStream stream);
void Decode_CrcDesired(PS_CrcDesired x, PS_InStream stream);
void Decode_DialingInformation(PS_DialingInformation x, PS_InStream stream);
void Decode_DialingInformationNumber(PS_DialingInformationNumber x, PS_InStream stream);
void Decode_DialingInformationNetworkType(PS_DialingInformationNetworkType x, PS_InStream stream);
void Decode_ConnectionIdentifier(PS_ConnectionIdentifier x, PS_InStream stream);
void Decode_LogicalChannelRateRequest(PS_LogicalChannelRateRequest x, PS_InStream stream);
void Decode_LogicalChannelRateAcknowledge(PS_LogicalChannelRateAcknowledge x, PS_InStream stream);
void Decode_LogicalChannelRateReject(PS_LogicalChannelRateReject x, PS_InStream stream);
void Decode_LogicalChannelRateRejectReason(PS_LogicalChannelRateRejectReason x, PS_InStream stream);
void Decode_LogicalChannelRateRelease(PS_LogicalChannelRateRelease x, PS_InStream stream);
void Decode_SendTerminalCapabilitySet(PS_SendTerminalCapabilitySet x, PS_InStream stream);
void Decode_SpecificRequest(PS_SpecificRequest x, PS_InStream stream);
void Decode_EncryptionCommand(PS_EncryptionCommand x, PS_InStream stream);
void Decode_EncryptionAlgorithmID(PS_EncryptionAlgorithmID x, PS_InStream stream);
void Decode_FlowControlCommand(PS_FlowControlCommand x, PS_InStream stream);
void Decode_FccRestriction(PS_FccRestriction x, PS_InStream stream);
void Decode_FccScope(PS_FccScope x, PS_InStream stream);
void Decode_EndSessionCommand(PS_EndSessionCommand x, PS_InStream stream);
void Decode_IsdnOptions(PS_IsdnOptions x, PS_InStream stream);
void Decode_GstnOptions(PS_GstnOptions x, PS_InStream stream);
void Decode_ConferenceCommand(PS_ConferenceCommand x, PS_InStream stream);
void Decode_SubstituteConferenceIDCommand(PS_SubstituteConferenceIDCommand x, PS_InStream stream);
void Decode_MiscellaneousCommand(PS_MiscellaneousCommand x, PS_InStream stream);
void Decode_McType(PS_McType x, PS_InStream stream);
void Decode_ProgressiveRefinementStart(PS_ProgressiveRefinementStart x, PS_InStream stream);
void Decode_PrsRepeatCount(PS_PrsRepeatCount x, PS_InStream stream);
void Decode_VideoFastUpdateMB(PS_VideoFastUpdateMB x, PS_InStream stream);
void Decode_VideoFastUpdateGOB(PS_VideoFastUpdateGOB x, PS_InStream stream);
void Decode_KeyProtectionMethod(PS_KeyProtectionMethod x, PS_InStream stream);
void Decode_EncryptionUpdateRequest(PS_EncryptionUpdateRequest x, PS_InStream stream);
void Decode_H223MultiplexReconfiguration(PS_H223MultiplexReconfiguration x, PS_InStream stream);
void Decode_H223AnnexADoubleFlag(PS_H223AnnexADoubleFlag x, PS_InStream stream);
void Decode_H223ModeChange(PS_H223ModeChange x, PS_InStream stream);
void Decode_NewATMVCCommand(PS_NewATMVCCommand x, PS_InStream stream);
void Decode_CmdReverseParameters(PS_CmdReverseParameters x, PS_InStream stream);
void Decode_Multiplex(PS_Multiplex x, PS_InStream stream);
void Decode_CmdMultiplex(PS_CmdMultiplex x, PS_InStream stream);
void Decode_CmdAal(PS_CmdAal x, PS_InStream stream);
void Decode_CmdAal5(PS_CmdAal5 x, PS_InStream stream);
void Decode_CmdAal1(PS_CmdAal1 x, PS_InStream stream);
void Decode_CmdErrorCorrection(PS_CmdErrorCorrection x, PS_InStream stream);
void Decode_CmdClockRecovery(PS_CmdClockRecovery x, PS_InStream stream);
void Decode_FunctionNotUnderstood(PS_FunctionNotUnderstood x, PS_InStream stream);
void Decode_FunctionNotSupported(PS_FunctionNotSupported x, PS_InStream stream);
void Decode_FnsCause(PS_FnsCause x, PS_InStream stream);
void Decode_ConferenceIndication(PS_ConferenceIndication x, PS_InStream stream);
void Decode_TerminalYouAreSeeingInSubPictureNumber(PS_TerminalYouAreSeeingInSubPictureNumber x, PS_InStream stream);
void Decode_VideoIndicateCompose(PS_VideoIndicateCompose x, PS_InStream stream);
void Decode_MiscellaneousIndication(PS_MiscellaneousIndication x, PS_InStream stream);
void Decode_MiType(PS_MiType x, PS_InStream stream);
void Decode_VideoNotDecodedMBs(PS_VideoNotDecodedMBs x, PS_InStream stream);
void Decode_JitterIndication(PS_JitterIndication x, PS_InStream stream);
void Decode_JiScope(PS_JiScope x, PS_InStream stream);
void Decode_H223SkewIndication(PS_H223SkewIndication x, PS_InStream stream);
void Decode_H2250MaximumSkewIndication(PS_H2250MaximumSkewIndication x, PS_InStream stream);
void Decode_MCLocationIndication(PS_MCLocationIndication x, PS_InStream stream);
void Decode_VendorIdentification(PS_VendorIdentification x, PS_InStream stream);
void Decode_NewATMVCIndication(PS_NewATMVCIndication x, PS_InStream stream);
void Decode_IndReverseParameters(PS_IndReverseParameters x, PS_InStream stream);
void Decode_IrpMultiplex(PS_IrpMultiplex x, PS_InStream stream);
void Decode_IndMultiplex(PS_IndMultiplex x, PS_InStream stream);
void Decode_IndAal(PS_IndAal x, PS_InStream stream);
void Decode_IndAal5(PS_IndAal5 x, PS_InStream stream);
void Decode_IndAal1(PS_IndAal1 x, PS_InStream stream);
void Decode_IndErrorCorrection(PS_IndErrorCorrection x, PS_InStream stream);
void Decode_IndClockRecovery(PS_IndClockRecovery x, PS_InStream stream);
void Decode_UserInputIndication(PS_UserInputIndication x, PS_InStream stream);
void Decode_SignalUpdate(PS_SignalUpdate x, PS_InStream stream);
void Decode_Rtp(PS_Rtp x, PS_InStream stream);
void Decode_Signal(PS_Signal x, PS_InStream stream);
void Decode_SignalRtp(PS_SignalRtp x, PS_InStream stream);
void Decode_UserInputSupportIndication(PS_UserInputSupportIndication x, PS_InStream stream);
void Decode_FlowControlIndication(PS_FlowControlIndication x, PS_InStream stream);
void Decode_FciRestriction(PS_FciRestriction x, PS_InStream stream);
void Decode_FciScope(PS_FciScope x, PS_InStream stream);

#endif
