/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
// ============================================================(Auto)=
// FILE: h245_analysis.h
//
// DESC: PER Analyzer routines for H.245
// -------------------------------------------------------------------
//  Copyright (c) 1998- 2000, PacketVideo Corporation.
//                   All Rights Reserved.
// ===================================================================

#ifndef PER_ANALYZER
#define PER_ANALYZER

void Analyze_MultimediaSystemControlMessage(PS_MultimediaSystemControlMessage x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestMessage(PS_RequestMessage x, const char* label, uint16 tag, uint16 indent);
void Analyze_ResponseMessage(PS_ResponseMessage x, const char* label, uint16 tag, uint16 indent);
void Analyze_CommandMessage(PS_CommandMessage x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndicationMessage(PS_IndicationMessage x, const char* label, uint16 tag, uint16 indent);
void Analyze_NonStandardMessage(PS_NonStandardMessage x, const char* label, uint16 tag, uint16 indent);
void Analyze_NonStandardParameter(PS_NonStandardParameter x, const char* label, uint16 tag, uint16 indent);
void Analyze_NonStandardIdentifier(PS_NonStandardIdentifier x, const char* label, uint16 tag, uint16 indent);
void Analyze_H221NonStandard(PS_H221NonStandard x, const char* label, uint16 tag, uint16 indent);
void Analyze_MasterSlaveDetermination(PS_MasterSlaveDetermination x, const char* label, uint16 tag, uint16 indent);
void Analyze_MasterSlaveDeterminationAck(PS_MasterSlaveDeterminationAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_Decision(PS_Decision x, const char* label, uint16 tag, uint16 indent);
void Analyze_MasterSlaveDeterminationReject(PS_MasterSlaveDeterminationReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_MsdRejectCause(PS_MsdRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_MasterSlaveDeterminationRelease(PS_MasterSlaveDeterminationRelease x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalCapabilitySet(PS_TerminalCapabilitySet x, const char* label, uint16 tag, uint16 indent);
void Analyze_CapabilityTableEntry(PS_CapabilityTableEntry x, const char* label, uint16 tag, uint16 indent);
void Analyze_CapabilityDescriptor(PS_CapabilityDescriptor x, const char* label, uint16 tag, uint16 indent);
void Analyze_AlternativeCapabilitySet(PS_AlternativeCapabilitySet x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalCapabilitySetAck(PS_TerminalCapabilitySetAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalCapabilitySetReject(PS_TerminalCapabilitySetReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_TcsRejectCause(PS_TcsRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_TableEntryCapacityExceeded(PS_TableEntryCapacityExceeded x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalCapabilitySetRelease(PS_TerminalCapabilitySetRelease x, const char* label, uint16 tag, uint16 indent);
void Analyze_Capability(PS_Capability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H233EncryptionReceiveCapability(PS_H233EncryptionReceiveCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H235SecurityCapability(PS_H235SecurityCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexCapability(PS_MultiplexCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H222Capability(PS_H222Capability x, const char* label, uint16 tag, uint16 indent);
void Analyze_VCCapability(PS_VCCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_Aal1ViaGateway(PS_Aal1ViaGateway x, const char* label, uint16 tag, uint16 indent);
void Analyze_AvailableBitRates(PS_AvailableBitRates x, const char* label, uint16 tag, uint16 indent);
void Analyze_VccAal5Type(PS_VccAal5Type x, const char* label, uint16 tag, uint16 indent);
void Analyze_RangeOfBitRates(PS_RangeOfBitRates x, const char* label, uint16 tag, uint16 indent);
void Analyze_VccAal5(PS_VccAal5 x, const char* label, uint16 tag, uint16 indent);
void Analyze_VccAal1(PS_VccAal1 x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223Capability(PS_H223Capability x, const char* label, uint16 tag, uint16 indent);
void Analyze_MobileOperationTransmitCapability(PS_MobileOperationTransmitCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223MultiplexTableCapability(PS_H223MultiplexTableCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_Enhanced(PS_Enhanced x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223AnnexCCapability(PS_H223AnnexCCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_V76Capability(PS_V76Capability x, const char* label, uint16 tag, uint16 indent);
void Analyze_V75Capability(PS_V75Capability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H2250Capability(PS_H2250Capability x, const char* label, uint16 tag, uint16 indent);
void Analyze_McCapability(PS_McCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaPacketizationCapability(PS_MediaPacketizationCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_RSVPParameters(PS_RSVPParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_QOSMode(PS_QOSMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_ATMParameters(PS_ATMParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_QOSCapability(PS_QOSCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaTransportType(PS_MediaTransportType x, const char* label, uint16 tag, uint16 indent);
void Analyze_Atm_AAL5_compressed(PS_Atm_AAL5_compressed x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaChannelCapability(PS_MediaChannelCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_TransportCapability(PS_TransportCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_RedundancyEncodingCapability(PS_RedundancyEncodingCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_RedundancyEncodingMethod(PS_RedundancyEncodingMethod x, const char* label, uint16 tag, uint16 indent);
void Analyze_RTPH263VideoRedundancyEncoding(PS_RTPH263VideoRedundancyEncoding x, const char* label, uint16 tag, uint16 indent);
void Analyze_FrameToThreadMapping(PS_FrameToThreadMapping x, const char* label, uint16 tag, uint16 indent);
void Analyze_RTPH263VideoRedundancyFrameMapping(PS_RTPH263VideoRedundancyFrameMapping x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultipointCapability(PS_MultipointCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaDistributionCapability(PS_MediaDistributionCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_VideoCapability(PS_VideoCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H261VideoCapability(PS_H261VideoCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H262VideoCapability(PS_H262VideoCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_H263VideoCapability(PS_H263VideoCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_EnhancementLayerInfo(PS_EnhancementLayerInfo x, const char* label, uint16 tag, uint16 indent);
void Analyze_BEnhancementParameters(PS_BEnhancementParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_EnhancementOptions(PS_EnhancementOptions x, const char* label, uint16 tag, uint16 indent);
void Analyze_H263Options(PS_H263Options x, const char* label, uint16 tag, uint16 indent);
void Analyze_TransparencyParameters(PS_TransparencyParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_RefPictureSelection(PS_RefPictureSelection x, const char* label, uint16 tag, uint16 indent);
void Analyze_VideoBackChannelSend(PS_VideoBackChannelSend x, const char* label, uint16 tag, uint16 indent);
void Analyze_AdditionalPictureMemory(PS_AdditionalPictureMemory x, const char* label, uint16 tag, uint16 indent);
void Analyze_CustomPictureClockFrequency(PS_CustomPictureClockFrequency x, const char* label, uint16 tag, uint16 indent);
void Analyze_CustomPictureFormat(PS_CustomPictureFormat x, const char* label, uint16 tag, uint16 indent);
void Analyze_PixelAspectInformation(PS_PixelAspectInformation x, const char* label, uint16 tag, uint16 indent);
void Analyze_ExtendedPARItem(PS_ExtendedPARItem x, const char* label, uint16 tag, uint16 indent);
void Analyze_MPI(PS_MPI x, const char* label, uint16 tag, uint16 indent);
void Analyze_CustomPCFItem(PS_CustomPCFItem x, const char* label, uint16 tag, uint16 indent);
void Analyze_H263VideoModeCombos(PS_H263VideoModeCombos x, const char* label, uint16 tag, uint16 indent);
void Analyze_H263ModeComboFlags(PS_H263ModeComboFlags x, const char* label, uint16 tag, uint16 indent);
void Analyze_IS11172VideoCapability(PS_IS11172VideoCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_AudioCapability(PS_AudioCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_G7231(PS_G7231 x, const char* label, uint16 tag, uint16 indent);
void Analyze_G729Extensions(PS_G729Extensions x, const char* label, uint16 tag, uint16 indent);
void Analyze_G7231AnnexCCapability(PS_G7231AnnexCCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_G723AnnexCAudioMode(PS_G723AnnexCAudioMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_IS11172AudioCapability(PS_IS11172AudioCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_IS13818AudioCapability(PS_IS13818AudioCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_GSMAudioCapability(PS_GSMAudioCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_DataApplicationCapability(PS_DataApplicationCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_Application(PS_Application x, const char* label, uint16 tag, uint16 indent);
void Analyze_T38fax(PS_T38fax x, const char* label, uint16 tag, uint16 indent);
void Analyze_Nlpid(PS_Nlpid x, const char* label, uint16 tag, uint16 indent);
void Analyze_T84(PS_T84 x, const char* label, uint16 tag, uint16 indent);
void Analyze_DataProtocolCapability(PS_DataProtocolCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_V76wCompression(PS_V76wCompression x, const char* label, uint16 tag, uint16 indent);
void Analyze_CompressionType(PS_CompressionType x, const char* label, uint16 tag, uint16 indent);
void Analyze_V42bis(PS_V42bis x, const char* label, uint16 tag, uint16 indent);
void Analyze_T84Profile(PS_T84Profile x, const char* label, uint16 tag, uint16 indent);
void Analyze_T84Restricted(PS_T84Restricted x, const char* label, uint16 tag, uint16 indent);
void Analyze_T38FaxProfile(PS_T38FaxProfile x, const char* label, uint16 tag, uint16 indent);
void Analyze_T38FaxRateManagement(PS_T38FaxRateManagement x, const char* label, uint16 tag, uint16 indent);
void Analyze_T38FaxUdpOptions(PS_T38FaxUdpOptions x, const char* label, uint16 tag, uint16 indent);
void Analyze_T38FaxUdpEC(PS_T38FaxUdpEC x, const char* label, uint16 tag, uint16 indent);
void Analyze_EncryptionAuthenticationAndIntegrity(PS_EncryptionAuthenticationAndIntegrity x, const char* label, uint16 tag, uint16 indent);
void Analyze_EncryptionCapability(PS_EncryptionCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaEncryptionAlgorithm(PS_MediaEncryptionAlgorithm x, const char* label, uint16 tag, uint16 indent);
void Analyze_AuthenticationCapability(PS_AuthenticationCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_IntegrityCapability(PS_IntegrityCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_UserInputCapability(PS_UserInputCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_ConferenceCapability(PS_ConferenceCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_GenericCapability(PS_GenericCapability x, const char* label, uint16 tag, uint16 indent);
void Analyze_CapabilityIdentifier(PS_CapabilityIdentifier x, const char* label, uint16 tag, uint16 indent);
void Analyze_GenericParameter(PS_GenericParameter x, const char* label, uint16 tag, uint16 indent);
void Analyze_ParameterIdentifier(PS_ParameterIdentifier x, const char* label, uint16 tag, uint16 indent);
void Analyze_ParameterValue(PS_ParameterValue x, const char* label, uint16 tag, uint16 indent);
void Analyze_OpenLogicalChannel(PS_OpenLogicalChannel x, const char* label, uint16 tag, uint16 indent);
void Analyze_ReverseLogicalChannelParameters(PS_ReverseLogicalChannelParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_RlcMultiplexParameters(PS_RlcMultiplexParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_ForwardLogicalChannelParameters(PS_ForwardLogicalChannelParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexParameters(PS_MultiplexParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_NetworkAccessParameters(PS_NetworkAccessParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_T120SetupProcedure(PS_T120SetupProcedure x, const char* label, uint16 tag, uint16 indent);
void Analyze_NetworkAddress(PS_NetworkAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_Distribution(PS_Distribution x, const char* label, uint16 tag, uint16 indent);
void Analyze_Q2931Address(PS_Q2931Address x, const char* label, uint16 tag, uint16 indent);
void Analyze_Address(PS_Address x, const char* label, uint16 tag, uint16 indent);
void Analyze_V75Parameters(PS_V75Parameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_DataType(PS_DataType x, const char* label, uint16 tag, uint16 indent);
void Analyze_H235Media(PS_H235Media x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaType(PS_MediaType x, const char* label, uint16 tag, uint16 indent);
void Analyze_H222LogicalChannelParameters(PS_H222LogicalChannelParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223LogicalChannelParameters(PS_H223LogicalChannelParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_AdaptationLayerType(PS_AdaptationLayerType x, const char* label, uint16 tag, uint16 indent);
void Analyze_Al3(PS_Al3 x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223AL1MParameters(PS_H223AL1MParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_ArqType(PS_ArqType x, const char* label, uint16 tag, uint16 indent);
void Analyze_CrcLength(PS_CrcLength x, const char* label, uint16 tag, uint16 indent);
void Analyze_HeaderFEC(PS_HeaderFEC x, const char* label, uint16 tag, uint16 indent);
void Analyze_TransferMode(PS_TransferMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223AL2MParameters(PS_H223AL2MParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_Al2HeaderFEC(PS_Al2HeaderFEC x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223AL3MParameters(PS_H223AL3MParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_Al3ArqType(PS_Al3ArqType x, const char* label, uint16 tag, uint16 indent);
void Analyze_Al3CrcLength(PS_Al3CrcLength x, const char* label, uint16 tag, uint16 indent);
void Analyze_HeaderFormat(PS_HeaderFormat x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223AnnexCArqParameters(PS_H223AnnexCArqParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_NumberOfRetransmissions(PS_NumberOfRetransmissions x, const char* label, uint16 tag, uint16 indent);
void Analyze_V76LogicalChannelParameters(PS_V76LogicalChannelParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_Mode(PS_Mode x, const char* label, uint16 tag, uint16 indent);
void Analyze_ERM(PS_ERM x, const char* label, uint16 tag, uint16 indent);
void Analyze_Recovery(PS_Recovery x, const char* label, uint16 tag, uint16 indent);
void Analyze_SuspendResume(PS_SuspendResume x, const char* label, uint16 tag, uint16 indent);
void Analyze_V76HDLCParameters(PS_V76HDLCParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_CRCLength(PS_CRCLength x, const char* label, uint16 tag, uint16 indent);
void Analyze_H2250LogicalChannelParameters(PS_H2250LogicalChannelParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaPacketization(PS_MediaPacketization x, const char* label, uint16 tag, uint16 indent);
void Analyze_RTPPayloadType(PS_RTPPayloadType x, const char* label, uint16 tag, uint16 indent);
void Analyze_PayloadDescriptor(PS_PayloadDescriptor x, const char* label, uint16 tag, uint16 indent);
void Analyze_RedundancyEncoding(PS_RedundancyEncoding x, const char* label, uint16 tag, uint16 indent);
void Analyze_TransportAddress(PS_TransportAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_UnicastAddress(PS_UnicastAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_IPSourceRouteAddress(PS_IPSourceRouteAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_Routing(PS_Routing x, const char* label, uint16 tag, uint16 indent);
void Analyze_IP6Address(PS_IP6Address x, const char* label, uint16 tag, uint16 indent);
void Analyze_IPXAddress(PS_IPXAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_IPAddress(PS_IPAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_MulticastAddress(PS_MulticastAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_MaIp6Address(PS_MaIp6Address x, const char* label, uint16 tag, uint16 indent);
void Analyze_MaIpAddress(PS_MaIpAddress x, const char* label, uint16 tag, uint16 indent);
void Analyze_EncryptionSync(PS_EncryptionSync x, const char* label, uint16 tag, uint16 indent);
void Analyze_EscrowData(PS_EscrowData x, const char* label, uint16 tag, uint16 indent);
void Analyze_OpenLogicalChannelAck(PS_OpenLogicalChannelAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_ForwardMultiplexAckParameters(PS_ForwardMultiplexAckParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_AckReverseLogicalChannelParameters(PS_AckReverseLogicalChannelParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_AckMultiplexParameters(PS_AckMultiplexParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_OpenLogicalChannelReject(PS_OpenLogicalChannelReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_OlcRejectCause(PS_OlcRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_OpenLogicalChannelConfirm(PS_OpenLogicalChannelConfirm x, const char* label, uint16 tag, uint16 indent);
void Analyze_H2250LogicalChannelAckParameters(PS_H2250LogicalChannelAckParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_CloseLogicalChannel(PS_CloseLogicalChannel x, const char* label, uint16 tag, uint16 indent);
void Analyze_Reason(PS_Reason x, const char* label, uint16 tag, uint16 indent);
void Analyze_Source(PS_Source x, const char* label, uint16 tag, uint16 indent);
void Analyze_CloseLogicalChannelAck(PS_CloseLogicalChannelAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestChannelClose(PS_RequestChannelClose x, const char* label, uint16 tag, uint16 indent);
void Analyze_RccReason(PS_RccReason x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestChannelCloseAck(PS_RequestChannelCloseAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestChannelCloseReject(PS_RequestChannelCloseReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_RccRejectCause(PS_RccRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestChannelCloseRelease(PS_RequestChannelCloseRelease x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexEntrySend(PS_MultiplexEntrySend x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexEntryDescriptor(PS_MultiplexEntryDescriptor x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexElement(PS_MultiplexElement x, const char* label, uint16 tag, uint16 indent);
void Analyze_RepeatCount(PS_RepeatCount x, const char* label, uint16 tag, uint16 indent);
void Analyze_MuxType(PS_MuxType x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexEntrySendAck(PS_MultiplexEntrySendAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexEntrySendReject(PS_MultiplexEntrySendReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexEntryRejectionDescriptions(PS_MultiplexEntryRejectionDescriptions x, const char* label, uint16 tag, uint16 indent);
void Analyze_MeRejectCause(PS_MeRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultiplexEntrySendRelease(PS_MultiplexEntrySendRelease x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestMultiplexEntry(PS_RequestMultiplexEntry x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestMultiplexEntryAck(PS_RequestMultiplexEntryAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestMultiplexEntryReject(PS_RequestMultiplexEntryReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestMultiplexEntryRejectionDescriptions(PS_RequestMultiplexEntryRejectionDescriptions x, const char* label, uint16 tag, uint16 indent);
void Analyze_RmeRejectCause(PS_RmeRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestMultiplexEntryRelease(PS_RequestMultiplexEntryRelease x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestMode(PS_RequestMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestModeAck(PS_RequestModeAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_Response(PS_Response x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestModeReject(PS_RequestModeReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_RmRejectCause(PS_RmRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestModeRelease(PS_RequestModeRelease x, const char* label, uint16 tag, uint16 indent);
void Analyze_ModeDescription(PS_ModeDescription x, const char* label, uint16 tag, uint16 indent);
void Analyze_ModeElement(PS_ModeElement x, const char* label, uint16 tag, uint16 indent);
void Analyze_ModeType(PS_ModeType x, const char* label, uint16 tag, uint16 indent);
void Analyze_H235Mode(PS_H235Mode x, const char* label, uint16 tag, uint16 indent);
void Analyze_MediaMode(PS_MediaMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223ModeParameters(PS_H223ModeParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_ModeAdaptationLayerType(PS_ModeAdaptationLayerType x, const char* label, uint16 tag, uint16 indent);
void Analyze_ModeAl3(PS_ModeAl3 x, const char* label, uint16 tag, uint16 indent);
void Analyze_V76ModeParameters(PS_V76ModeParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_H2250ModeParameters(PS_H2250ModeParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_RedundancyEncodingMode(PS_RedundancyEncodingMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_SecondaryEncoding(PS_SecondaryEncoding x, const char* label, uint16 tag, uint16 indent);
void Analyze_VideoMode(PS_VideoMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_H261VideoMode(PS_H261VideoMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_Resolution(PS_Resolution x, const char* label, uint16 tag, uint16 indent);
void Analyze_H262VideoMode(PS_H262VideoMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_ProfileAndLevel(PS_ProfileAndLevel x, const char* label, uint16 tag, uint16 indent);
void Analyze_H263VideoMode(PS_H263VideoMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_H263Resolution(PS_H263Resolution x, const char* label, uint16 tag, uint16 indent);
void Analyze_IS11172VideoMode(PS_IS11172VideoMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_AudioMode(PS_AudioMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_ModeG7231(PS_ModeG7231 x, const char* label, uint16 tag, uint16 indent);
void Analyze_IS11172AudioMode(PS_IS11172AudioMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultichannelType(PS_MultichannelType x, const char* label, uint16 tag, uint16 indent);
void Analyze_AudioSampling(PS_AudioSampling x, const char* label, uint16 tag, uint16 indent);
void Analyze_AudioLayer(PS_AudioLayer x, const char* label, uint16 tag, uint16 indent);
void Analyze_IS13818AudioMode(PS_IS13818AudioMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_Is13818MultichannelType(PS_Is13818MultichannelType x, const char* label, uint16 tag, uint16 indent);
void Analyze_Is13818AudioSampling(PS_Is13818AudioSampling x, const char* label, uint16 tag, uint16 indent);
void Analyze_Is13818AudioLayer(PS_Is13818AudioLayer x, const char* label, uint16 tag, uint16 indent);
void Analyze_G7231AnnexCMode(PS_G7231AnnexCMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_ModeG723AnnexCAudioMode(PS_ModeG723AnnexCAudioMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_DataMode(PS_DataMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_DmApplication(PS_DmApplication x, const char* label, uint16 tag, uint16 indent);
void Analyze_DmT38fax(PS_DmT38fax x, const char* label, uint16 tag, uint16 indent);
void Analyze_DmNlpid(PS_DmNlpid x, const char* label, uint16 tag, uint16 indent);
void Analyze_EncryptionMode(PS_EncryptionMode x, const char* label, uint16 tag, uint16 indent);
void Analyze_RoundTripDelayRequest(PS_RoundTripDelayRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_RoundTripDelayResponse(PS_RoundTripDelayResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_MaintenanceLoopRequest(PS_MaintenanceLoopRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_MlRequestType(PS_MlRequestType x, const char* label, uint16 tag, uint16 indent);
void Analyze_MaintenanceLoopAck(PS_MaintenanceLoopAck x, const char* label, uint16 tag, uint16 indent);
void Analyze_MlAckType(PS_MlAckType x, const char* label, uint16 tag, uint16 indent);
void Analyze_MaintenanceLoopReject(PS_MaintenanceLoopReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_MlRejectCause(PS_MlRejectCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_MlRejectType(PS_MlRejectType x, const char* label, uint16 tag, uint16 indent);
void Analyze_MaintenanceLoopOffCommand(PS_MaintenanceLoopOffCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_CommunicationModeCommand(PS_CommunicationModeCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_CommunicationModeRequest(PS_CommunicationModeRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_CommunicationModeResponse(PS_CommunicationModeResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_CommunicationModeTableEntry(PS_CommunicationModeTableEntry x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmtDataType(PS_CmtDataType x, const char* label, uint16 tag, uint16 indent);
void Analyze_ConferenceRequest(PS_ConferenceRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestTerminalCertificate(PS_RequestTerminalCertificate x, const char* label, uint16 tag, uint16 indent);
void Analyze_CertSelectionCriteria(PS_CertSelectionCriteria x, const char* label, uint16 tag, uint16 indent);
void Analyze_Criteria(PS_Criteria x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalLabel(PS_TerminalLabel x, const char* label, uint16 tag, uint16 indent);
void Analyze_ConferenceResponse(PS_ConferenceResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_SendThisSourceResponse(PS_SendThisSourceResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_MakeTerminalBroadcasterResponse(PS_MakeTerminalBroadcasterResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_BroadcastMyLogicalChannelResponse(PS_BroadcastMyLogicalChannelResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalCertificateResponse(PS_TerminalCertificateResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_ChairTokenOwnerResponse(PS_ChairTokenOwnerResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_ExtensionAddressResponse(PS_ExtensionAddressResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_MakeMeChairResponse(PS_MakeMeChairResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_PasswordResponse(PS_PasswordResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_ConferenceIDResponse(PS_ConferenceIDResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalIDResponse(PS_TerminalIDResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_MCTerminalIDResponse(PS_MCTerminalIDResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestAllTerminalIDsResponse(PS_RequestAllTerminalIDsResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalInformation(PS_TerminalInformation x, const char* label, uint16 tag, uint16 indent);
void Analyze_RemoteMCRequest(PS_RemoteMCRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_RemoteMCResponse(PS_RemoteMCResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_Reject(PS_Reject x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultilinkRequest(PS_MultilinkRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_MaximumHeaderInterval(PS_MaximumHeaderInterval x, const char* label, uint16 tag, uint16 indent);
void Analyze_RequestType(PS_RequestType x, const char* label, uint16 tag, uint16 indent);
void Analyze_RemoveConnection(PS_RemoveConnection x, const char* label, uint16 tag, uint16 indent);
void Analyze_AddConnection(PS_AddConnection x, const char* label, uint16 tag, uint16 indent);
void Analyze_CallInformation(PS_CallInformation x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultilinkResponse(PS_MultilinkResponse x, const char* label, uint16 tag, uint16 indent);
void Analyze_RespMaximumHeaderInterval(PS_RespMaximumHeaderInterval x, const char* label, uint16 tag, uint16 indent);
void Analyze_RespRemoveConnection(PS_RespRemoveConnection x, const char* label, uint16 tag, uint16 indent);
void Analyze_RespAddConnection(PS_RespAddConnection x, const char* label, uint16 tag, uint16 indent);
void Analyze_ResponseCode(PS_ResponseCode x, const char* label, uint16 tag, uint16 indent);
void Analyze_Rejected(PS_Rejected x, const char* label, uint16 tag, uint16 indent);
void Analyze_RespCallInformation(PS_RespCallInformation x, const char* label, uint16 tag, uint16 indent);
void Analyze_MultilinkIndication(PS_MultilinkIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_ExcessiveError(PS_ExcessiveError x, const char* label, uint16 tag, uint16 indent);
void Analyze_CrcDesired(PS_CrcDesired x, const char* label, uint16 tag, uint16 indent);
void Analyze_DialingInformation(PS_DialingInformation x, const char* label, uint16 tag, uint16 indent);
void Analyze_DialingInformationNumber(PS_DialingInformationNumber x, const char* label, uint16 tag, uint16 indent);
void Analyze_DialingInformationNetworkType(PS_DialingInformationNetworkType x, const char* label, uint16 tag, uint16 indent);
void Analyze_ConnectionIdentifier(PS_ConnectionIdentifier x, const char* label, uint16 tag, uint16 indent);
void Analyze_LogicalChannelRateRequest(PS_LogicalChannelRateRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_LogicalChannelRateAcknowledge(PS_LogicalChannelRateAcknowledge x, const char* label, uint16 tag, uint16 indent);
void Analyze_LogicalChannelRateReject(PS_LogicalChannelRateReject x, const char* label, uint16 tag, uint16 indent);
void Analyze_LogicalChannelRateRejectReason(PS_LogicalChannelRateRejectReason x, const char* label, uint16 tag, uint16 indent);
void Analyze_LogicalChannelRateRelease(PS_LogicalChannelRateRelease x, const char* label, uint16 tag, uint16 indent);
void Analyze_SendTerminalCapabilitySet(PS_SendTerminalCapabilitySet x, const char* label, uint16 tag, uint16 indent);
void Analyze_SpecificRequest(PS_SpecificRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_EncryptionCommand(PS_EncryptionCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_EncryptionAlgorithmID(PS_EncryptionAlgorithmID x, const char* label, uint16 tag, uint16 indent);
void Analyze_FlowControlCommand(PS_FlowControlCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_FccRestriction(PS_FccRestriction x, const char* label, uint16 tag, uint16 indent);
void Analyze_FccScope(PS_FccScope x, const char* label, uint16 tag, uint16 indent);
void Analyze_EndSessionCommand(PS_EndSessionCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_IsdnOptions(PS_IsdnOptions x, const char* label, uint16 tag, uint16 indent);
void Analyze_GstnOptions(PS_GstnOptions x, const char* label, uint16 tag, uint16 indent);
void Analyze_ConferenceCommand(PS_ConferenceCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_SubstituteConferenceIDCommand(PS_SubstituteConferenceIDCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_MiscellaneousCommand(PS_MiscellaneousCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_McType(PS_McType x, const char* label, uint16 tag, uint16 indent);
void Analyze_ProgressiveRefinementStart(PS_ProgressiveRefinementStart x, const char* label, uint16 tag, uint16 indent);
void Analyze_PrsRepeatCount(PS_PrsRepeatCount x, const char* label, uint16 tag, uint16 indent);
void Analyze_VideoFastUpdateMB(PS_VideoFastUpdateMB x, const char* label, uint16 tag, uint16 indent);
void Analyze_VideoFastUpdateGOB(PS_VideoFastUpdateGOB x, const char* label, uint16 tag, uint16 indent);
void Analyze_KeyProtectionMethod(PS_KeyProtectionMethod x, const char* label, uint16 tag, uint16 indent);
void Analyze_EncryptionUpdateRequest(PS_EncryptionUpdateRequest x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223MultiplexReconfiguration(PS_H223MultiplexReconfiguration x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223AnnexADoubleFlag(PS_H223AnnexADoubleFlag x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223ModeChange(PS_H223ModeChange x, const char* label, uint16 tag, uint16 indent);
void Analyze_NewATMVCCommand(PS_NewATMVCCommand x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmdReverseParameters(PS_CmdReverseParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_Multiplex(PS_Multiplex x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmdMultiplex(PS_CmdMultiplex x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmdAal(PS_CmdAal x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmdAal5(PS_CmdAal5 x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmdAal1(PS_CmdAal1 x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmdErrorCorrection(PS_CmdErrorCorrection x, const char* label, uint16 tag, uint16 indent);
void Analyze_CmdClockRecovery(PS_CmdClockRecovery x, const char* label, uint16 tag, uint16 indent);
void Analyze_FunctionNotUnderstood(PS_FunctionNotUnderstood x, const char* label, uint16 tag, uint16 indent);
void Analyze_FunctionNotSupported(PS_FunctionNotSupported x, const char* label, uint16 tag, uint16 indent);
void Analyze_FnsCause(PS_FnsCause x, const char* label, uint16 tag, uint16 indent);
void Analyze_ConferenceIndication(PS_ConferenceIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_TerminalYouAreSeeingInSubPictureNumber(PS_TerminalYouAreSeeingInSubPictureNumber x, const char* label, uint16 tag, uint16 indent);
void Analyze_VideoIndicateCompose(PS_VideoIndicateCompose x, const char* label, uint16 tag, uint16 indent);
void Analyze_MiscellaneousIndication(PS_MiscellaneousIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_MiType(PS_MiType x, const char* label, uint16 tag, uint16 indent);
void Analyze_VideoNotDecodedMBs(PS_VideoNotDecodedMBs x, const char* label, uint16 tag, uint16 indent);
void Analyze_JitterIndication(PS_JitterIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_JiScope(PS_JiScope x, const char* label, uint16 tag, uint16 indent);
void Analyze_H223SkewIndication(PS_H223SkewIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_H2250MaximumSkewIndication(PS_H2250MaximumSkewIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_MCLocationIndication(PS_MCLocationIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_VendorIdentification(PS_VendorIdentification x, const char* label, uint16 tag, uint16 indent);
void Analyze_NewATMVCIndication(PS_NewATMVCIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndReverseParameters(PS_IndReverseParameters x, const char* label, uint16 tag, uint16 indent);
void Analyze_IrpMultiplex(PS_IrpMultiplex x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndMultiplex(PS_IndMultiplex x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndAal(PS_IndAal x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndAal5(PS_IndAal5 x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndAal1(PS_IndAal1 x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndErrorCorrection(PS_IndErrorCorrection x, const char* label, uint16 tag, uint16 indent);
void Analyze_IndClockRecovery(PS_IndClockRecovery x, const char* label, uint16 tag, uint16 indent);
void Analyze_UserInputIndication(PS_UserInputIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_SignalUpdate(PS_SignalUpdate x, const char* label, uint16 tag, uint16 indent);
void Analyze_Rtp(PS_Rtp x, const char* label, uint16 tag, uint16 indent);
void Analyze_Signal(PS_Signal x, const char* label, uint16 tag, uint16 indent);
void Analyze_SignalRtp(PS_SignalRtp x, const char* label, uint16 tag, uint16 indent);
void Analyze_UserInputSupportIndication(PS_UserInputSupportIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_FlowControlIndication(PS_FlowControlIndication x, const char* label, uint16 tag, uint16 indent);
void Analyze_FciRestriction(PS_FciRestriction x, const char* label, uint16 tag, uint16 indent);
void Analyze_FciScope(PS_FciScope x, const char* label, uint16 tag, uint16 indent);

#endif
