/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
#ifndef PVMF_JITTER_BUFFER_COMMON_INTERNAL_H
#define PVMF_JITTER_BUFFER_COMMON_INTERNAL_H

//Logging macros
#define PVMF_JB_LOGERROR(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_REL,ipLogger,PVLOGMSG_ERR,m);
#define PVMF_JB_LOGWARNING(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_REL,ipLogger,PVLOGMSG_WARNING,m);
#define PVMF_JB_LOGINFOHI(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG,ipLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGINFOMED(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_MLDBG,ipLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGINFOLOW(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGINFO(m) PVMF_JB_LOGINFOMED(m)
#define PVMF_JB_LOGDATATRAFFIC(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipDataPathLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGDATATRAFFIC_IN(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipDataPathLoggerIn,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGDATATRAFFIC_IN_E(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_REL,ipDataPathLoggerIn,PVLOGMSG_ERR,m);
#define PVMF_JB_LOGDATATRAFFIC_OUT(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipDataPathLoggerOut,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGDATATRAFFIC_OUT_E(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_REL,ipDataPathLoggerOut,PVLOGMSG_ERR,m);
#define PVMF_JB_LOGCLOCK(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipClockLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGMAXRTPTS(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipMaxRTPTsLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGCLOCK_SESSION_DURATION(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_MLDBG,ipClockLoggerSessionDuration,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGCLOCK_REBUFF(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_MLDBG,ipClockLoggerRebuff,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGDIAGNOSTICS(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_PROF,ipDiagnosticsLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGDATATRAFFIC_FLOWCTRL(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipDataPathLoggerFlowCtrl,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGDATATRAFFIC_FLOWCTRL_E(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_REL,ipDataPathLoggerFlowCtrl,PVLOGMSG_ERR,m);
#define PVMF_JB_LOGRTPINFO_I(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipRTPInfoTrackerLogger,PVLOGMSG_ERR,m);


#define PVMF_JB_LOG_RTCP(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipRTCPLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOG_RTCP_ERR(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_REL,ipRTCPLogger,PVLOGMSG_ERR,m);
#define PVMF_JB_LOG_RTCPDATATRAFFIC_IN(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipRTCPDataPathLoggerIn,PVLOGMSG_INFO,m);
#define PVMF_JB_LOG_RTCPDATATRAFFIC_OUT(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipRTCPDataPathLoggerOut,PVLOGMSG_INFO,m);
#define PVMF_JB_LOG_RTCPDATATRAFFIC_IN_E(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG,ipRTCPDataPathLoggerIn,PVLOGMSG_ERR,m);

#define PVMF_JB_LOG_FW(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG,ipDataPathLoggerFireWall,PVLOGMSG_INFO,m);
#define PVMF_JB_LOG_EVENTS_CLOCK(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_MLDBG,ipJBEventsClockLogger ,PVLOGMSG_INFO,m);
#define PVMF_JB_LOG_RTCP_AVSYNC(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_LLDBG,ipRTCPAVSyncLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGCLOCK_SESSION_DURATION(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_MLDBG,ipClockLoggerSessionDuration,PVLOGMSG_INFO,m);
#define PVMF_JB_LOGEVENTNOTIFIER(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_MLDBG,ipLogger,PVLOGMSG_INFO,m);

#define PVMF_JB_LOGBIN(m) PVLOGGER_LOGBIN(PVLOGMSG_INST_LLDBG, ipParsedPayloadLogger, PVLOGMSG_ERR, m);

#define PVMF_JB_LOG_PP_INPUT(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG,ipParserInLogger,PVLOGMSG_INFO,m);
#define PVMF_JB_LOG_PP_OUTPUT(m) PVLOGGER_LOGMSG(PVLOGMSG_INST_HLDBG,ipParserOutLogger,PVLOGMSG_INFO,m);
#if (PVLOGGER_INST_LEVEL > PVLOGMSG_INST_LLDBG)
#define LOGCLIENTANDESTIMATEDSERVCLK_DATAPATH LogClientAndEstimatedServerClock(ipDataPathLoggerIn)
#define LOGCLIENTANDESTIMATEDSERVCLK_DATAPATH_OUT LogClientAndEstimatedServerClock(ipDataPathLoggerOut)
#define LOGCLIENTANDESTIMATEDSERVCLK_REBUFF LogClientAndEstimatedServerClock(ipClockLoggerRebuff)
#else
#define LOGCLIENTANDESTIMATEDSERVCLK_DATAPATH
#define LOGCLIENTANDESTIMATEDSERVCLK_REBUFF
#define LOGCLIENTANDESTIMATEDSERVCLK_DATAPATH_OUT
#endif

#endif
