/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BasicRuntimeConfig.java,v 1.6 2007/03/05 14:50:48 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Properties;

import org.logical_paradox.petitbasic.fs.PetitBasicFileSystem;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.mathpack.Mathpack;

/**
 * BASICsnRtBOD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class BasicRuntimeConfig {
	/** vpeBL[ - fobO[h */
	public static final String PKEY_DEBUG = "debug";
	/** vpeBL[ - _̕\` */
	public static final String PKEY_REGEXP = "regexp";
	/** vpeBL[ - ftHg̕ϐ^ */
	public static final String PKEY_VARTYPE = "variable-type";
	/** vpeBL[ - Px^̉̌ */
	public static final String PKEY_SINGLE_PREC_FIGURES = "single-prec-figures";
	/** vpeBL[ - {x^̉̌ */
	public static final String PKEY_DOUBLE_PREC_FIGURES = "double-prec-figures";
	/** vpeBL[ - t@CVXe */
	public static final String PKEY_FILESYSTEM_CLASSNAME = "filesystem-class-name";
	/** vpeBL[ - GOSUB`RETURÑlXgEl */
	public static final String PKEY_NEST_LIMIT_GOSUB_RETURN = "nest-limit-gosub-return";
	/** vpeBL[ - FOR`NEXT̃lXgEl */
	public static final String PKEY_NEST_LIMIT_FOR_NEXT = "nest-limit-for-next";
	/** vpeBL[ - mۂz̃TCY(e) */
	public static final String PKEY_ARRAY_AUTO_ALLOCATION_CAPACITY = "array-auto-allocation-capacity";
	/** vpeBL[ - _ZCuNɏ邩 */
	public static final String PKEY_MATHPACK_INIT_ON_STARTUP = "mathpack-init-on-startup";
	/** vpeBL[ - ttH[}bg */
	public static final String PKEY_DATE_FORMAT = "date-format";
	/** vpeBL[ - tH[}bg */
	public static final String PKEY_TIME_FORMAT = "time-format";

	/** fobO[h(true:fobOON / false:fobOOFF) */
	public boolean debug = false;
	/** fobOo͐ */
	public PrintStream log;
	/** ̐K\L[h(true:ON / false:OFF) */
	public boolean regexp = true;
	/** ftHg̕ϐ^(1: 11:Px 12:{x 100:) */
	public int vartype = Token.VTYPE_SGL;
	/** ftHg̒Px^̉̌ */
	public int singlePrecisionFigures = 7;
	/** ftHg̔{x^̉̌ */
	public int doublePrecisionFigures = singlePrecisionFigures * 2;
	/** t@CVXe */
	public PetitBasicFileSystem fileSystem;

	/** GOSUB`RETURÑlXgEl */
	public int nestLimitGosubReturn;
	/** FOR`NEXT̃lXgEl */
	public int nestLimitForNext;
	/** mۂz̃TCY(e) */
	public int arrayAutoAllocationCapacity;
	/** _ZCu萔Nɏ邩(true: / false:Ȃ) */
	public boolean mathpackInitOnStartup = false;
	/** _ZCu */
	public Mathpack mathpack;
	/** ttH[}bg */
	public SimpleDateFormat dateFormat = null;
	/** tH[}bg */
	public SimpleDateFormat timeFormat = null;

	/**
	 * RXgN^D
	 * @param prop vpeB
	 */
	public BasicRuntimeConfig(Properties prop) {
		init(prop);
	}
	/**
	 * vpeBRs[D
	 * @param prop vpeB
	 */
	protected void init(Properties prop) {
		for(Iterator it = prop.keySet().iterator(); it.hasNext();) {
			String key = it.next().toString();
			String value = prop.getProperty(key);

			// debug
			if(PKEY_DEBUG.equals(key)) {
				debug = Boolean.valueOf(value).booleanValue();
			// regexp
			} else if(PKEY_REGEXP.equals(key)) {
				regexp = Boolean.valueOf(value).booleanValue();
			// variable-type
			} else if(PKEY_VARTYPE.equals(key)) {
				vartype = Integer.parseInt(value);
			// single-prec-figures
			} else if(PKEY_SINGLE_PREC_FIGURES.equals(key)) {
				singlePrecisionFigures = Integer.parseInt(value);
			// double-prec-figures
			} else if(PKEY_DOUBLE_PREC_FIGURES.equals(key)) {
				doublePrecisionFigures = Integer.parseInt(value);
			// nest-limit-gosub-return
			} else if(PKEY_NEST_LIMIT_GOSUB_RETURN.equals(key)) {
				nestLimitGosubReturn = Integer.parseInt(value);
			// nest-limit-for-next
			} else if(PKEY_NEST_LIMIT_FOR_NEXT.equals(key)) {
				nestLimitForNext = Integer.parseInt(value);
			// array-auto-allocation-capacity
			} else if(PKEY_ARRAY_AUTO_ALLOCATION_CAPACITY.equals(key)) {
				arrayAutoAllocationCapacity = Integer.parseInt(value);
			// mathpack-init-on-startup
			} else if(PKEY_MATHPACK_INIT_ON_STARTUP.equals(key)) {
				mathpackInitOnStartup = Boolean.valueOf(value).booleanValue();
			// date-format
			} else if(PKEY_DATE_FORMAT.equals(key)) {
				dateFormat = new SimpleDateFormat(value);
			// time-format
			} else if(PKEY_TIME_FORMAT.equals(key)) {
				timeFormat = new SimpleDateFormat(value);
			// filesystem-classname
			} else if(PKEY_FILESYSTEM_CLASSNAME.equals(key)) {
				try {
					fileSystem = (PetitBasicFileSystem)Class.forName(value).newInstance();
				} catch(Exception e) {
					// t@CVXeɎs
					e.printStackTrace();
				}
			}
		}
		// _ZpbP[W̍쐬
		mathpack = Mathpack.getInstance(this);
	}
}
