/*
 * $Id: Wait.java,v 1.1 2009/05/10 13:23:37 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * WAIT߁D
 * <br><pre>
 * @\FEFCg[hݒ肵܂D
 * ʁFR}h<br>
 * FWAIT <[h>
 * @@@[h0: L[h(m[EFCg)
 * @@@[h1: [h(t[䎞1ms̃EFCg)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Wait implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line);
		Token value = expr.eval();
		
		if(value == null ||value.getType() != Token.TYPE_LITERAL) {
			// sĂ
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}
		
		int mode = (int)OperationUtils.castValueType(value, Token.VTYPE_INT, ctx).getIntValue();
		boolean nowaitOpt = false;
		switch(mode) {
			// L[h
			case 0: nowaitOpt = true; break;
			// [h
			case 1: nowaitOpt = false; break;
			default:
				throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
		}
		
		env.nowait = nowaitOpt;
		
		return null;
	}

}
