/*
 * $Id: StringDL.java,v 1.1 2009/05/10 13:23:37 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * STRING$֐D
 * <br><pre>
 * @\Fw肵̕擾D
 * ʁF֐<br>
 * FSTRING$(<>,{|ASCIIR[h})
 * ᕶFA$=STRING$(10,"A")
 * @@@A$=STRING$(10,65)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class StringDL implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token lengthToken = expr.eval();
		Token argToken = expr.eval();
		
		if(lengthToken == null || argToken == null) {
			// sĂ
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		} else if(
			!expr.isTerminated() ||
			lengthToken.getType() != Token.TYPE_LITERAL ||
			argToken.getType() != Token.TYPE_LITERAL
		) {
			// 邩C萔ȊO
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		int length = (int)OperationUtils.castValueType(lengthToken, Token.VTYPE_INT, ctx).getIntValue();
		char c = '\u0000';
		if(argToken.getValueType() == Token.VTYPE_STR) {
			// 2̏ꍇ
			c = argToken.getStrValue().charAt(0);
		} else {
			// 2ȊȌꍇ
			c = (char)OperationUtils.castValueType(argToken, Token.VTYPE_INT, ctx).getIntValue();
		}
		
		// w肳ꂽ̕𐶐
		String value = StringUtils.sequence(c, length);

		// ߂l쐬
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_STR);
		token.setStrValue(value);
		
		return token;
	}
}
