/*
 * $Id: Sin.java,v 1.2 2007/03/09 19:22:30 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * SIN֐D
 * <br><pre>
 * @\F̐(SIN)vZD
 * ʁF֐<br>
 * FSIN(<>)
 * ᕶFA=SIN(90)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Sin implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		// ̌^ϊ
		Token value = OperationUtils.castValueType(token, Token.VTYPE_DBL, ctx);
		
		// ߎlvZ
		Real r = env.config.mathpack.fp_SIN(value.getRealValue());

		// vZʂ͏ɔ{x
		Token a = new Token(Token.TYPE_LITERAL);
		a.setRealValue(r);
		a.setValueType(Token.VTYPE_DBL);

		return a;
	}

}
