/*
 * $Id: Sgn.java,v 1.2 2008/11/12 18:01:05 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * SGN֐D
 * <br><pre>
 * @\F̒l̕ԂD
 * @@@̒l̐̏ꍇC0ԂD
 * @@@̒l̐̏ꍇC-1ԂD
 * @@@̒l0̏ꍇC0ԂD
 * ʁF֐<br>
 * FSGN(<>)
 * ᕶFA=SGN(-3.14159)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class Sgn implements BuiltinCommand {

	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		
		if(token == null || expr.isTerminated() == false) {
			// ̐s
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		Token arg = OperationUtils.castValueType(token, Token.VTYPE_DBL, ctx);
		Real value = arg.getRealValue();
		
		Token rc = new Token(Token.TYPE_LITERAL);
		rc.setValueType(Token.VTYPE_INT);

		if(value.isZero()) {
			// 0
			rc.setIntValue(0L);
		} else if(value.isPositive()) {
			// ̐
			rc.setIntValue(1);
		} else {
			// ̐
			rc.setIntValue(-1);
		}

		return rc;
	}

}
