/*
 * $Id: Save.java,v 1.3 2006/12/10 15:23:06 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.fs.PetitBasicFileSystem;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * SAVE߁D
 * <br><pre>
 * @\FBASICvOۑD
 * ʁFR}h<br>
 * FSAVE <filename>
 * ᕶFSAVE "sample.bas"
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Save implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("SAVER}hsJn");

		// sԍ̕]
		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();

		if(
			token.getType() != Token.TYPE_LITERAL ||
			OperationUtils.isStringValueType(token.getValueType(), env.getDefaultValueType()) == false
		) {
			// ȊOꍇ
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
		} else if(StringUtils.isEmpty(token.getStrValue().trim())) {
			throw new BasicLanguageException(ErrorCodeConstant.BAD_FILE_NAME, -1);
		}

		PetitBasicFileSystem pbfs = ctx.config.fileSystem;
		String filename = token.getStrValue();

		// ۑ
		try {
			pbfs.save(filename, env.getProgramData());
		} catch(FileNotFoundException nfe) {
			// t@CȂ
			throw new BasicLanguageException(ErrorCodeConstant.FILE_NOT_FOUND, -1, nfe);
		} catch(IOException ioe) {
			// o̓G[
			throw new BasicLanguageException(ErrorCodeConstant.DISK_IO_ERROR, -1, ioe);
		} catch(Exception e) {
			// G[
			throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1, e);
		}
		ctx.config.log.println("SAVER}hsI");
		return null;
	}

}
