/*
 * $Id: HexDL.java,v 1.2 2006/10/21 08:55:30 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.common.util.NumberUtils;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * HEX$֐D
 * <br><pre>
 * @\FɎw肳ꂽ16i\()ԂD
 * ʁF֐<br>
 * FHEX$(<>)
 * ᕶFA$=HEX$(255)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class HexDL implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("HEX$֐sJn");

		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		if(token.getType() == Token.TYPE_LITERAL == false) {
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, -1);
		}

		int intval = OperationUtils.intValue(token, ctx);

		Token answer = new Token(Token.TYPE_LITERAL);
		answer.setValueType(Token.VTYPE_STR);
		answer.setStrValue(NumberUtils.intValueToHexString(intval).toUpperCase());

		ctx.config.log.println("HEX$֐sI");

		return answer;
	}

}
