/*
 * $Id: Error.java,v 1.1 2007/12/03 17:30:22 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * ERRORD
 * <br><pre>
 * @\Fw肳ꂽԍ̃G[𔭐D
 * ʁFXe[gg<br/>
 * FERROR <G[R[h>
 * ᕶFERROR 2
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Error implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line);
		Token token = expr.eval();
		
		if(token == null) {
			// Ȃ
			throw new BasicLanguageException(ErrorCodeConstant.MISSING_OPERAND, line.getLineno());
		}

		Token param = OperationUtils.castValueType(token, Token.VTYPE_INT, ctx);
		long errorCode = param.getIntValue();
		
		if(errorCode < 0 || errorCode > 255) {
			// ͈̔͂s
			throw new BasicLanguageException(ErrorCodeConstant.ARGUMENT_OUT_OF_RANGE, line.getLineno());
		}
		
		// G[𔭐
		throw new BasicLanguageException((int)errorCode, line.getLineno());
	}

}
