/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ChrDL.java,v 1.4 2006/10/25 14:17:10 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * CHR$֐D
 * <br><pre>
 * @\FɎw肳ꂽASCIIR[h̃LN^ԂD
 * ʁF֐<br>
 * FCHR$(<ASCIIR[h>)
 * ᕶFA$=CHR$(255)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class ChrDL implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("CHR$֐sJn");

		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		if(token.getType() != Token.TYPE_LITERAL) {
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, -1);
		}

		int characterCode = OperationUtils.intValue(token, ctx);
		if(characterCode < 0 || characterCode > 255) {
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, -1);
		}

		String character = new String(new char[] {(char)characterCode});

		Token answer = new Token(Token.TYPE_LITERAL);
		answer.setValueType(Token.VTYPE_STR);
		answer.setStrValue(character);

		ctx.config.log.println("CHR$֐sI");

		return answer;
	}
}
