package gnu.javax.sound.sampled.wce;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;

public abstract class WCEDataLine extends WCELine implements DataLine {
	/**
	 * ݂̃tH[}bg
	 */
	private AudioFormat audioFormat;

	/**
	 * sǂ
	 */
	private boolean runningFlag;
	
	public WCEDataLine(DataLine.Info info) {
		super(info);
	}
	
	public boolean isRunning() {
		return this.runningFlag;
	}

	public void start() {
		this.runningFlag = true;
	}
	
	public void stop() {
		this.runningFlag = false;
	}
	
	/**
	 * ݂̃tH[}bgݒ肷
	 */
	protected void setFormat(AudioFormat format) {
		this.audioFormat = format;
	}
	
	public AudioFormat getFormat() {
		AudioFormat result = null;
		if (this.audioFormat != null) {
			result = this.audioFormat;
		} else {
			Line.Info info = getLineInfo();
			if (info instanceof DataLine.Info) {
				DataLine.Info dinfo = (DataLine.Info) info;
				AudioFormat[] formats = dinfo.getFormats();
				if (formats.length > 0) {
					// Ō̃tH[}bgݒ肷
					result = formats[formats.length - 1];
				}
			}
		}
		if (result == null) {
			result = getDefaultFormat();
		}
		return result;
	}
	
	/**
	 * ftHg̃I[fBItH[}bgԂ
	 */
	protected static AudioFormat getDefaultFormat() {
		return new AudioFormat(8000.0f,		// 8KHz
							   8,			// 8rbg
							   1,			// m
							   false,		// Ȃ
							   false);		// gGfBA
	}
	
}
