/* gnu_java_awt_peer_wce_WCEListPeer.c
   Copyright (C) 2005-2006 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */
#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCELabelPeer.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    createNative
 * Signature: (IIIIIZ)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_createNativeList(JNIEnv *env, jobject peer_obj, jint parentWindowHandle, jint x, jint y, jint width, jint height, jboolean multi) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	return (jint) create_native_list(peer_obj, (HWND) parentWindowHandle, x, y, width, height, (BOOL) multi);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    addNative
 * Signature: (ILjava/lang/String;I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_addNative(JNIEnv *env, jobject peer_obj, jint windowHandle, jstring item, jint index) {
	_TCHAR* buff = get_string_chars(env, item);
	SendMessage((HWND) windowHandle, LB_INSERTSTRING, (WPARAM) index, (LPARAM) buff);
	free(buff);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    delItemsNative
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_delItemsNative(JNIEnv *env, jobject peer_obj, jint windowHandle, jint start, jint end) {
	jint i;
	for (i = end; i >= start; --i) {
		SendMessage((HWND) windowHandle,
					LB_DELETESTRING,
					(WPARAM) i,
					0);
	}
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    deselectNative
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_deselectNative(JNIEnv *env, jobject peer_obj, jint windowHandle, jint index) {
	SendMessage((HWND) windowHandle, LB_SETSEL, (WPARAM) FALSE, (LPARAM) index);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    getNativeSelectedIndexes
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_getNativeSelectedIndexes(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	int count = (int) SendMessage((HWND) windowHandle, LB_GETCOUNT, 0, 0);
	int* indexes = (int*) malloc(sizeof(int) * count);
	int i, selected_count = 0;
	jintArray result;
	int* elements;

	// IĂCfbNX𒲂ׂ
	for (i = 0; i < count; ++i) {
		if ((indexes[i] = SendMessage((HWND) windowHandle, LB_GETSEL, (WPARAM) i, 0)) != 0) {
			// IĂ鍀ڂ𐔂
			selected_count++;
		}
	}
	
	// zmۂ
	result = (jintArray) (*env)->NewIntArray(env, selected_count);
	if (result != NULL) {
		int elem_index = 0;
		elements = (*env)->GetIntArrayElements(env, result, NULL);
		for (i = 0; i < count; ++i) {
			if (indexes[i]) {
				// IĂ鍀ڂ̃CfbNX
				elements[elem_index] = i;
				assert(elem_index < selected_count);
				elem_index++;
			}
		}
		(*env)->ReleaseIntArrayElements(env, result, elements, 0);
	}
	return result;
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    makeNativeVisible
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_makeNativeVisible(JNIEnv *env, jobject peer_obj, jint windowHandle, jint index) {
	SendMessage((HWND) windowHandle, LB_SETTOPINDEX, (WPARAM) index, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    removeNativeAll
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_removeNativeAll(JNIEnv *env, jobject peer_obj, jint windowHandle) {
	SendMessage((HWND) windowHandle, LB_RESETCONTENT, 0, 0);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    selectNative
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_selectNative(JNIEnv *env, jobject peer_obj, jint windowHandle, jint index) {
	SendMessage((HWND) windowHandle, LB_SETSEL, (WPARAM) TRUE, (LPARAM) index);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    setNativeMultipleMode
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_setNativeMultipleMode(JNIEnv *env, jobject peer_obj, jint windowHandle, jboolean multi) {
	// ̃R[h͐삵ȂB
	// LBS_MULTIPLESELSetWindowLong()Őݒ肵Ăʂ悤ł
	// http://msdn.microsoft.com/library/default.asp?url=/library/en-us/shellcc/platform/commctls/listboxes/listboxreference/listboxstyles.asp
	// Xg{bNXč쐬ɂ
	DWORD style;
	assert(windowHandle);
	style = (DWORD) GetWindowLong((HWND) windowHandle, GWL_STYLE);
	if (multi) {
		style |= LBS_MULTIPLESEL;
	} else {
		style &= ~LBS_MULTIPLESEL;
	}
	SetWindowLong((HWND) windowHandle, GWL_STYLE, (LONG) style);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    getNativeMinimumSize
 * Signature: (II)Ljava/awt/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_getNativeMinimumSize(JNIEnv *env, jobject peer_obj, jint windowHandle, int s) {
	SIZE size;
	int cx_vscroll, cx_border, cy_border, width, height;
	jclass dimension;
	jmethodID constructor_id;

	// VXe擾
	cx_vscroll = GetSystemMetrics(SM_CXVSCROLL);	// XN[o[̉
	cx_border = GetSystemMetrics(SM_CXBORDER);		// {[_[̉
	cy_border = GetSystemMetrics(SM_CYBORDER);		// {[_[̏c

	// ̍vZ
	get_text_extent_point((HWND) windowHandle, _T("A"), &size);
	
	// KvƂȂTCYvZ
	width = cx_border + cx_vscroll;
	height = (int) (size.cy * 1.05) * s + cy_border * 2;

	dimension = (*env)->FindClass(env, "java/awt/Dimension");
	constructor_id = (*env)->GetMethodID(env,
											   dimension,
											   "<init>",
											   "(II)V");
	return (*env)->NewObject(env,
							 dimension,
							 constructor_id,
							 width,
							 height);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEListPeer
 * Method:    getNativePreferredSize
 * Signature: (II)Ljava/awt/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEListPeer_getNativePreferredSize(JNIEnv *env, jobject peer_obj, jint windowHandle, int s) {
	SIZE size;
	int cx_vscroll, cx_border, cy_border, width, height;
	jclass dimension;
	jmethodID constructor_id;

	// VXe擾
	cx_vscroll = GetSystemMetrics(SM_CXVSCROLL);	// XN[o[̉
	cx_border = GetSystemMetrics(SM_CXBORDER);		// {[_[̉
	cy_border = GetSystemMetrics(SM_CYBORDER);		// {[_[̏c

	// ̍vZ
	get_text_extent_point((HWND) windowHandle, _T("A"), &size);
	
	// KvƂȂTCYvZ
	width = cx_border + cx_vscroll + size.cx * 20;
	height = (int) (size.cy * 1.05) * s + cy_border * 2;

	dimension = (*env)->FindClass(env, "java/awt/Dimension");
	constructor_id = (*env)->GetMethodID(env,
										 dimension,
										 "<init>",
										  "(II)V");
	return (*env)->NewObject(env,
							 dimension,
							 constructor_id,
							 width,
							 height);
}
