#ifndef COMMON_FUNCS_H_INCLUDED
#define COMMON_FUNCS_H_INCLUDED

#include <windows.h>
#include "java_utf8.h"

/**
 * vIG[ɕ\郁bZ[W萔
 */
#define	FATAL_ERROR_NO_MEMORY	((_TCHAR*)0x80000001)

/**
 * vIȃG[Ƃ_CAO{bNX\A
 * vOI
 */
void fatal_error(const _TCHAR* msg);

/**
 * fobOo̓}N
 */
#ifdef DEBUG

extern void dbg_utf8(java_utf8* msg);
extern void dbg_int(int);
extern void dbg_uint(unsigned int);

#define	DBG(s)			OutputDebugString(s)
#define DBG_UTF8(utf8)	dbg_utf8(utf8)
#define DBG_INT(i)		dbg_int(i)
#define DBG_UINT(i)		dbg_uint(i)

#else

#define DBG(s)			__noop
#define DBG_UTF8(utf8)	__noop
#define DBG_INT			__noop
#define DBG_UINT		__noop

#endif


/**
 * big-endian  little-endian ɕϊ
 */
#define TO_LITTLE_ENDIAN(value) \
	(((value) << 24) | (((value) & 0xff00) << 8) | (((value) & 0xff0000) >> 8) | ((value & 0xff000000) >> 24))

/**
 * w肳ꂽϐ̂A"1"ƂȂĂrbg̐𐔂
 *
 * http://www.nminoru.jp/~nminoru/programming/bitcount.html
 * ̈p
 */
inline int count_bits(__int32 bits) {
  bits = (bits & 0x55555555) + (bits >> 1 & 0x55555555);
  bits = (bits & 0x33333333) + (bits >> 2 & 0x33333333);
  bits = (bits & 0x0f0f0f0f) + (bits >> 4 & 0x0f0f0f0f);
  bits = (bits & 0x00ff00ff) + (bits >> 8 & 0x00ff00ff);
  return (bits & 0x0000ffff) + (bits >>16 & 0x0000ffff);
}

/**
 * w肳ꂽϐNTZ (Number of Training Zero)߂
 *
 * http://www.nminoru.jp/~nminoru/programming/bitcount.html
 * ̈p
 */
inline int get_number_of_training_zero(__int32 bits) {
	return count_bits((bits & (-bits)) - 1);
}

/**
 * ŉʃrbgNA
 */
inline __int32 clear_LSB(__int32 bits) {
	return bits & ((unsigned __int32) bits - 1);
}

/**
 * JVM̃o[WԂ
 */
LARGE_INTEGER get_jvm_version();

#endif