/* ClassFile.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/


#ifndef CLASSFILE_H_INCLUDED
#define CLASSFILE_H_INCLUDED

/**
 * NXt@C̃f[^`
 */
typedef unsigned __int8		u1;
typedef unsigned __int16	u2;
typedef unsigned __int32	u4;

#include "java_utf8.h"

/**
 * OQ
 */
struct ClassFile;
struct class_loader;
struct static_data_status;

/**
 * frame\
 */
struct frame;

/**
 * RX^gEv[\
 */
struct cp_info {
};

/**
 * RX^gEv[tagɓl
 */
#define	CONSTANT_Utf8				1
#define	CONSTANT_Integer			3
#define CONSTANT_Float				4
#define CONSTANT_Long				5
#define CONSTANT_Double				6
#define CONSTANT_Class				7
#define	CONSTANT_String				8
#define	CONSTANT_Fieldref			9
#define CONSTANT_Methodref			10
#define CONSTANT_InterfaceMethodref	11
#define	CONSTANT_NameAndType		12

// RX^gEv[tagl܂

/**
 * tB[hQƏ
 */
struct CONSTANT_Fieldref_info {
	/**
	 * NX̖O
	 */
	java_utf8*	class_name;

	/**
	 * tB[h̖O
	 */
	java_utf8*	field_name;

	/**
	 * tB[hfBXNv^
	 */
	java_utf8*	field_descriptor;

	/**
	 * tB[hێĂClassFile
	 */
	ClassFile*	class_file;

	/**
	 * ΉtB[hID
	 */
	jfieldID	field_id;

	/**
	 * tB[h̃IuWFNgɂʒu
	 */
	unsigned int field_position;
};

/**
 * \bhQƏ
 */
struct CONSTANT_Methodref_info {
	/**
	 * NX̖O
	 */
	java_utf8* class_name;

	/**
	 * \bh̖O
	 */
	java_utf8* method_name;

	/**
	 * \bh̃fBXNv^
	 */
	java_utf8* method_descriptor;
	
	/**
	 * p[^
	 */
	int parameters_count;

	/**
	 * QƐClassFile \
	 */
	ClassFile* class_file;

	/**
	 * \bhIDLbV
	 */
	jmethodID	mid;
};

/**
 * StringIuWFNgQƏ
 */
//struct CONSTANT_String_info {
//	/**
//	 * UTF-8
//	 */
//	java_utf8*	utf8;
//
//	/**
//	 * ΉStringIuWFNg̎QƁB݂ȂꍇNULL
//	 */
//	jobject string_reference;
//};

/**
 * 
 */
struct attribute_info {
};

/**
 * OnhiR[hAgr[g̈ꕔj
 */
typedef struct exception_handler_info_t {
	u2 start_pc;
    u2 end_pc;
    u2 handler_pc;
    u2 catch_type;
} exception_handler_info;

/**
 * LineNumberTableAgr[g̗vf
 */
struct line_number_table {
	u2 start_pc;	     
	u2 line_number;
};

/**
 * LineNumberTableAgr[g
 */
struct LineNumberTable_attribute {
	/**
	 * e[u
	 */
    u2 line_number_table_length;

	/**
	 * se[u
	 */
	line_number_table* table;
};

/**
 * R[hAgr[g
 */
struct Code_attribute {
    u2 max_stack;
    u2 max_locals;
    u4 code_length;
    u1* code;
    u2 exception_table_length;
    exception_handler_info* exception_table;

	LineNumberTable_attribute* linenumbertable_attribute;
};

/**
 * OAgr[g
 */
struct Exceptions_attribute {
	u2 number_of_exceptions;
	u2* exception_index_table;
};

/**
 * NXAgr[g
 */
struct classes_info {
	u2 inner_class_info_index;	     
	u2 outer_class_info_index;	     
	u2 inner_name_index;	     
	u2 inner_class_access_flags;	     
};

struct InnerClasses_attribute {
    u2 number_of_classes;
	classes_info* classes;
};

/**
 * tB[h
 */
struct field_info {
	/**
	 * tB[h
	 */
	java_utf8*	name;

	/**
	 * fBXNv^
	 */
	java_utf8* descriptor;

	/**
	 * tB[h錾ĂClassFile
	 */
	ClassFile* declaring_ClassFile;

	/**
	 * ANZXtO
	 */
	u2 access_flags;

	/**
	 * constant_pool̃CfbNXlB
	 */
	u2 constantvalue_index;

	/**
	 * NXIuWFNg܂̓CX^Xf[^ł̈ʒu
	 * etB[h̃TCYEɔzuB
	 */
	u2 position;

	/**
	 * SignaturẽCfbNX
	 */
	u2 signature_index;

	/**
	 * NXIuWFNg܂̓CX^Xf[^Ő߂TCYioCgPʁj
	 */
	u1 size;
};

/**
 * tB[he[uBȉ̏Ǘ
 * Efield_info\
 * EtB[hɎQƒlĂ邩ǂi4oCgPʁj
 */
struct field_table {
	/**
	 * StB[h
	 */
	u2 fields_count;
	
	/**
	 * TCYioCgPʁj
	 */
	u2 total_size;
	
	/**
	 * tB[he[u̗vf
	 */
	field_info**	elements;

   /**
	* QƒlĂ邩ǂ̃tOi32rbgPʁj
	*/
	bool* reference_flags;
};

/**
 * \bh
 */
struct method_info {
	/**
	 * ANZXtO
	 */
	u2 access_flags;

	/**
	 * SignaturẽCfbNX
	 */
	u2 signature_index;

	/**
	 * \bh
	 */
	const java_utf8*	name;
	
	/**
	 * fBXNv^
	 */
	const java_utf8* descriptor;
	
	/**
	 * R[hAgr[g
	 * lCeBu\bh̏ꍇ́AlCeBu֐̃|C^
	 */
	Code_attribute* code_attribute;
	
	/**
	 * OAgr[g
	 */
	Exceptions_attribute* exceptions_attribute;

	/**
	 * p[^iRQrbgPʁj
	 */
	int parameters_count;

	/**
	 * ߂l̃^Cv
	 */
	const java_utf8* return_type;

	/**
	 * method_infoێĂClassFile
	 */
	ClassFile*		declaring_ClassFile;

};

/**
 * \bhEe[u
 * NXۗLȉ̃CX^X\bhɊւێ
 * Eg̃\bĥAȉ̏𖞂\bh
 *   <init>\bhł͂Ȃ
 *   private\bhł͂Ȃ
 * EX[p[NX̂Aȉ̏𖞂\bh
 *   <init>\bhłȂ
 *   private\bhł͂Ȃ
 *
 * X[p[NX̃\bhe[u̕яƁA
 * hNX̃\bhe[u̕я͓ɂKvB
 */
struct method_table {
	/**
	 * \bh
	 */
	u2 methods_count;
	
	/**
	 * vf
	 */
	method_info** elements;

};

/**
 * NXt@C̃Xe[^X
 */
enum ClassFileStatus {
	CLASS_FILE_LOADING,			// [h
	CLASS_FILE_LOADED,			// [hꂽ
	CLASS_FILE_VERIFYING,		// xt@C
	CLASS_FILE_VERIFIED			// xt@C
};

/**
 * NXt@C
 */
struct ClassFile {
	/**
	 * `[_
	 */
	class_loader*	defining_loader;
	
	/**
	 * staticf[^̏
	 */
	static_data_status* static_data_stat;

	/**
	 * ANZXtOBACC_* 萔gp
	 */
	u2 access_flags;

	/**
	 * RX^gv[̐
	 */
	u2 constant_pool_count;

	/**
	 * RX^gv[B
	 * z̓Y1constant_pool_count-1܂łLȒlƂȂB
	 * Y0͎gpĂȂ߁Az}VIɎgp邱ƂƂB
	 */
	cp_info** constant_pool;
	
	/**
	 * RX^gv[tag
	 */
	u1* constant_pool_tags;

	/**
	 * ̃NXB
	 */
	const java_utf8* this_class_name;

	/**
	 * X[p[NXB
	 */
	const java_utf8* super_class_name;

	/**
	 * ̃NXĂC^tF[XARX^gv[̃CfbNXl
	 */
	u2* interfaces;

	/**
	 * ̃NXĂC^tF[X̐
	 */
	u2 interfaces_count;

	/**
	 * ̃NX̃tB[h
	 */
	u2 fields_count;

	/**
	 * ̃NX̃\bh
	 */
	u2 methods_count;

	/**
	 * \[Xt@C̃CfbNX
	 */
	u2 sourcefile_index;
	
	/**
	 * SignaturẽCfbNX
	 */
	u2 signature_index;

	/**
	 * ̃NX̃tB[h
	 */
	field_info* fields;

	/**
	 * ̃NX̃\bh
	 */
	method_info* methods;

	/**
	 * InnerClassesAgr[g
	 */
	InnerClasses_attribute* innerclasses_attribute;
	
	/**
	 * ̃NXt@C̃Xe[^X
	 */
	ClassFileStatus status;

	/**
	 * statictB[he[u
	 */
	field_table static_field_table;

	/**
	 * CX^XtB[he[u
	 */
	field_table instance_field_table;

	/**
	 * \bhe[u
	 */
	method_table mtable;

	/**
	 * ̃NXt@CiCUۗLĂꍇtrue
	 */
	bool has_finalizer;
	
	/**
	 * X[p[NXClassFile
	 */
	ClassFile* superclass_ClassFile;

	/**
	 * C^tF[XClassFile
	 */
	ClassFile** interfaces_ClassFiles;

};

/**
 * ANZXtO萔
 */
#define ACC_PUBLIC			0x0001
#define ACC_PRIVATE			0x0002
#define ACC_PROTECTED		0x0004
#define ACC_STATIC			0x0008
#define ACC_FINAL			0x0010
#define ACC_SUPER			0x0020
#define ACC_SYNCHRONIZED	0x0020
#define ACC_VOLATILE		0x0040
#define ACC_BRIDGE			0x0040
#define ACC_TRANSIENT		0x0080
#define ACC_VARARGS			0x0080
#define ACC_NATIVE			0x0100
#define ACC_INTERFACE		0x0200
#define ACC_ABSTRACT		0x0400
#define ACC_STRICT			0x0800
#define ACC_SYNTHETIC		0x1000
#define ACC_ANNOTATION		0x2000
#define	ACC_ENUM			0x4000

/**
 * ANZXtO֐
 */
inline bool is_public(u2 access_flags) {
	return (access_flags & ACC_PUBLIC) != 0;
}

inline bool is_protected(u2 access_flags) {
	return (access_flags & ACC_PROTECTED) != 0;
}

inline bool is_private(u2 access_flags) {
	return (access_flags & ACC_PRIVATE) != 0;
}

inline bool is_static(u2 access_flags) {
	return (access_flags & ACC_STATIC) != 0;
}

inline bool is_interface(u2 access_flags) {
	return (access_flags & ACC_INTERFACE) != 0;
}

inline bool is_abstract(u2 access_flags) {
	return (access_flags & ACC_ABSTRACT) != 0;
}

inline bool is_synchronized(u2 access_flags) {
	return (access_flags & ACC_SYNCHRONIZED) != 0;
}

inline bool is_final(u2 access_flags) {
	return (access_flags & ACC_FINAL) != 0;
}

inline bool is_volatile(u2 access_flags) {
	return (access_flags & ACC_VOLATILE) != 0;
}

inline bool is_native(u2 access_flags) {
	return (access_flags & ACC_NATIVE) != 0;
}

/**
 * RX^gv[擾
 */
inline cp_info* get_cp_info(ClassFile* cfile, u2 index, u1 tag) {
	assert(index < cfile->constant_pool_count);
	cp_info* info = cfile->constant_pool[index];
	assert(info != NULL && cfile->constant_pool_tags[index] == tag);
	return info;
}

/**
 * w肳ꂽCfbNXɑΉ java_utf8 \̂ւ̃|C^
 * ԂB
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	java_utf8\̂ւ̃|C^B擾łȂꍇNULL
 */
inline java_utf8* get_java_utf8(ClassFile* cfile, u2 index) {
	return (java_utf8*) get_cp_info(cfile, index, CONSTANT_Utf8);
}

/**
 * w肳ꂽCfbNXɑΉ CONSTANT_Class_info \̂Œ`ꂽ
 * NXԂ
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	NX
 */
inline java_utf8* get_CONSTANT_Class_info(ClassFile* cfile, u2 index) {
	assert(cfile->constant_pool_tags[index] == CONSTANT_Class);
	cp_info* cinfo = get_cp_info(cfile, index, CONSTANT_Class);
	if ((unsigned int) cinfo & 0x80000000) {
		// ŏʃrbgĂꍇ́AłresolveꂽClassFile*ւ
		// |C^Ă
		ClassFile* cfile = (ClassFile*) ((unsigned int) cinfo & ~0x80000000);
		return cfile->this_class_name;
	} else {
		return get_java_utf8(cfile, (u2) cinfo); 
	}
}

/**
 * w肳ꂽCfbNXɑΉ CONSTANT_Fieldref_info \̂ւ̃|C^
 * ԂB
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	Fieldref_info\̂ւ̃|C^B擾łȂꍇNULL
 */
inline CONSTANT_Fieldref_info* get_CONSTANT_Fieldref_info(ClassFile* cfile, u2 index) {
	return (CONSTANT_Fieldref_info*) get_cp_info(cfile, index, CONSTANT_Fieldref);
}

/**
 * w肳ꂽCfbNXɑΉ Methodref_info \̂ւ̃|C^
 * ԂB
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	Methodref_info\̂ւ̃|C^B擾łȂꍇNULL
 */
inline CONSTANT_Methodref_info* get_CONSTANT_Methodref_info(ClassFile* cfile, u2 index) {
	return (CONSTANT_Methodref_info*) get_cp_info(cfile, index, CONSTANT_Methodref);
}

/**
 * R[hEAgr[g擾
 * lCeBu֐̏ꍇ́Aς݂̃lCeBu֐̃|C^ԂB
 */
inline Code_attribute* get_Code_attribute(ClassFile* cfile, method_info* minfo) {
	return minfo->code_attribute;
}


/**
 * ClassFile֘A̕ϐ
 */
void init_ClassFile_settings();

/**
 * w肳ꂽobt@̓ep[XClassFile\̂쐬
 *
 * @param	loader		NX[_
 * @param	buff		obt@
 * @param	buff_length	obt@TCY
 */
ClassFile* parse_ClassFile(frame* frm, class_loader* loader, const char* buff, size_t buff_length);

/**
 * w肳ꂽNXt@CɊ蓖ĂꂽJ
 */
void free_ClassFile(ClassFile* cfile);

/**
 * w肳ꂽCfbNXɑΉ CONSTANT_Class_info \̂Œ`ꂽ
 * NXԂ
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	NX
 */
const java_utf8* get_CONSTANT_Class_info(ClassFile* cfile, u2 index);

/**
 * w肳ꂽCfbNXɑΉ CONSTANT_Fieldref_info \̂ւ̃|C^
 * ԂB
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	Fieldref_info\̂ւ̃|C^B擾łȂꍇNULL
 */
CONSTANT_Fieldref_info* get_CONSTANT_Fieldref_info(ClassFile* cfile, u2 index);

/**
 * w肳ꂽCfbNXɑΉ Methodref_info \̂ւ̃|C^
 * ԂB
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	Methodref_info\̂ւ̃|C^B擾łȂꍇNULL
 */
CONSTANT_Methodref_info* get_CONSTANT_Methodref_info(ClassFile* cfile, u2 index);

/**
 * w肳ꂽCfbNXɑΉ java_utf8 \̂ւ̃|C^
 * ԂB
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	index	constant_pool̃CfbNXl
 * @return	java_utf8\̂ւ̃|C^B擾łȂꍇNULL
 */
java_utf8* get_java_utf8(ClassFile* cfile, u2 index);

/**
 * w肳ꂽtB[hIDɑΉCX^XtB[h
 * field_info \̂ւ̃|C^Ԃ
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	fid		tB[hID
 * @return	field_info\̂ւ̃|C^B擾łȂꍇNULLB
 */
field_info* get_field_info(ClassFile* cfile, jfieldID fid);
field_info* get_static_field_info(ClassFile* cfile, jfieldID fid);

/**
 * w肳ꂽCfbNXɑΉ method_info \̂ւ̃|C^ԂB
 *
 * @param	cfile	擾ΏۂƂȂClassFile\̂ւ̃|C^
 * @param	index	擾ΏۂƂȂmethod_info\̂̃CfbNX
 * @return	Ή method_info \̂ւ̃|C^B擾łȂꍇNULLB
 */
inline method_info* get_method_info(ClassFile* cfile, u2 index) {
	if (index >= cfile->methods_count) {
		return NULL;
	}
	return &cfile->methods[index];
}


/**
 * w肳ꂽmethod_info\̂ɑΉCode_attribute\̂ւ̃|C^ԂB
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	minfo	method_info\̂ւ̃|C^
 * @return	ΉCode_attribute\̂ւ̃|C^B擾łȂꍇNULL
 */
Code_attribute* get_Code_attribute(ClassFile* cfile, method_info* minfo);

/**
 * w肳ꂽ\bh̃p[^i[JϐKvƂȂ鐔jԂ
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	minfo	method_info\̂ւ̃|C^
 */
u2 get_parameters_count(method_info* minfo);
u2 get_parameters_count(CONSTANT_Methodref_info* methodref);

/**
 * w肳ꂽ\bhfBXNv^̃p[^߂
 * longdouble͂QƃJEg
 */
u2 parse_parameters_count(const java_utf8* mdesc);

/**
 * w肳ꂽ\bh̖߂l^CvԂB
 */
const char* get_return_type(method_info* minfo);

/**
 * w肳ꂽNX̖̂ԂB
 */
const java_utf8* get_class_name(ClassFile* cfile);

/**
 * w肳ꂽNX̃X[p[NXԂB
 * X[p[NX݂ȂꍇNULLԂB
 */
const java_utf8* get_super_class_name(ClassFile* cfile);

/**
 * w肳ꂽNXt@CɁAw肳ꂽOуfBXNv^\bh邩
 * 
 *
 * @param	cfile	ΏۂƂȂNXB
 * @param	name	ΏۂƂȂ郁\bh̖OB
 * @param	desc	ΏۂƂȂ郁\bh̃fBXNv^B
 * @return	ʁBv郁\bh݂ȂꍇNULLB
 */
method_info* find_declaring_method_info(ClassFile* cfile, const java_utf8* name, const java_utf8* desc);

/**
 * z̃NXt@C쐬
 *
 * @param	class_name	z̃NX
 * @return	ΉClassFile\̂ւ̃|C^
 */
ClassFile* create_array_ClassFile(class_loader* l, const java_utf8* class_name, u2 access_flags);

/**
 * v~eBuNXt@C쐬
 *
 * @param	class_name	v~eBuNX
 * @return	ΉClassFile\̂ւ̃|C^
 */
ClassFile* create_primitive_ClassFile(const java_utf8* class_name);

/**
 * NXt@C prepare s
 */
bool prepare_ClassFile(frame* current_frame,
					   ClassFile* cfile,
					   ClassFile* super_class_file,
					   ClassFile** interfaces);


/**
 * statictB[hIDԂ
 */
jfieldID get_static_field_id(ClassFile* cfile, const java_utf8* field_name, const java_utf8* field_desc);

/**
 * tB[hIDԂ
 */
jfieldID get_field_id(ClassFile* cfile, const java_utf8* field_name, const java_utf8* field_desc);

/**
 * w肳ꂽNXێĂstatictB[h̍vTCYԂB
 */
unsigned int get_static_fields_size(ClassFile* cfile);

/**
 * w肳ꂽNXێĂstatictB[h̍vTCYԂ
 */
unsigned int get_fields_size(ClassFile* cfile);

/**
 * w肳ꂽNX̃NXIuWFNgɂAut@XtOvԂB
 */
bool* get_static_field_reference_flags(ClassFile* cfile);

/**
 * w肳ꂽNX̃CX^Xf[^ɂAut@XtOvԂB
 */
bool* get_field_reference_flags(ClassFile* cfile);

/**
 * \bhIDԂ
 *
 */
jmethodID get_method_id(const ClassFile* cfile, const java_utf8* method_name, const java_utf8* method_desc);

/**
 * \bhIDɑΉmethod_infoԂB
 */
method_info* get_method_info(ClassFile* cfile, jmethodID mid);

/**
 * ̃NXt@CiCUĂ邩ԂB
 * Object.finalize()I[o[ChĂꍇAtrueԂB
 *
 * @param	cfile	NXt@C
 * @return	t@CiCUĂꍇtrueB
 */
inline bool has_finalizer(ClassFile* cfile) {
	return cfile->has_finalizer;
}

/**
 * w肳ꂽNXz^̃NXł邩Ԃ
 */
inline bool is_array_class(ClassFile* cfile) {
	return cfile->this_class_name[0] == '[';
}

/**
 * w肳ꂽNXv~eBu^zNXԂ
 */
inline bool is_primitive_array_class(ClassFile* cfile) {
	if (is_array_class(cfile)) {
		if (cfile->this_class_name[1] != '['
			&& cfile->this_class_name[1] != 'L') {
			return true;
		}
	}
	return false;
}

/**
 * w肳ꂽNX̍\vf\Ԃ
 * v~eBu^NX̏ꍇ́Aȉ̕ԂB
 * boolean^ - Z
 * char^ - C
 * short^ - S
 * int^ - I
 * long^ - J
 * float^ - F
 * double^ - D 
 * Qƌ^NX̏ꍇÃNXԂB
 * jzNX[java/lang/String; ̏ꍇAjava/lang/String ԂB
 * QjzNX [[I ̏ꍇA[I ԂB
 */
const java_utf8* get_array_component_name(ClassFile* cfile);
const java_utf8* get_array_component_name(const char* name);

/**
 * SourceFile_attributeԂB
 */
const java_utf8* get_SourceFile(ClassFile* cfile);

/**
 * LineNumberԂ
 */
int get_LineNumber(Code_attribute* code, unsigned int pc);

/**
 * w肳ꂽNXv~eBuNXԂB
 * v~eBuNX͈ȉ̂XނłB
 * void
 * boolean
 * byte
 * char
 * short
 * int
 * long
 * float
 * double
 *
 */
bool is_primitive_class_name(java_utf8* class_name);

/**
 * X[p[NXClassFile*\̂Ԃ
 */
inline ClassFile* get_superclass_ClassFile(ClassFile* cfile) {
	return cfile->superclass_ClassFile;
}

/**
 * w肳ꂽCfbNXɑΉC^tF[XClassFile\̂Ԃ
 */
inline ClassFile* get_interface_ClassFile(ClassFile* cfile, u2 index) {
	return cfile->interfaces_ClassFiles[index];
}

/**
 * nꂽ\bhfBXNv^Ƃ݂ȂA
 * g[N̒ԂB
 * g[NȂꍇ -1 ԂB
 */
int get_token_length_of_descriptor(const char* descriptor);

/**
 * w肳ꂽg[NNX𒊏oAintern ꂽɕϊ
 * Ԃ
 */
const java_utf8* intern_class_name(const char* token, int length);

/**
 * w肳ꂽNX from ANX target  access_flags 
 * NX^\bh^tB[hɃANZX\𔻒肷
 */
bool is_accessible(frame* current_frame, ClassFile* from, ClassFile* target, u2 access_flags);

/**
 * uʂȁv|C^ǂ𒲂ׂB
 * Windows Mobileł́AAvP[V2GBʂ̉zAhXԂ蓖ĂȂƂ
 * ˑĂ
 */
#define IS_SPECIAL_POINTER(p)		((unsigned int) (p) & 0x80000000)
#define MAKE_SPECIAL_POINTER(p)		((void*)((unsigned int) (p) | 0x80000000))
#define MAKE_NORMAL_POINTER(p)		((void*)((unsigned int) (p) & ~0x80000000))

/**
 * w肳ꂽconstant_pool_index wĂClassFileresolve
 */
ClassFile* resolve_ClassFile(frame* current_frame,
							 ClassFile* cfile,
							 u2 constant_pool_index);

/**
 * resolveꂽClassFileԂ
 */
inline ClassFile* get_resolved_ClassFile(ClassFile* cfile, u2 constant_pool_index) {
	assert(IS_SPECIAL_POINTER(cfile->constant_pool[constant_pool_index]));
	return (ClassFile*) MAKE_NORMAL_POINTER(cfile->constant_pool[constant_pool_index]);
}

/**
 * tB[hID, \bhID̃rbg}XN
 * LȃtB[hID͂̃rbg𗧂ĂĂB
 * (ȒlNULLƂ邽߂ɕKvj
 */
#define	FIELD_ID_MASK	0x80000000
#define METHOD_ID_MASK	0x80000000

/**
 * CfbNXltB[hIDɕϊ}N
 */
#define	INDEX_TO_FIELD_ID(i)	((jfieldID) (i | FIELD_ID_MASK))

/**
 * tB[hIDCfbNXlɕϊ}N
 */
#define	FIELD_ID_TO_INDEX(i)	((unsigned int)i & ~FIELD_ID_MASK)

/**
 * statictB[h񂪊i[ꂽtB[he[uԂ
 *
 * @return	tB[he[uBtB[he[uĂȂꍇNULL
 */
inline field_table* get_field_table(ClassFile* cfile) {
	return &cfile->instance_field_table;
}

/**
 * statictB[h񂪊i[ꂽtB[he[uԂB
 */
inline field_table* get_static_field_table(ClassFile* cfile) {
	return &cfile->static_field_table;
}

/**
 * w肳ꂽtB[hIDɑΉ field_info \̂ւ̃|C^Ԃ
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	fid		tB[hID
 * @return	field_info\̂ւ̃|C^B擾łȂꍇNULLB
 */
inline field_info* get_field_info(ClassFile* cfile, jfieldID fid) {
	field_table* tab = &cfile->instance_field_table;
	int index = FIELD_ID_TO_INDEX(fid);
	field_info* e = tab->elements[index];
	return e;
}

/**
 * w肳ꂽtB[hIDɑΉ field_info \̂ւ̃|C^Ԃ
 *
 * @param	cfile	ClassFile\̂ւ̃|C^
 * @param	fid		tB[hID
 * @return	field_info\̂ւ̃|C^B擾łȂꍇNULLB
 */
inline field_info* get_static_field_info(ClassFile* cfile, jfieldID fid) {
	field_table* tab = &cfile->static_field_table;
	int index = FIELD_ID_TO_INDEX(fid);
	field_info* e = tab->elements[index];
	return e;
}

/**
 * w肳ꂽClassFile\̂ɑΉmethod_tableԂB
 */
inline method_table* get_method_table(const ClassFile* cfile) {
	return &(((ClassFile*) (cfile))->mtable);
}

#endif